/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.gxp;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.inject.Inject;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.struts2.views.gxp.AbstractGxp;
import org.apache.struts2.views.gxp.Gxp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GxpInstance
extends Gxp {
    private static final Logger logger = Logger.getLogger(GxpInstance.class.getCanonicalName());
    private Class gxpInterface;
    private Class gxpInstance;
    private ObjectFactory objectFactory;
    private static final Map<Class, GxpInstance> classToGxpInstance = new MapMaker().weakKeys().softValues().makeComputingMap((Function)new Function<Class, GxpInstance>(){

        public GxpInstance apply(Class from) {
            return classToGxpInstance.containsKey(from) ? (GxpInstance)classToGxpInstance.get(from) : new GxpInstance(from);
        }
    });
    private static final Map<String, GxpInstance> pathToGxpInstance = new MapMaker().softValues().makeComputingMap((Function)new Function<String, GxpInstance>(){

        public GxpInstance apply(String from) {
            return pathToGxpInstance.containsKey(from) ? (GxpInstance)pathToGxpInstance.get(from) : GxpInstance.getInstance(AbstractGxp.getGxpClassForPath(from));
        }
    });

    GxpInstance(Class gxpClass) {
        super(gxpClass, GxpInstance.lookupMethodByName(GxpInstance.getNestedClass(gxpClass, "Interface"), "write"), GxpInstance.lookupMethodByName(GxpInstance.getNestedClass(gxpClass, "Interface"), "getGxpClosure"));
        this.gxpInterface = GxpInstance.getNestedClass(gxpClass, "Interface");
        this.gxpInstance = GxpInstance.getNestedClass(gxpClass, "Instance");
    }

    private static Class getNestedClass(Class clazz, String nestedClassName) {
        for (Class<?> nested : clazz.getDeclaredClasses()) {
            if (!nestedClassName.equals(nested.getSimpleName())) continue;
            return nested;
        }
        throw new IllegalArgumentException(String.format("Cannot find class %s.%s", clazz.getCanonicalName(), nestedClassName));
    }

    @Override
    protected Object getGxpInstance() {
        try {
            return this.objectFactory.buildBean(this.gxpInterface, null);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error instantiating {0}; trying {1}", new Object[]{this.gxpInterface.getCanonicalName(), this.gxpInstance.getCanonicalName()});
            try {
                return this.objectFactory.buildBean(this.gxpInstance, null);
            }
            catch (Exception e1) {
                throw new RuntimeException(String.format("Error instantiating %s", this.gxpInterface.getCanonicalName(), this.gxpInstance.getCanonicalName()), e1);
            }
        }
    }

    @Override
    public Class<?> getGxpClass() {
        return this.gxpInterface;
    }

    public static GxpInstance getInstance(String gxpPath) {
        try {
            return pathToGxpInstance.get(gxpPath);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof ClassNotFoundException) {
                return null;
            }
            throw e;
        }
    }

    public static GxpInstance getInstance(Class gxpClass) {
        return classToGxpInstance.get(gxpClass);
    }

    @Inject
    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }
}

