/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.struts;

import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.MessageResources;
import org.apache.velocity.tools.struts.StrutsUtils;
import org.apache.velocity.tools.view.context.ViewContext;

public abstract class MessageResourcesTool {
    protected static final Log LOG = LogFactory.getLog((Class)MessageResourcesTool.class);
    protected ServletContext application;
    protected HttpServletRequest request;
    protected Locale locale;
    protected MessageResources resources;

    public void init(Object obj) {
        if (!(obj instanceof ViewContext)) {
            throw new IllegalArgumentException("Tool can only be initialized with a ViewContext");
        }
        ViewContext context = (ViewContext)obj;
        this.request = context.getRequest();
        this.application = context.getServletContext();
        this.resources = StrutsUtils.getMessageResources(this.request, this.application);
        this.locale = StrutsUtils.getLocale(this.request, this.request.getSession(false));
    }

    protected MessageResources getResources(String bundle) {
        if (bundle == null) {
            if (this.resources == null) {
                LOG.error((Object)"Message resources are not available.");
            }
            return this.resources;
        }
        MessageResources res = StrutsUtils.getMessageResources(this.request, this.application, bundle);
        if (res == null) {
            LOG.error((Object)("MessageResources bundle '" + bundle + "' is not available."));
        }
        return res;
    }
}

