/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.rest;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.rest.ContentTypeHandlerManager;
import org.apache.struts2.rest.HttpHeaders;
import org.apache.struts2.rest.handler.ContentTypeHandler;

public class DefaultContentTypeHandlerManager
implements ContentTypeHandlerManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultContentTypeHandlerManager.class);
    Map<String, ContentTypeHandler> handlersByExtension = new HashMap<String, ContentTypeHandler>();
    Map<String, ContentTypeHandler> handlersByContentType = new HashMap<String, ContentTypeHandler>();
    private String defaultExtension;

    @Inject(value="struts.rest.defaultExtension")
    public void setDefaultExtension(String name) {
        this.defaultExtension = name;
    }

    @Inject
    public void setContainer(Container container) {
        Set names = container.getInstanceNames(ContentTypeHandler.class);
        for (String name : names) {
            ContentTypeHandler handler = (ContentTypeHandler)container.getInstance(ContentTypeHandler.class, name);
            if (handler.getExtension() != null) {
                String overrideName = (String)container.getInstance(String.class, "struts.rest.handlerOverride." + handler.getExtension());
                if (overrideName != null) {
                    if (this.handlersByExtension.containsKey(handler.getExtension())) continue;
                    handler = (ContentTypeHandler)container.getInstance(ContentTypeHandler.class, overrideName);
                }
                this.handlersByExtension.put(handler.getExtension(), handler);
            }
            if (handler.getContentType() == null) continue;
            String typeOnly = handler.getContentType();
            int index = handler.getContentType().indexOf(59);
            if (index != -1) {
                typeOnly = handler.getContentType().substring(0, index).trim();
            }
            this.handlersByContentType.put(typeOnly, handler);
        }
    }

    public ContentTypeHandler getHandlerForRequest(HttpServletRequest request) {
        ContentTypeHandler handler = null;
        String contentType = request.getContentType();
        if (contentType != null && (handler = this.handlersByContentType.get(contentType)) == null) {
            int index = contentType.indexOf(59);
            if (index != -1) {
                contentType = contentType.substring(0, index).trim();
            }
            handler = this.handlersByContentType.get(contentType);
        }
        if (handler == null) {
            String extension = this.findExtension(request.getRequestURI());
            handler = this.handlersByExtension.get(extension);
        }
        return handler;
    }

    public ContentTypeHandler getHandlerForResponse(HttpServletRequest request, HttpServletResponse res) {
        String extension = this.getExtensionIfPresent(request.getRequestURI());
        if (extension == null) {
            extension = this.defaultExtension;
            String acceptHeader = request.getHeader("accept");
            if (acceptHeader != null) {
                String[] types;
                for (String type : types = acceptHeader.split(",")) {
                    ContentTypeHandler handler = this.findHandler(type);
                    if (handler == null) continue;
                    return handler;
                }
            }
        }
        return this.handlersByExtension.get(extension);
    }

    private ContentTypeHandler findHandler(String type) {
        int index;
        ContentTypeHandler handler = this.handlersByContentType.get(type);
        if (handler == null && (index = type.indexOf(59)) != -1) {
            return this.handlersByContentType.get(type.substring(0, index).trim());
        }
        return handler;
    }

    public String handleResult(ActionConfig actionConfig, Object methodResult, Object target) throws IOException {
        LOG.warn("This method is deprecated!", new String[0]);
        return this.readResultCode(methodResult);
    }

    public String handleResult(ActionInvocation invocation, Object methodResult, Object target) throws IOException {
        ContentTypeHandler handler;
        String resultCode = this.readResultCode(methodResult);
        Integer statusCode = this.readStatusCode(methodResult);
        HttpServletRequest req = ServletActionContext.getRequest();
        HttpServletResponse res = ServletActionContext.getResponse();
        ActionConfig actionConfig = invocation.getProxy().getConfig();
        if (statusCode != null) {
            res.setStatus(statusCode.intValue());
        }
        if ((handler = this.getHandlerForResponse(req, res)) != null) {
            String extCode = resultCode + "." + handler.getExtension();
            if (actionConfig.getResults().get(extCode) != null) {
                resultCode = extCode;
            } else {
                StringWriter writer = new StringWriter();
                resultCode = handler.fromObject(invocation, target, resultCode, writer);
                String text = writer.toString();
                if (text.length() > 0) {
                    byte[] data = text.getBytes("UTF-8");
                    res.setContentLength(data.length);
                    res.setContentType(handler.getContentType());
                    res.getOutputStream().write(data);
                    res.getOutputStream().flush();
                }
            }
        }
        return resultCode;
    }

    protected Integer readStatusCode(Object methodResult) {
        if (methodResult instanceof HttpHeaders) {
            return ((HttpHeaders)methodResult).getStatus();
        }
        return null;
    }

    protected String readResultCode(Object methodResult) {
        if (methodResult == null) {
            return null;
        }
        if (methodResult instanceof HttpHeaders) {
            return ((HttpHeaders)methodResult).getResultCode();
        }
        return methodResult.toString();
    }

    public String getExtensionIfPresent(String url) {
        int slashPos;
        int dotPos = url.lastIndexOf(46);
        if (dotPos > (slashPos = url.lastIndexOf(47)) && dotPos > -1) {
            return url.substring(dotPos + 1);
        }
        return null;
    }

    public String findExtension(String url) {
        int slashPos;
        int dotPos = url.lastIndexOf(46);
        if (dotPos > (slashPos = url.lastIndexOf(47)) && dotPos > -1) {
            return url.substring(dotPos + 1);
        }
        return this.defaultExtension;
    }
}

