/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.XWorkConstants;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.apache.struts2.StrutsConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeprecationInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(DeprecationInterceptor.class);
    private Container container;
    private boolean devMode;

    public String intercept(ActionInvocation invocation) throws Exception {
        String message;
        if (this.devMode && (message = this.validate()) != null) {
            LOG.debug(message, new String[0]);
        }
        return invocation.invoke();
    }

    private String validate() throws Exception {
        HashSet<String> constants = new HashSet<String>();
        this.readConstants(constants, StrutsConstants.class);
        this.readConstants(constants, XWorkConstants.class);
        Set applicationConstants = this.container.getInstanceNames(String.class);
        String message = null;
        if (!constants.containsAll(applicationConstants)) {
            HashSet<String> deprecated = new HashSet<String>(applicationConstants);
            deprecated.removeAll(constants);
            message = this.prepareMessage(deprecated);
        }
        return message;
    }

    private void readConstants(Set<String> constants, Class clazz) throws IllegalAccessException {
        for (Field field : clazz.getDeclaredFields()) {
            if (!String.class.equals(field.getType())) continue;
            constants.add((String)field.get(clazz));
        }
    }

    private String prepareMessage(Set<String> deprecated) {
        StringBuilder sb = new StringBuilder("\n");
        sb.append("*******************************************************************************\n");
        sb.append("**                                                                           **\n");
        sb.append("**                               WARNING                                     **\n");
        sb.append("**                YOU USE DEPRECATED / UNKNOWN CONSTANTS                     **\n");
        sb.append("**                                                                           **\n");
        for (String dep : deprecated) {
            sb.append(String.format("**  -> %-69s **\n", dep));
        }
        sb.append("*******************************************************************************\n");
        return sb.toString();
    }

    @Inject(value="struts.devMode")
    public void setDevMode(String state) {
        this.devMode = "true".equals(state);
    }

    @Inject
    public void setContainer(Container container) {
        this.container = container;
    }
}

