/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher.multipart;

import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.struts2.dispatcher.multipart.MultiPartRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JakartaStreamMultiPartRequest
implements MultiPartRequest {
    static final Logger LOG = LoggerFactory.getLogger(JakartaStreamMultiPartRequest.class);
    private static final int BUFFER_SIZE = 10240;
    private Map<String, List<FileInfo>> fileInfos = new HashMap<String, List<FileInfo>>();
    private Map<String, List<String>> parameters = new HashMap<String, List<String>>();
    private List<String> errors = new ArrayList<String>();
    private List<String> messages = new ArrayList<String>();
    private Long maxSize;
    private int bufferSize = 10240;
    private Locale defaultLocale = Locale.ENGLISH;

    @Inject(value="struts.multipart.maxSize")
    public void setMaxSize(String maxSize) {
        this.maxSize = Long.parseLong(maxSize);
    }

    @Inject(value="struts.multipart.bufferSize", required=false)
    public void setBufferSize(String bufferSize) {
        this.bufferSize = Integer.parseInt(bufferSize);
    }

    @Inject
    public void setLocaleProvider(LocaleProvider provider) {
        this.defaultLocale = provider.getLocale();
    }

    @Override
    public void cleanUp() {
        LOG.debug("Performing File Upload temporary storage cleanup.", new String[0]);
        for (String fieldName : this.fileInfos.keySet()) {
            for (FileInfo fileInfo : this.fileInfos.get(fieldName)) {
                File file = fileInfo.getFile();
                LOG.debug("Deleting file '#0'.", new String[]{file.getName()});
                if (file.delete()) continue;
                LOG.warn("There was a problem attempting to delete file '#0'.", new String[]{file.getName()});
            }
        }
    }

    @Override
    public String[] getContentType(String fieldName) {
        List<FileInfo> infos = this.fileInfos.get(fieldName);
        if (infos == null) {
            return null;
        }
        ArrayList<String> types = new ArrayList<String>(infos.size());
        for (FileInfo fileInfo : infos) {
            types.add(fileInfo.getContentType());
        }
        return types.toArray(new String[types.size()]);
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }

    public List<String> getMesssages() {
        return this.messages;
    }

    @Override
    public File[] getFile(String fieldName) {
        List<FileInfo> infos = this.fileInfos.get(fieldName);
        if (infos == null) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>(infos.size());
        for (FileInfo fileInfo : infos) {
            files.add(fileInfo.getFile());
        }
        return files.toArray(new File[files.size()]);
    }

    @Override
    public String[] getFileNames(String fieldName) {
        List<FileInfo> infos = this.fileInfos.get(fieldName);
        if (infos == null) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>(infos.size());
        for (FileInfo fileInfo : infos) {
            names.add(this.getCanonicalName(fileInfo.getOriginalName()));
        }
        return names.toArray(new String[names.size()]);
    }

    @Override
    public Enumeration<String> getFileParameterNames() {
        return Collections.enumeration(this.fileInfos.keySet());
    }

    @Override
    public String[] getFilesystemName(String fieldName) {
        List<FileInfo> infos = this.fileInfos.get(fieldName);
        if (infos == null) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>(infos.size());
        for (FileInfo fileInfo : infos) {
            names.add(fileInfo.getFile().getName());
        }
        return names.toArray(new String[names.size()]);
    }

    @Override
    public String getParameter(String name) {
        List<String> values = this.parameters.get(name);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    @Override
    public String[] getParameterValues(String name) {
        List<String> values = this.parameters.get(name);
        if (values != null && values.size() > 0) {
            return values.toArray(new String[values.size()]);
        }
        return null;
    }

    @Override
    public void parse(HttpServletRequest request, String saveDir) throws IOException {
        block2: {
            try {
                this.setLocale(request);
                this.processUpload(request, saveDir);
            }
            catch (Exception e) {
                e.printStackTrace();
                String errorMessage = this.buildErrorMessage(e, new Object[0]);
                if (this.errors.contains(errorMessage)) break block2;
                this.errors.add(errorMessage);
            }
        }
    }

    protected void setLocale(HttpServletRequest request) {
        if (this.defaultLocale == null) {
            this.defaultLocale = request.getLocale();
        }
    }

    private void processUpload(HttpServletRequest request, String saveDir) throws Exception {
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            boolean requestSizePermitted = this.isRequestSizePermitted(request);
            ServletFileUpload servletFileUpload = new ServletFileUpload();
            FileItemIterator i = servletFileUpload.getItemIterator(request);
            while (i.hasNext()) {
                try {
                    FileItemStream itemStream = i.next();
                    if (itemStream.isFormField()) {
                        this.processFileItemStreamAsFormField(itemStream);
                        continue;
                    }
                    if (!requestSizePermitted) {
                        this.addFileSkippedError(itemStream.getName(), request);
                        LOG.warn("Skipped stream '#0', request maximum size (#1) exceeded.", new Object[]{itemStream.getName(), this.maxSize});
                        continue;
                    }
                    this.processFileItemStreamAsFileField(itemStream, saveDir);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean isRequestSizePermitted(HttpServletRequest request) {
        if (this.maxSize == -1L || request == null) {
            return true;
        }
        return (long)request.getContentLength() < this.maxSize;
    }

    private long getRequestSize(HttpServletRequest request) {
        long requestSize = 0L;
        if (request != null) {
            requestSize = request.getContentLength();
        }
        return requestSize;
    }

    private void addFileSkippedError(String fileName, HttpServletRequest request) {
        String exceptionMessage = "Skipped file " + fileName + "; request size limit exceeded.";
        FileUploadBase.FileSizeLimitExceededException exception = new FileUploadBase.FileSizeLimitExceededException(exceptionMessage, this.getRequestSize(request), this.maxSize.longValue());
        String message = this.buildErrorMessage((Throwable)exception, new Object[]{fileName, this.getRequestSize(request), this.maxSize});
        if (!this.errors.contains(message)) {
            this.errors.add(message);
        }
    }

    private void processFileItemStreamAsFormField(FileItemStream itemStream) {
        String fieldName = itemStream.getFieldName();
        try {
            List<Object> values = null;
            String fieldValue = Streams.asString((InputStream)itemStream.openStream());
            if (!this.parameters.containsKey(fieldName)) {
                values = new ArrayList();
                this.parameters.put(fieldName, values);
            } else {
                values = this.parameters.get(fieldName);
            }
            values.add(fieldValue);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to handle form field '#0'.", new String[]{fieldName});
        }
    }

    private void processFileItemStreamAsFileField(FileItemStream itemStream, String location) {
        block6: {
            if (itemStream.getName() == null || itemStream.getName().trim().length() < 1) {
                LOG.debug("No file has been uploaded for the field: {}", new String[]{itemStream.getFieldName()});
                return;
            }
            File file = null;
            try {
                file = this.createTemporaryFile(itemStream.getName(), location);
                if (this.streamFileToDisk(itemStream, file)) {
                    this.createFileInfoFromItemStream(itemStream, file);
                }
            }
            catch (IOException e) {
                if (file == null) break block6;
                try {
                    file.delete();
                }
                catch (SecurityException se) {
                    se.printStackTrace();
                    LOG.warn("Failed to delete '#0' due to security exception above.", new String[]{file.getName()});
                }
            }
        }
    }

    private File createTemporaryFile(String fileName, String location) throws IOException {
        String name;
        String prefix = name = fileName.substring(fileName.lastIndexOf(47) + 1).substring(fileName.lastIndexOf(92) + 1);
        String suffix = "";
        if (name.contains(".")) {
            prefix = name.substring(0, name.lastIndexOf(46));
            suffix = name.substring(name.lastIndexOf(46));
        }
        if (prefix.length() < 3) {
            prefix = UUID.randomUUID().toString();
        }
        File file = File.createTempFile(prefix + "_", suffix, new File(location));
        LOG.debug("Creating temporary file '#0' (originally '#1').", new String[]{file.getName(), fileName});
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean streamFileToDisk(FileItemStream itemStream, File file) throws IOException {
        boolean result = false;
        InputStream input = itemStream.openStream();
        OutputStream output = null;
        try {
            output = new BufferedOutputStream(new FileOutputStream(file), this.bufferSize);
            byte[] buffer = new byte[this.bufferSize];
            LOG.debug("Streaming file using buffer size #0.", new Object[]{this.bufferSize});
            int length = 0;
            while ((length = input.read(buffer)) > 0) {
                output.write(buffer, 0, length);
            }
            result = true;
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    private void createFileInfoFromItemStream(FileItemStream itemStream, File file) {
        String fileName = itemStream.getName();
        String fieldName = itemStream.getFieldName();
        FileInfo fileInfo = new FileInfo(file, itemStream.getContentType(), fileName);
        if (!this.fileInfos.containsKey(fieldName)) {
            ArrayList<FileInfo> infos = new ArrayList<FileInfo>();
            infos.add(fileInfo);
            this.fileInfos.put(fieldName, infos);
        } else {
            this.fileInfos.get(fieldName).add(fileInfo);
        }
    }

    private String getCanonicalName(String fileName) {
        int forwardSlash = fileName.lastIndexOf("/");
        int backwardSlash = fileName.lastIndexOf("\\");
        fileName = forwardSlash != -1 && forwardSlash > backwardSlash ? fileName.substring(forwardSlash + 1, fileName.length()) : fileName.substring(backwardSlash + 1, fileName.length());
        return fileName;
    }

    private String buildErrorMessage(Throwable e, Object[] args) {
        String errorKey = "struts.message.upload.error." + e.getClass().getSimpleName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Preparing error message for key: [#0]", new String[]{errorKey});
        }
        if (LocalizedTextUtil.findText(this.getClass(), (String)errorKey, (Locale)this.defaultLocale, null, (Object[])new Object[0]) == null) {
            return LocalizedTextUtil.findText(this.getClass(), (String)"struts.messages.error.uploading", (Locale)this.defaultLocale, null, (Object[])new Object[]{e.getMessage()});
        }
        return LocalizedTextUtil.findText(this.getClass(), (String)errorKey, (Locale)this.defaultLocale, null, (Object[])args);
    }

    private String buildMessage(Throwable e, Object[] args) {
        String messageKey = "struts.message.upload.message." + e.getClass().getSimpleName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Preparing message for key: [#0]", new String[]{messageKey});
        }
        return LocalizedTextUtil.findText(this.getClass(), (String)messageKey, (Locale)this.defaultLocale, (String)e.getMessage(), (Object[])args);
    }

    private static class FileInfo
    implements Serializable {
        private static final long serialVersionUID = 1083158552766906037L;
        private File file;
        private String contentType;
        private String originalName;

        public FileInfo(File file, String contentType, String originalName) {
            this.file = file;
            this.contentType = contentType;
            this.originalName = originalName;
        }

        public File getFile() {
            return this.file;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getOriginalName() {
            return this.originalName;
        }
    }
}

