<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<%--
    Licensed to the Apache Software Foundation (ASF) under one or more
    contributor license agreements.  See the NOTICE file distributed with
    this work for additional information regarding copyright ownership.
    The ASF licenses this file to You under the Apache License, Version 2.0
    (the "License"); you may not use this file except in compliance with
    the License.  You may obtain a copy of the License at
   
         http://www.apache.org/licenses/LICENSE-2.0
   
    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
--%>
<%@ page language="java" contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html" %>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic" %>

<html:html xhtml="true" lang="true">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<title>Link Examples</title>
<html:base />
<link rel="stylesheet" type="text/css" href="../../css/example.css" />
</head>
<body>

<html:link page="/jsp/links/source.jsp">
  <img src="../../images/code.gif" width="24" height="24" alt="View Source" class="icon" />
</html:link>
<a href="../../index.jsp"><img src="../../images/return.gif" height="24" width="24" alt="Return to examples page" class="icon" /></a>
<h1>Link Examples</h1>
<hr noshade="noshade"/>

<h2>Simple Links</h2>
<p>If you view this page with cookies disabled, you will see that the struts tags append the session id to the link URL.<br />
 Observe that the HTML &lt;a&gt; tag does not have the URL appended.</p>
<%-- This causes an exception on Tomcat 4.06 and 4.1.24. It works on Tomcat 5 and WebSphere 5.
     I think we can assume a bug inTomcat 4.x.
  <html:link href="../../processLinks.do">Link using href attribute</html:link><br />
--%>
<ul>
  <li><a href="../../processLinks.do">Link using HTML &lt;a&gt; tag</a></li>
  <li><html:link page="/processLinks.do">Link using page attribute</html:link></li>
  <li><html:link action="linksAction">Link using action attribute</html:link></li>
  <li><html:link action="linksAction" anchor="test">Link to an anchor</html:link></li>
</ul>

<h2>Links with Parameters</h2>
<bean:define id="myColor" value="red"/>
<ul>
  <li><html:link action="linksAction?color=blue">Hardcoded parameter</html:link></li>
  <li><html:link action="linksAction" paramId="color" paramName="myColor">Dynamic parameter</html:link></li>
  <li><html:link action="linksAction" paramId="msg" paramName="testBean" paramProperty="stringValue">Dynamic parameter from a bean property</html:link></li>
  <li><html:link action="linksAction" name="parms">Multiple dynamic parameters from a Map</html:link></li>
  <li>
    <html:link action="linksAction" name="parms">
      Dynamic parameters from &lt;html:param&gt;
      <html:param name="buybefore" value="Tomorrow" />
      <html:param name="shippedfrom" value="New York" />
    </html:link>
  </li>
</ul>

<h2>Rewrite Links</h2>
<p>These are generated by the &lt;html:rewrite&gt; tag, which generates hyperlink paths (not anchor tags).</p>
<ul>
  <li><html:rewrite action="linksAction" paramId="color" paramName="myColor" /></li>
  <li><html:rewrite action="linksAction" paramId="msg" paramName="testBean" paramProperty="stringValue" /></li>
  <li><html:rewrite action="linksAction" name="parms" /></li>
  <li>
    <html:rewrite action="linksAction">
      <html:param name="buybefore" value="Tomorrow" />
      <html:param name="shippedfrom" value="New York" />
    </html:rewrite>
  </li>
  <li><html:rewrite action="linksAction" /></li>
</ul>

<html:frame action="/prepareLogic">
</html:frame>

</body>
</html:html>