/*
 * $Id: Constants.java 471754 2006-11-06 14:55:09Z husted $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.struts.taglib.html;


/**
 * Manifest constants for this package.
 */
public class Constants {
    /**
     * The name of this package.
     */
    public static final String Package = "org.apache.struts.taglib.html";

    /**
     * The attribute key for the bean our form is related to.
     */
    public static final String BEAN_KEY = Package + ".BEAN";

    /**
     * The property under which a Cancel button press is reported.
     */
    public static final String CANCEL_PROPERTY = Package + ".CANCEL";

    /**
     * The property under which a Cancel button press is reported, if the
     * Cancel button is rendered as an image.
     */
    public static final String CANCEL_PROPERTY_X = Package + ".CANCEL.x";

    /**
     * The attribute key for the form tag itself.
     */
    public static final String FORM_KEY = Package + ".FORM";

    /**
     * The attribute key for the select tag itself.
     */
    public static final String SELECT_KEY = Package + ".SELECT";

    /**
     * The property under which a transaction token is reported.
     */
    public static final String TOKEN_KEY = Package + ".TOKEN";
}
