/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.streams.local.test.writer;

import org.apache.streams.core.StreamsDatum;
import org.apache.streams.core.StreamsPersistWriter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by rebanks on 2/20/14.
 */
public class DoNothingWriter implements StreamsPersistWriter {

  private final static Logger LOGGER = LoggerFactory.getLogger(DoNothingWriter.class);

  @Override
  public String getId() {
    return "DoNothingWriter";
  }

  @Override
  public void write(StreamsDatum entry) {

  }

  @Override
  public void prepare(Object configurationObject) {

  }

  @Override
  public void cleanUp() {
    LOGGER.debug("Writer Clean Up!");
  }
}
