/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource.strategies.scheduling;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.storm.scheduler.TopologyDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConstraintSolverConfig {
    private static final Logger LOG = LoggerFactory.getLogger(ConstraintSolverConfig.class);
    public static final String CONSTRAINT_TYPE_MAX_NODE_CO_LOCATION_CNT = "maxNodeCoLocationCnt";
    public static final String CONSTRAINT_TYPE_INCOMPATIBLE_COMPONENTS = "incompatibleComponents";
    private Map<String, Set<String>> incompatibleComponentSets = new HashMap<String, Set<String>>();
    private Map<String, Integer> maxNodeCoLocationCnts = new HashMap<String, Integer>();
    private final Map<String, Object> topoConf;
    private final Set<String> comps;
    private final String topoId;

    public ConstraintSolverConfig(TopologyDetails topo) {
        this(topo.getId(), topo.getConf(), new HashSet<String>(topo.getExecutorToComponent().values()));
    }

    public ConstraintSolverConfig(String topoId, Map<String, Object> topoConf, Set<String> comps) {
        this.topoId = topoId == null ? "<null>" : topoId;
        this.topoConf = Collections.unmodifiableMap(topoConf);
        this.comps = Collections.unmodifiableSet(comps);
        this.computeComponentConstraints();
    }

    private void computeComponentConstraints() {
        this.comps.forEach(k -> this.incompatibleComponentSets.computeIfAbsent((String)k, x -> new HashSet()));
        Object rasConstraints = this.topoConf.get("topology.ras.constraints");
        if (rasConstraints == null) {
            LOG.warn("TopoId {}: No config supplied for {}", (Object)this.topoId, (Object)"topology.ras.constraints");
        } else if (rasConstraints instanceof List) {
            List constraints = (List)rasConstraints;
            for (List constraintPair : constraints) {
                String comp12 = (String)constraintPair.get(0);
                String comp2 = (String)constraintPair.get(1);
                if (!this.comps.contains(comp12)) {
                    LOG.warn("TopoId {}: Comp {} declared in constraints is not valid!", (Object)this.topoId, (Object)comp12);
                    continue;
                }
                if (!this.comps.contains(comp2)) {
                    LOG.warn("TopoId {}: Comp {} declared in constraints is not valid!", (Object)this.topoId, (Object)comp2);
                    continue;
                }
                this.incompatibleComponentSets.get(comp12).add(comp2);
                this.incompatibleComponentSets.get(comp2).add(comp12);
            }
        } else {
            Map constraintMap = (Map)rasConstraints;
            constraintMap.forEach((comp1, v) -> {
                if (this.comps.contains(comp1)) {
                    v.forEach((ctype, constraint) -> {
                        switch (ctype) {
                            case "maxNodeCoLocationCnt": {
                                try {
                                    int numValue = Integer.parseInt("" + constraint);
                                    if (numValue < 1) {
                                        LOG.warn("TopoId {}: {} {} declared for Comp {} is not valid, expected >= 1", new Object[]{this.topoId, ctype, numValue, comp1});
                                        break;
                                    }
                                    this.maxNodeCoLocationCnts.put((String)comp1, numValue);
                                }
                                catch (Exception ex) {
                                    LOG.warn("TopoId {}: {} {} declared for Comp {} for topoId {} is not valid, expected >= 1", new Object[]{this.topoId, ctype, constraint, comp1});
                                }
                                break;
                            }
                            case "incompatibleComponents": {
                                if (!(constraint instanceof List) && !(constraint instanceof String)) {
                                    LOG.warn("TopoId {}: {} {} declared for Comp {} is not valid, expecting a list of Comps or 1 Comp", new Object[]{this.topoId, ctype, constraint, comp1});
                                    break;
                                }
                                List<String> list = constraint instanceof String ? Arrays.asList((String)constraint) : (List<String>)constraint;
                                for (String comp2 : list) {
                                    if (!this.comps.contains(comp2)) {
                                        LOG.warn("TopoId {}: {} {} declared for Comp {} is not a valid Comp", new Object[]{this.topoId, ctype, comp2, comp1});
                                        continue;
                                    }
                                    this.incompatibleComponentSets.get(comp1).add(comp2);
                                    this.incompatibleComponentSets.get(comp2).add((String)comp1);
                                }
                                break;
                            }
                            default: {
                                LOG.warn("TopoId {}: ConstraintType={} invalid for Comp={}, valid values are {} and {}, ignoring value={}", new Object[]{this.topoId, ctype, comp1, CONSTRAINT_TYPE_MAX_NODE_CO_LOCATION_CNT, CONSTRAINT_TYPE_INCOMPATIBLE_COMPONENTS, constraint});
                            }
                        }
                    });
                } else {
                    LOG.warn("TopoId {}: Component {} is not a valid component", (Object)this.topoId, comp1);
                }
            });
        }
        Object obj = this.topoConf.get("topology.spread.components");
        if (obj == null) {
            return;
        }
        if (obj instanceof List) {
            List spread = (List)obj;
            for (String comp : spread) {
                if (!this.comps.contains(comp)) {
                    LOG.warn("TopoId {}: Invalid Component {} declared in spread {}", new Object[]{this.topoId, comp, spread});
                    continue;
                }
                if (this.maxNodeCoLocationCnts.containsKey(comp)) {
                    LOG.warn("TopoId {}: Component {} maxNodeCoLocationCnt={} already defined in {}, ignoring spread config in {}", new Object[]{this.topoId, comp, this.maxNodeCoLocationCnts.get(comp), "topology.ras.constraints", "topology.spread.components"});
                    continue;
                }
                this.maxNodeCoLocationCnts.put(comp, 1);
            }
        } else {
            LOG.warn("TopoId {}: Ignoring invalid {} config={}", new Object[]{this.topoId, "topology.spread.components", obj});
        }
    }

    public Map<String, Set<String>> getIncompatibleComponentSets() {
        return this.incompatibleComponentSets;
    }

    public Map<String, Integer> getMaxNodeCoLocationCnts() {
        return this.maxNodeCoLocationCnts;
    }
}

