/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource.strategies.priority;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.storm.scheduler.ISchedulingState;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.resource.User;
import org.apache.storm.scheduler.resource.strategies.priority.ISchedulingPriorityStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSchedulingPriorityStrategy
implements ISchedulingPriorityStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSchedulingPriorityStrategy.class);

    protected SimulatedUser getSimulatedUserFor(User u, ISchedulingState cluster) {
        return new SimulatedUser(u, cluster);
    }

    @Override
    public List<TopologyDetails> getOrderedTopologies(ISchedulingState cluster, Map<String, User> userMap) {
        double cpuAvail = cluster.getClusterTotalCpuResource();
        double memAvail = cluster.getClusterTotalMemoryResource();
        ArrayList<TopologyDetails> allUserTopologies = new ArrayList<TopologyDetails>();
        ArrayList<SimulatedUser> users = new ArrayList<SimulatedUser>();
        for (User u : userMap.values()) {
            users.add(this.getSimulatedUserFor(u, cluster));
        }
        while (!users.isEmpty()) {
            Collections.sort(users, new SimulatedUserComparator(cpuAvail, memAvail));
            SimulatedUser u = (SimulatedUser)users.get(0);
            TopologyDetails td = u.getNextHighest();
            if (td == null) {
                users.remove(0);
                continue;
            }
            double score = u.getScore(cpuAvail, memAvail);
            td = u.simScheduleNextHighest();
            LOG.info("SIM Scheduling {} with score of {}", (Object)td.getId(), (Object)score);
            cpuAvail -= td.getTotalRequestedCpu();
            memAvail -= td.getTotalRequestedMemOffHeap() + td.getTotalRequestedMemOnHeap();
            allUserTopologies.add(td);
        }
        return allUserTopologies;
    }

    private static class TopologyByPriorityAndSubmissionTimeComparator
    implements Comparator<TopologyDetails> {
        private TopologyByPriorityAndSubmissionTimeComparator() {
        }

        @Override
        public int compare(TopologyDetails topo1, TopologyDetails topo2) {
            if (topo1.getTopologyPriority() > topo2.getTopologyPriority()) {
                return 1;
            }
            if (topo1.getTopologyPriority() < topo2.getTopologyPriority()) {
                return -1;
            }
            if (topo1.getUpTime() > topo2.getUpTime()) {
                return -1;
            }
            if (topo1.getUpTime() < topo2.getUpTime()) {
                return 1;
            }
            return topo1.getId().compareTo(topo2.getId());
        }
    }

    private static class SimulatedUserComparator
    implements Comparator<SimulatedUser> {
        private final double cpuAvail;
        private final double memAvail;

        private SimulatedUserComparator(double cpuAvail, double memAvail) {
            this.cpuAvail = cpuAvail;
            this.memAvail = memAvail;
        }

        @Override
        public int compare(SimulatedUser o1, SimulatedUser o2) {
            return Double.compare(o1.getScore(this.cpuAvail, this.memAvail), o2.getScore(this.cpuAvail, this.memAvail));
        }
    }

    protected static class SimulatedUser {
        public final double guaranteedCpu;
        public final double guaranteedMemory;
        protected final LinkedList<TopologyDetails> tds = new LinkedList();
        protected double assignedCpu = 0.0;
        protected double assignedMemory = 0.0;

        public SimulatedUser(User other, ISchedulingState cluster) {
            this.tds.addAll(cluster.getTopologies().getTopologiesOwnedBy(other.getId()));
            Collections.sort(this.tds, new TopologyByPriorityAndSubmissionTimeComparator());
            Double guaranteedCpu = other.getCpuResourceGuaranteed();
            if (guaranteedCpu == null) {
                guaranteedCpu = 0.0;
            }
            this.guaranteedCpu = guaranteedCpu;
            Double guaranteedMemory = other.getMemoryResourceGuaranteed();
            if (guaranteedMemory == null) {
                guaranteedMemory = 0.0;
            }
            this.guaranteedMemory = guaranteedMemory;
        }

        public TopologyDetails getNextHighest() {
            return this.tds.peekFirst();
        }

        public TopologyDetails simScheduleNextHighest() {
            TopologyDetails td = this.tds.pop();
            this.assignedCpu += td.getTotalRequestedCpu();
            this.assignedMemory += td.getTotalRequestedMemOffHeap() + td.getTotalRequestedMemOnHeap();
            return td;
        }

        protected double getScore(double availableCpu, double availableMemory, TopologyDetails td) {
            if (td == null || availableCpu <= 0.0 || availableMemory <= 0.0) {
                return Double.MAX_VALUE;
            }
            double wouldBeCpu = this.assignedCpu + td.getTotalRequestedCpu();
            double wouldBeMem = this.assignedMemory + td.getTotalRequestedMemOffHeap() + td.getTotalRequestedMemOnHeap();
            double cpuScore = (wouldBeCpu - this.guaranteedCpu) / availableCpu;
            double memScore = (wouldBeMem - this.guaranteedMemory) / availableMemory;
            return Math.max(cpuScore, memScore);
        }

        public double getScore(double availableCpu, double availableMemory) {
            TopologyDetails td = this.getNextHighest();
            return this.getScore(availableCpu, availableMemory, td);
        }
    }
}

