/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource.normalization;

import java.util.HashMap;
import java.util.Map;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.apache.storm.generated.ComponentCommon;
import org.apache.storm.generated.WorkerResources;
import org.apache.storm.scheduler.resource.normalization.NormalizedResources;
import org.apache.storm.scheduler.resource.normalization.NormalizedResourcesWithMemory;
import org.apache.storm.utils.ObjectReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalizedResourceRequest
implements NormalizedResourcesWithMemory {
    private static final Logger LOG = LoggerFactory.getLogger(NormalizedResourceRequest.class);
    private final NormalizedResources normalizedResources;
    private double onHeap;
    private double offHeap;

    private NormalizedResourceRequest(Map<String, ? extends Number> resources, Map<String, Double> defaultResources) {
        if (resources == null && defaultResources == null) {
            this.onHeap = 0.0;
            this.offHeap = 0.0;
            this.normalizedResources = new NormalizedResources();
        } else {
            Map<String, Double> normalizedResourceMap = NormalizedResources.RESOURCE_NAME_NORMALIZER.normalizedResourceMap(defaultResources);
            normalizedResourceMap.putAll(NormalizedResources.RESOURCE_NAME_NORMALIZER.normalizedResourceMap(resources));
            this.onHeap = normalizedResourceMap.getOrDefault("onheap.memory.mb", 0.0);
            this.offHeap = normalizedResourceMap.getOrDefault("offheap.memory.mb", 0.0);
            this.normalizedResources = new NormalizedResources(normalizedResourceMap);
        }
    }

    public NormalizedResourceRequest(ComponentCommon component, Map<String, Object> topoConf, String componentId) {
        this(NormalizedResourceRequest.parseResources(component.get_json_conf()), NormalizedResourceRequest.getDefaultResources(topoConf, componentId));
    }

    public NormalizedResourceRequest(Map<String, Object> topoConf, String componentId) {
        this((Map<String, ? extends Number>)null, NormalizedResourceRequest.getDefaultResources(topoConf, componentId));
    }

    public NormalizedResourceRequest() {
        this((Map<String, ? extends Number>)null, (Map<String, Double>)null);
    }

    private static void putIfMissing(Map<String, Double> dest, String destKey, Map<String, Object> src, String srcKey) {
        Number value;
        if (!dest.containsKey(destKey) && (value = (Number)src.get(srcKey)) != null) {
            dest.put(destKey, value.doubleValue());
        }
    }

    private static Map<String, Double> getDefaultResources(Map<String, Object> topoConf, String componentId) {
        Map<String, Double> ret = NormalizedResources.RESOURCE_NAME_NORMALIZER.normalizedResourceMap(topoConf.getOrDefault("topology.component.resources.map", new HashMap()));
        if (componentId != null) {
            if (componentId.equals("__acker")) {
                if (topoConf.containsKey("topology.acker.resources.onheap.memory.mb")) {
                    ret.put("onheap.memory.mb", ObjectReader.getDouble((Object)topoConf.get("topology.acker.resources.onheap.memory.mb")));
                }
                if (topoConf.containsKey("topology.acker.resources.offheap.memory.mb")) {
                    ret.put("offheap.memory.mb", ObjectReader.getDouble((Object)topoConf.get("topology.acker.resources.offheap.memory.mb")));
                }
                if (topoConf.containsKey("topology.acker.cpu.pcore.percent")) {
                    ret.put("cpu.pcore.percent", ObjectReader.getDouble((Object)topoConf.get("topology.acker.cpu.pcore.percent")));
                }
            } else if (componentId.startsWith("__metrics_")) {
                if (topoConf.containsKey("topology.metrics.consumer.resources.onheap.memory.mb")) {
                    ret.put("onheap.memory.mb", ObjectReader.getDouble((Object)topoConf.get("topology.metrics.consumer.resources.onheap.memory.mb")));
                }
                if (topoConf.containsKey("topology.metrics.consumer.resources.offheap.memory.mb")) {
                    ret.put("offheap.memory.mb", ObjectReader.getDouble((Object)topoConf.get("topology.metrics.consumer.resources.offheap.memory.mb")));
                }
                if (topoConf.containsKey("topology.metrics.consumer.cpu.pcore.percent")) {
                    ret.put("cpu.pcore.percent", ObjectReader.getDouble((Object)topoConf.get("topology.metrics.consumer.cpu.pcore.percent")));
                }
            }
        }
        NormalizedResourceRequest.putIfMissing(ret, "cpu.pcore.percent", topoConf, "topology.component.cpu.pcore.percent");
        NormalizedResourceRequest.putIfMissing(ret, "offheap.memory.mb", topoConf, "topology.component.resources.offheap.memory.mb");
        NormalizedResourceRequest.putIfMissing(ret, "onheap.memory.mb", topoConf, "topology.component.resources.onheap.memory.mb");
        return ret;
    }

    private static Map<String, Double> parseResources(String input) {
        HashMap<String, Double> topologyResources = new HashMap<String, Double>();
        JSONParser parser = new JSONParser();
        try {
            if (input != null) {
                Object obj = parser.parse(input);
                JSONObject jsonObject = (JSONObject)obj;
                if (jsonObject.containsKey((Object)"topology.component.resources.onheap.memory.mb")) {
                    Double topoMemOnHeap = ObjectReader.getDouble((Object)jsonObject.get((Object)"topology.component.resources.onheap.memory.mb"), null);
                    topologyResources.put("topology.component.resources.onheap.memory.mb", topoMemOnHeap);
                }
                if (jsonObject.containsKey((Object)"topology.component.resources.offheap.memory.mb")) {
                    Double topoMemOffHeap = ObjectReader.getDouble((Object)jsonObject.get((Object)"topology.component.resources.offheap.memory.mb"), null);
                    topologyResources.put("topology.component.resources.offheap.memory.mb", topoMemOffHeap);
                }
                if (jsonObject.containsKey((Object)"topology.component.cpu.pcore.percent")) {
                    Double topoCpu = ObjectReader.getDouble((Object)jsonObject.get((Object)"topology.component.cpu.pcore.percent"), null);
                    topologyResources.put("topology.component.cpu.pcore.percent", topoCpu);
                }
                if (jsonObject.containsKey((Object)"topology.component.resources.map")) {
                    Map rawResourcesMap = (Map)jsonObject.computeIfAbsent((Object)"topology.component.resources.map", k -> new HashMap());
                    for (Map.Entry stringNumberEntry : rawResourcesMap.entrySet()) {
                        topologyResources.put((String)stringNumberEntry.getKey(), ((Number)stringNumberEntry.getValue()).doubleValue());
                    }
                }
            }
        }
        catch (ParseException e) {
            LOG.error("Failed to parse component resources is:" + e.toString(), (Throwable)e);
            return null;
        }
        return topologyResources;
    }

    public Map<String, Double> toNormalizedMap() {
        Map<String, Double> ret = this.normalizedResources.toNormalizedMap();
        ret.put("offheap.memory.mb", this.offHeap);
        ret.put("onheap.memory.mb", this.onHeap);
        return ret;
    }

    public static void removeNonGenericResources(Map<String, Double> map) {
        map.remove("onheap.memory.mb");
        map.remove("offheap.memory.mb");
        map.remove("memory.mb");
        map.remove("cpu.pcore.percent");
    }

    public static Map<String, Double> addResourceMap(Map<String, Double> resources1, Map<String, Double> resources2) {
        HashMap<String, Double> sum = new HashMap<String, Double>(resources1);
        if (resources2 != null) {
            for (Map.Entry<String, Double> me : resources2.entrySet()) {
                Double cur = sum.getOrDefault(me.getKey(), 0.0) + me.getValue();
                sum.put(me.getKey(), cur);
            }
        }
        return sum;
    }

    public static Map<String, Double> subtractResourceMap(Map<String, Double> resource1, Map<String, Double> resource2) {
        if (resource1 == null || resource2 == null) {
            return new HashMap<String, Double>();
        }
        HashMap<String, Double> difference = new HashMap<String, Double>(resource1);
        for (Map.Entry<String, Double> me : resource2.entrySet()) {
            Double sub = difference.getOrDefault(me.getKey(), 0.0) - me.getValue();
            difference.put(me.getKey(), sub);
        }
        return difference;
    }

    public double getOnHeapMemoryMb() {
        return this.onHeap;
    }

    public void addOnHeap(double onHeap) {
        this.onHeap += onHeap;
    }

    public double getOffHeapMemoryMb() {
        return this.offHeap;
    }

    public void addOffHeap(double offHeap) {
        this.offHeap += offHeap;
    }

    public void add(NormalizedResourceRequest other) {
        this.normalizedResources.add(other.normalizedResources);
        this.onHeap += other.onHeap;
        this.offHeap += other.offHeap;
    }

    public void add(WorkerResources value) {
        this.normalizedResources.add(value);
        Map resources = value.get_resources();
        this.onHeap += resources.getOrDefault("onheap.memory.mb", 0.0).doubleValue();
        this.offHeap += resources.getOrDefault("offheap.memory.mb", 0.0).doubleValue();
    }

    @Override
    public double getTotalMemoryMb() {
        return this.onHeap + this.offHeap;
    }

    public String toString() {
        return "Normalized resources: " + this.toNormalizedMap();
    }

    public double getTotalCpu() {
        return this.normalizedResources.getTotalCpu();
    }

    @Override
    public NormalizedResources getNormalizedResources() {
        return this.normalizedResources;
    }

    @Override
    public void clear() {
        this.normalizedResources.clear();
        this.offHeap = 0.0;
        this.onHeap = 0.0;
    }

    @Override
    public boolean areAnyOverZero() {
        return this.onHeap > 0.0 || this.offHeap > 0.0 || this.normalizedResources.areAnyOverZero();
    }
}

