/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.multitenant;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.storm.scheduler.Cluster;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.SchedulerAssignment;
import org.apache.storm.scheduler.SupervisorDetails;
import org.apache.storm.scheduler.WorkerSlot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Node {
    public static final Comparator<Node> FREE_NODE_COMPARATOR_DEC = new Comparator<Node>(){

        @Override
        public int compare(Node o1, Node o2) {
            return o1.totalSlotsUsed() - o2.totalSlotsUsed();
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(Node.class);
    private final String nodeId;
    private Map<String, Set<WorkerSlot>> topIdToUsedSlots = new HashMap<String, Set<WorkerSlot>>();
    private Set<WorkerSlot> freeSlots = new HashSet<WorkerSlot>();
    private boolean isAlive;

    public Node(String nodeId, Set<Integer> allPorts, boolean isAlive) {
        this.nodeId = nodeId;
        this.isAlive = isAlive;
        if (this.isAlive && allPorts != null) {
            for (int port : allPorts) {
                this.freeSlots.add(new WorkerSlot(this.nodeId, (Number)port));
            }
        }
    }

    public static int countSlotsUsed(String topId, Collection<Node> nodes) {
        int total = 0;
        for (Node n : nodes) {
            total += n.totalSlotsUsed(topId);
        }
        return total;
    }

    public static int countSlotsUsed(Collection<Node> nodes) {
        int total = 0;
        for (Node n : nodes) {
            total += n.totalSlotsUsed();
        }
        return total;
    }

    public static int countFreeSlotsAlive(Collection<Node> nodes) {
        int total = 0;
        for (Node n : nodes) {
            if (!n.isAlive()) continue;
            total += n.totalSlotsFree();
        }
        return total;
    }

    public static int countTotalSlotsAlive(Collection<Node> nodes) {
        int total = 0;
        for (Node n : nodes) {
            if (!n.isAlive()) continue;
            total += n.totalSlots();
        }
        return total;
    }

    public static Map<String, Node> getAllNodesFrom(Cluster cluster) {
        HashMap<String, Node> nodeIdToNode = new HashMap<String, Node>();
        for (SupervisorDetails supervisorDetails : cluster.getSupervisors().values()) {
            String id = supervisorDetails.getId();
            boolean isAlive = !cluster.isBlackListed(id);
            LOG.debug("Found a {} Node {} {}", new Object[]{isAlive ? "living" : "dead", id, supervisorDetails.getAllPorts()});
            nodeIdToNode.put(id, new Node(id, supervisorDetails.getAllPorts(), isAlive));
        }
        for (Map.Entry entry : cluster.getAssignments().entrySet()) {
            String topId = ((SchedulerAssignment)entry.getValue()).getTopologyId();
            for (WorkerSlot ws : ((SchedulerAssignment)entry.getValue()).getSlots()) {
                String id = ws.getNodeId();
                Node node = (Node)nodeIdToNode.get(id);
                if (node == null) {
                    LOG.debug("Found an assigned slot on a dead supervisor {}", (Object)ws);
                    node = new Node(id, null, false);
                    nodeIdToNode.put(id, node);
                }
                if (!node.isAlive()) {
                    node.addOrphanedSlot(ws);
                }
                if (!node.assignInternal(ws, topId, true)) continue;
                LOG.warn("Bad scheduling state for topology [" + topId + "], the slot " + ws + " assigned to multiple workers, un-assigning everything...");
                node.free(ws, cluster, true);
            }
        }
        return nodeIdToNode;
    }

    public String getId() {
        return this.nodeId;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public Collection<String> getRunningTopologies() {
        return this.topIdToUsedSlots.keySet();
    }

    public boolean isTotallyFree() {
        return this.topIdToUsedSlots.isEmpty();
    }

    public int totalSlotsFree() {
        return this.freeSlots.size();
    }

    public int totalSlotsUsed() {
        int total = 0;
        for (Set<WorkerSlot> slots : this.topIdToUsedSlots.values()) {
            total += slots.size();
        }
        return total;
    }

    public int totalSlotsUsed(String topId) {
        int total = 0;
        Set<WorkerSlot> slots = this.topIdToUsedSlots.get(topId);
        if (slots != null) {
            total = slots.size();
        }
        return total;
    }

    public int totalSlots() {
        return this.totalSlotsFree() + this.totalSlotsUsed();
    }

    private void validateSlot(WorkerSlot ws) {
        if (!this.nodeId.equals(ws.getNodeId())) {
            throw new IllegalArgumentException("Trying to add a slot to the wrong node " + ws + " is not a part of " + this.nodeId);
        }
    }

    private void addOrphanedSlot(WorkerSlot ws) {
        if (this.isAlive) {
            throw new IllegalArgumentException("Orphaned Slots only are allowed on dead nodes.");
        }
        this.validateSlot(ws);
        if (this.freeSlots.contains(ws)) {
            return;
        }
        for (Set<WorkerSlot> used : this.topIdToUsedSlots.values()) {
            if (!used.contains(ws)) continue;
            return;
        }
        this.freeSlots.add(ws);
    }

    boolean assignInternal(WorkerSlot ws, String topId, boolean dontThrow) {
        Set<WorkerSlot> usedSlots;
        this.validateSlot(ws);
        if (!this.freeSlots.remove(ws)) {
            for (Map.Entry<String, Set<WorkerSlot>> topologySetEntry : this.topIdToUsedSlots.entrySet()) {
                if (!topologySetEntry.getValue().contains(ws)) continue;
                if (dontThrow) {
                    LOG.warn("Worker slot [" + ws + "] can't be assigned to " + topId + ". Its already assigned to " + topologySetEntry.getKey() + ".");
                    return true;
                }
                throw new IllegalStateException("Worker slot [" + ws + "] can't be assigned to " + topId + ". Its already assigned to " + topologySetEntry.getKey() + ".");
            }
            LOG.warn("Adding Worker slot [" + ws + "] that was not reported in the supervisor heartbeats, but the worker is already running for topology " + topId + ".");
        }
        if ((usedSlots = this.topIdToUsedSlots.get(topId)) == null) {
            usedSlots = new HashSet<WorkerSlot>();
            this.topIdToUsedSlots.put(topId, usedSlots);
        }
        usedSlots.add(ws);
        return false;
    }

    public void freeAllSlots(Cluster cluster) {
        if (!this.isAlive) {
            LOG.warn("Freeing all slots on a dead node {} ", (Object)this.nodeId);
        }
        for (Map.Entry<String, Set<WorkerSlot>> entry : this.topIdToUsedSlots.entrySet()) {
            cluster.freeSlots((Collection<WorkerSlot>)entry.getValue());
            if (!this.isAlive) continue;
            this.freeSlots.addAll((Collection<WorkerSlot>)entry.getValue());
        }
        this.topIdToUsedSlots = new HashMap<String, Set<WorkerSlot>>();
    }

    public void free(WorkerSlot ws, Cluster cluster, boolean forceFree) {
        if (this.freeSlots.contains(ws)) {
            return;
        }
        boolean wasFound = false;
        for (Map.Entry<String, Set<WorkerSlot>> entry : this.topIdToUsedSlots.entrySet()) {
            Set<WorkerSlot> slots = entry.getValue();
            if (!slots.remove(ws)) continue;
            cluster.freeSlot(ws);
            if (this.isAlive) {
                this.freeSlots.add(ws);
            }
            wasFound = true;
        }
        if (!wasFound) {
            if (forceFree) {
                LOG.info("Forcefully freeing the " + ws);
                cluster.freeSlot(ws);
                this.freeSlots.add(ws);
            } else {
                throw new IllegalArgumentException("Tried to free a slot that was not part of this node " + this.nodeId);
            }
        }
    }

    public void freeTopology(String topId, Cluster cluster) {
        Set<WorkerSlot> slots = this.topIdToUsedSlots.get(topId);
        if (slots == null || slots.isEmpty()) {
            return;
        }
        for (WorkerSlot ws : slots) {
            cluster.freeSlot(ws);
            if (!this.isAlive) continue;
            this.freeSlots.add(ws);
        }
        this.topIdToUsedSlots.remove(topId);
    }

    public void assign(String topId, Collection<ExecutorDetails> executors, Cluster cluster) {
        if (!this.isAlive) {
            throw new IllegalStateException("Trying to adding to a dead node " + this.nodeId);
        }
        if (this.freeSlots.isEmpty()) {
            throw new IllegalStateException("Trying to assign to a full node " + this.nodeId);
        }
        if (executors.size() == 0) {
            LOG.warn("Trying to assign nothing from " + topId + " to " + this.nodeId + " (Ignored)");
        } else {
            WorkerSlot slot = this.freeSlots.iterator().next();
            cluster.assign(slot, topId, executors);
            this.assignInternal(slot, topId, false);
        }
    }

    public boolean equals(Object other) {
        return other instanceof Node && this.nodeId.equals(((Node)other).nodeId);
    }

    public int hashCode() {
        return this.nodeId.hashCode();
    }

    public String toString() {
        return "Node: " + this.nodeId;
    }
}

