/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metricstore.rocksdb;

import com.codahale.metrics.Meter;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.metricstore.AggLevel;
import org.apache.storm.metricstore.FilterOptions;
import org.apache.storm.metricstore.Metric;
import org.apache.storm.metricstore.MetricException;
import org.apache.storm.metricstore.MetricStore;
import org.apache.storm.metricstore.rocksdb.KeyType;
import org.apache.storm.metricstore.rocksdb.MetricsCleaner;
import org.apache.storm.metricstore.rocksdb.ReadOnlyStringMetadataCache;
import org.apache.storm.metricstore.rocksdb.RocksDbKey;
import org.apache.storm.metricstore.rocksdb.RocksDbMetricsWriter;
import org.apache.storm.metricstore.rocksdb.RocksDbValue;
import org.apache.storm.metricstore.rocksdb.StringMetadata;
import org.apache.storm.metricstore.rocksdb.StringMetadataCache;
import org.apache.storm.utils.ObjectReader;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.IndexType;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDbStore
implements MetricStore,
AutoCloseable {
    static final int INVALID_METADATA_STRING_ID = 0;
    private static final Logger LOG = LoggerFactory.getLogger(RocksDbStore.class);
    private static final int MAX_QUEUE_CAPACITY = 4000;
    RocksDB db;
    private ReadOnlyStringMetadataCache readOnlyStringMetadataCache = null;
    private BlockingQueue queue = new LinkedBlockingQueue(4000);
    private RocksDbMetricsWriter metricsWriter = null;
    private MetricsCleaner metricsCleaner = null;
    private Meter failureMeter = null;

    @Override
    public void prepare(Map<String, Object> config, StormMetricsRegistry metricsRegistry) throws MetricException {
        this.validateConfig(config);
        this.failureMeter = metricsRegistry.registerMeter("RocksDB:metric-failures");
        RocksDB.loadLibrary();
        boolean createIfMissing = ObjectReader.getBoolean((Object)config.get("storm.metricstore.rocksdb.create_if_missing"), (boolean)false);
        try (Options options = new Options().setCreateIfMissing(createIfMissing);){
            BlockBasedTableConfig tfc = new BlockBasedTableConfig();
            tfc.setIndexType(IndexType.kHashSearch);
            options.setTableFormatConfig((TableFormatConfig)tfc);
            options.useCappedPrefixExtractor(38);
            String path = this.getRocksDbAbsoluteDir(config);
            LOG.info("Opening RocksDB from {}, {}={}", new Object[]{path, "storm.metricstore.rocksdb.create_if_missing", createIfMissing});
            this.db = RocksDB.open((Options)options, (String)path);
        }
        catch (RocksDBException e) {
            String message = "Error opening RockDB database";
            LOG.error(message, (Throwable)e);
            throw new MetricException(message, e);
        }
        Integer retentionHours = Integer.parseInt(config.get("storm.metricstore.rocksdb.retention_hours").toString());
        Integer deletionPeriod = 0;
        if (config.containsKey("storm.metricstore.rocksdb.deletion_period_hours")) {
            deletionPeriod = Integer.parseInt(config.get("storm.metricstore.rocksdb.deletion_period_hours").toString());
        }
        this.metricsCleaner = new MetricsCleaner(this, retentionHours, deletionPeriod, this.failureMeter, metricsRegistry);
        this.metricsWriter = new RocksDbMetricsWriter(this, this.queue, this.failureMeter);
        int cacheCapacity = Integer.parseInt(config.get("storm.metricstore.rocksdb.metadata_string_cache_capacity").toString());
        StringMetadataCache.init(this.metricsWriter, cacheCapacity);
        this.readOnlyStringMetadataCache = StringMetadataCache.getReadOnlyStringMetadataCache();
        this.metricsWriter.init();
        Thread thread = new Thread((Runnable)this.metricsCleaner, "RocksDbMetricsCleaner");
        thread.setDaemon(true);
        thread.start();
        thread = new Thread((Runnable)this.metricsWriter, "RocksDbMetricsWriter");
        thread.setDaemon(true);
        thread.start();
    }

    private void validateConfig(Map<String, Object> config) throws MetricException {
        if (!config.containsKey("storm.metricstore.rocksdb.location")) {
            throw new MetricException("Not a vaild RocksDB configuration - Missing store location storm.metricstore.rocksdb.location");
        }
        if (!config.containsKey("storm.metricstore.rocksdb.create_if_missing")) {
            throw new MetricException("Not a vaild RocksDB configuration - Does not specify creation policy storm.metricstore.rocksdb.create_if_missing");
        }
        String storePath = this.getRocksDbAbsoluteDir(config);
        boolean createIfMissing = ObjectReader.getBoolean((Object)config.get("storm.metricstore.rocksdb.create_if_missing"), (boolean)false);
        if (!createIfMissing && !new File(storePath).exists()) {
            throw new MetricException("Configuration specifies not to create a store but no store currently exists at " + storePath);
        }
        if (!config.containsKey("storm.metricstore.rocksdb.metadata_string_cache_capacity")) {
            throw new MetricException("Not a valid RocksDB configuration - Missing metadata string cache size storm.metricstore.rocksdb.metadata_string_cache_capacity");
        }
        if (!config.containsKey("storm.metricstore.rocksdb.retention_hours")) {
            throw new MetricException("Not a valid RocksDB configuration - Missing metric retention storm.metricstore.rocksdb.retention_hours");
        }
    }

    private String getRocksDbAbsoluteDir(Map<String, Object> conf) throws MetricException {
        String storePath = (String)conf.get("storm.metricstore.rocksdb.location");
        if (storePath == null) {
            throw new MetricException("Not a vaild RocksDB configuration - Missing store location storm.metricstore.rocksdb.location");
        }
        if (new File(storePath).isAbsolute()) {
            return storePath;
        }
        String stormHome = System.getProperty("storm.home");
        if (stormHome == null) {
            throw new MetricException("storm.home not set");
        }
        return stormHome + File.separator + storePath;
    }

    @Override
    public void insert(Metric metric) throws MetricException {
        try {
            if (this.queue.remainingCapacity() <= 0) {
                LOG.info("Metrics q full, dropping metric");
                return;
            }
            this.queue.put(metric);
        }
        catch (Exception e) {
            String message = "Failed to insert metric";
            LOG.error(message, (Throwable)e);
            if (this.failureMeter != null) {
                this.failureMeter.mark();
            }
            throw new MetricException(message, e);
        }
    }

    @Override
    public boolean populateValue(Metric metric) throws MetricException {
        HashMap<String, Integer> localLookupCache = new HashMap<String, Integer>(6);
        int topologyId = this.lookupMetadataString(KeyType.TOPOLOGY_STRING, metric.getTopologyId(), localLookupCache);
        if (0 == topologyId) {
            return false;
        }
        int metricId = this.lookupMetadataString(KeyType.METRIC_STRING, metric.getMetricName(), localLookupCache);
        if (0 == metricId) {
            return false;
        }
        int componentId = this.lookupMetadataString(KeyType.COMPONENT_STRING, metric.getComponentId(), localLookupCache);
        if (0 == componentId) {
            return false;
        }
        int executorId = this.lookupMetadataString(KeyType.EXEC_ID_STRING, metric.getExecutorId(), localLookupCache);
        if (0 == executorId) {
            return false;
        }
        int hostId = this.lookupMetadataString(KeyType.HOST_STRING, metric.getHostname(), localLookupCache);
        if (0 == hostId) {
            return false;
        }
        int streamId = this.lookupMetadataString(KeyType.STREAM_ID_STRING, metric.getStreamId(), localLookupCache);
        if (0 == streamId) {
            return false;
        }
        RocksDbKey key = RocksDbKey.createMetricKey(metric.getAggLevel(), topologyId, metric.getTimestamp(), metricId, componentId, executorId, hostId, metric.getPort(), streamId);
        return this.populateFromKey(key, metric);
    }

    boolean populateFromKey(RocksDbKey key, Metric metric) throws MetricException {
        try {
            byte[] value = this.db.get(key.getRaw());
            if (value == null) {
                return false;
            }
            RocksDbValue rdbValue = new RocksDbValue(value);
            rdbValue.populateMetric(metric);
        }
        catch (Exception e) {
            String message = "Failed to populate metric";
            LOG.error(message, (Throwable)e);
            if (this.failureMeter != null) {
                this.failureMeter.mark();
            }
            throw new MetricException(message, e);
        }
        return true;
    }

    private int lookupMetadataString(KeyType type, String s, Map<String, Integer> lookupCache) throws MetricException {
        if (s == null) {
            if (this.failureMeter != null) {
                this.failureMeter.mark();
            }
            throw new MetricException("No string for metric metadata string type " + type);
        }
        StringMetadata stringMetadata = this.readOnlyStringMetadataCache.get(s);
        if (stringMetadata != null) {
            return stringMetadata.getStringId();
        }
        Integer id = lookupCache.get(s);
        if (id != null) {
            return id;
        }
        try {
            stringMetadata = this.rocksDbGetStringMetadata(type, s);
        }
        catch (RocksDBException e) {
            throw new MetricException("Error reading metric data", e);
        }
        if (stringMetadata != null) {
            id = stringMetadata.getStringId();
            lookupCache.put(s, id);
            return id;
        }
        return 0;
    }

    StringMetadata rocksDbGetStringMetadata(KeyType type, String s) throws RocksDBException {
        RocksDbKey firstKey = RocksDbKey.getInitialKey(type);
        RocksDbKey lastKey = RocksDbKey.getLastKey(type);
        AtomicReference reference = new AtomicReference();
        this.scanRange(firstKey, lastKey, (key, value) -> {
            if (s.equals(value.getMetdataString())) {
                reference.set(value.getStringMetadata(key));
                return false;
            }
            return true;
        });
        return (StringMetadata)reference.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void scanRange(RocksDbKey start, RocksDbKey end, RocksDbScanCallback fn) throws RocksDBException {
        try (ReadOptions ro = new ReadOptions();){
            ro.setTotalOrderSeek(true);
            try (RocksIterator iterator = this.db.newIterator(ro);){
                iterator.seek(start.getRaw());
                while (iterator.isValid()) {
                    RocksDbKey key = new RocksDbKey(iterator.key());
                    if (key.compareTo(end) >= 0) {
                        return;
                    }
                    RocksDbValue val = new RocksDbValue(iterator.value());
                    if (!fn.cb(key, val)) {
                        return;
                    }
                    iterator.next();
                }
                return;
            }
        }
    }

    @Override
    public void close() {
        this.metricsWriter.close();
        this.metricsCleaner.close();
    }

    @Override
    public void scan(FilterOptions filter, MetricStore.ScanCallback scanCallback) throws MetricException {
        this.scanInternal(filter, scanCallback, null);
    }

    private void scanRaw(FilterOptions filter, RocksDbScanCallback rawCallback) throws MetricException {
        this.scanInternal(filter, null, rawCallback);
    }

    private void scanInternal(FilterOptions filter, MetricStore.ScanCallback scanCallback, RocksDbScanCallback rawCallback) throws MetricException {
        HashMap<String, Integer> stringToIdCache = new HashMap<String, Integer>();
        HashMap<Integer, String> idToStringCache = new HashMap<Integer, String>();
        int startTopologyId = 0;
        int endTopologyId = -1;
        String filterTopologyId = filter.getTopologyId();
        if (filterTopologyId != null) {
            int topologyId = this.lookupMetadataString(KeyType.TOPOLOGY_STRING, filterTopologyId, stringToIdCache);
            if (0 == topologyId) {
                return;
            }
            startTopologyId = topologyId;
            endTopologyId = topologyId;
        }
        long startTime = filter.getStartTime();
        long endTime = filter.getEndTime();
        int startMetricId = 0;
        int endMetricId = -1;
        String filterMetricName = filter.getMetricName();
        if (filterMetricName != null) {
            int metricId = this.lookupMetadataString(KeyType.METRIC_STRING, filterMetricName, stringToIdCache);
            if (0 == metricId) {
                return;
            }
            startMetricId = metricId;
            endMetricId = metricId;
        }
        int startComponentId = 0;
        int endComponentId = -1;
        String filterComponentId = filter.getComponentId();
        if (filterComponentId != null) {
            int componentId = this.lookupMetadataString(KeyType.COMPONENT_STRING, filterComponentId, stringToIdCache);
            if (0 == componentId) {
                return;
            }
            startComponentId = componentId;
            endComponentId = componentId;
        }
        int startExecutorId = 0;
        int endExecutorId = -1;
        String filterExecutorName = filter.getExecutorId();
        if (filterExecutorName != null) {
            int executorId = this.lookupMetadataString(KeyType.EXEC_ID_STRING, filterExecutorName, stringToIdCache);
            if (0 == executorId) {
                return;
            }
            startExecutorId = executorId;
            endExecutorId = executorId;
        }
        int startHostId = 0;
        int endHostId = -1;
        String filterHostId = filter.getHostId();
        if (filterHostId != null) {
            int hostId = this.lookupMetadataString(KeyType.HOST_STRING, filterHostId, stringToIdCache);
            if (0 == hostId) {
                return;
            }
            startHostId = hostId;
            endHostId = hostId;
        }
        int startPort = 0;
        int endPort = -1;
        Integer filterPort = filter.getPort();
        if (filterPort != null) {
            startPort = filterPort;
            endPort = filterPort;
        }
        int startStreamId = 0;
        int endStreamId = -1;
        String filterStreamId = filter.getStreamId();
        if (filterStreamId != null) {
            int streamId = this.lookupMetadataString(KeyType.HOST_STRING, filterStreamId, stringToIdCache);
            if (0 == streamId) {
                return;
            }
            startStreamId = streamId;
            endStreamId = streamId;
        }
        try (ReadOptions ro = new ReadOptions();){
            ro.setTotalOrderSeek(true);
            for (AggLevel aggLevel : filter.getAggLevels()) {
                RocksDbKey startKey = RocksDbKey.createMetricKey(aggLevel, startTopologyId, startTime, startMetricId, startComponentId, startExecutorId, startHostId, startPort, startStreamId);
                RocksDbKey endKey = RocksDbKey.createMetricKey(aggLevel, endTopologyId, endTime, endMetricId, endComponentId, endExecutorId, endHostId, endPort, endStreamId);
                RocksIterator iterator = this.db.newIterator(ro);
                try {
                    RocksDbKey key;
                    iterator.seek(startKey.getRaw());
                    while (iterator.isValid() && (key = new RocksDbKey(iterator.key())).compareTo(endKey) <= 0) {
                        long timestamp;
                        if (!(startTopologyId != 0 && key.getTopologyId() != startTopologyId || (timestamp = key.getTimestamp()) < startTime || timestamp > endTime || startMetricId != 0 && key.getMetricId() != startMetricId || startComponentId != 0 && key.getComponentId() != startComponentId || startExecutorId != 0 && key.getExecutorId() != startExecutorId || startHostId != 0 && key.getHostnameId() != startHostId || startPort != 0 && key.getPort() != startPort || startStreamId != 0 && key.getStreamId() != startStreamId)) {
                            RocksDbValue val = new RocksDbValue(iterator.value());
                            if (scanCallback != null) {
                                try {
                                    String metricName = this.metadataIdToString(KeyType.METRIC_STRING, key.getMetricId(), idToStringCache);
                                    String topologyId = this.metadataIdToString(KeyType.TOPOLOGY_STRING, key.getTopologyId(), idToStringCache);
                                    String componentId = this.metadataIdToString(KeyType.COMPONENT_STRING, key.getComponentId(), idToStringCache);
                                    String executorId = this.metadataIdToString(KeyType.EXEC_ID_STRING, key.getExecutorId(), idToStringCache);
                                    String hostname = this.metadataIdToString(KeyType.HOST_STRING, key.getHostnameId(), idToStringCache);
                                    String streamId = this.metadataIdToString(KeyType.STREAM_ID_STRING, key.getStreamId(), idToStringCache);
                                    Metric metric = new Metric(metricName, timestamp, topologyId, 0.0, componentId, executorId, hostname, streamId, key.getPort(), aggLevel);
                                    val.populateMetric(metric);
                                    scanCallback.cb(metric);
                                }
                                catch (MetricException e) {
                                    LOG.warn("Failed to report found metric: {}", (Object)e.getMessage());
                                }
                            } else {
                                try {
                                    if (!rawCallback.cb(key, val)) {
                                        return;
                                    }
                                }
                                catch (RocksDBException e) {
                                    throw new MetricException("Error reading metrics data", e);
                                }
                            }
                        }
                        iterator.next();
                    }
                }
                finally {
                    if (iterator == null) continue;
                    iterator.close();
                }
            }
        }
    }

    private String metadataIdToString(KeyType type, int id, Map<Integer, String> lookupCache) throws MetricException {
        String s = this.readOnlyStringMetadataCache.getMetadataString(id);
        if (s != null) {
            return s;
        }
        s = lookupCache.get(id);
        if (s != null) {
            return s;
        }
        RocksDbKey key = new RocksDbKey(type, id);
        try {
            byte[] value = this.db.get(key.getRaw());
            if (value == null) {
                throw new MetricException("Failed to find metadata string for id " + id + " of type " + type);
            }
            RocksDbValue rdbValue = new RocksDbValue(value);
            s = rdbValue.getMetdataString();
            lookupCache.put(id, s);
            return s;
        }
        catch (RocksDBException e) {
            if (this.failureMeter != null) {
                this.failureMeter.mark();
            }
            throw new MetricException("Failed to get from RocksDb", e);
        }
    }

    void deleteMetrics(FilterOptions filter) throws MetricException {
        block13: {
            try (WriteBatch writeBatch = new WriteBatch();
                 WriteOptions writeOps = new WriteOptions();){
                this.scanRaw(filter, (key, value) -> {
                    writeBatch.delete(key.getRaw());
                    return true;
                });
                if (writeBatch.count() <= 0) break block13;
                LOG.info("Deleting {} metrics", (Object)writeBatch.count());
                try {
                    this.db.write(writeOps, writeBatch);
                }
                catch (Exception e) {
                    String message = "Failed delete metrics";
                    LOG.error(message, (Throwable)e);
                    if (this.failureMeter != null) {
                        this.failureMeter.mark();
                    }
                    throw new MetricException(message, e);
                }
            }
        }
    }

    void deleteMetadataBefore(long firstValidTimestamp) throws MetricException {
        block17: {
            if (firstValidTimestamp < 1L) {
                if (this.failureMeter != null) {
                    this.failureMeter.mark();
                }
                throw new MetricException("Invalid timestamp for deleting metadata: " + firstValidTimestamp);
            }
            try (WriteBatch writeBatch = new WriteBatch();
                 WriteOptions writeOps = new WriteOptions();){
                RocksDbKey topologyMetadataPrefix = RocksDbKey.getPrefix(KeyType.METADATA_STRING_START);
                RocksDbKey lastPrefix = RocksDbKey.getPrefix(KeyType.METADATA_STRING_END);
                try {
                    this.scanRange(topologyMetadataPrefix, lastPrefix, (key, value) -> {
                        if (!this.readOnlyStringMetadataCache.contains(key.getMetadataStringId()) && value.getLastTimestamp() < firstValidTimestamp) {
                            writeBatch.delete(key.getRaw());
                        }
                        return true;
                    });
                }
                catch (RocksDBException e) {
                    throw new MetricException("Error reading metric data", e);
                }
                if (writeBatch.count() <= 0) break block17;
                LOG.info("Deleting {} metadata strings", (Object)writeBatch.count());
                try {
                    this.db.write(writeOps, writeBatch);
                }
                catch (Exception e) {
                    String message = "Failed delete metadata strings";
                    LOG.error(message, (Throwable)e);
                    if (this.failureMeter != null) {
                        this.failureMeter.mark();
                    }
                    throw new MetricException(message, e);
                }
            }
        }
    }

    static interface RocksDbScanCallback {
        public boolean cb(RocksDbKey var1, RocksDbValue var2) throws RocksDBException;
    }
}

