/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.container.oci;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.storm.StormTimer;
import org.apache.storm.container.cgroup.CgroupUtils;
import org.apache.storm.container.cgroup.core.MemoryCore;
import org.apache.storm.container.oci.ImageManifest;
import org.apache.storm.container.oci.OciContainerExecutorConfig;
import org.apache.storm.container.oci.OciContainerManager;
import org.apache.storm.container.oci.OciImageTagToManifestPluginInterface;
import org.apache.storm.container.oci.OciManifestToResourcesPluginInterface;
import org.apache.storm.container.oci.OciResource;
import org.apache.storm.container.oci.OciResourcesLocalizerInterface;
import org.apache.storm.daemon.supervisor.ClientSupervisorUtils;
import org.apache.storm.daemon.supervisor.ExitCodeCallback;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ReflectionUtils;
import org.apache.storm.utils.ServerUtils;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class RuncLibContainerManager
extends OciContainerManager {
    private static final Logger LOG = LoggerFactory.getLogger(RuncLibContainerManager.class);
    private OciImageTagToManifestPluginInterface imageTagToManifestPlugin;
    private OciManifestToResourcesPluginInterface manifestToResourcesPlugin;
    private OciResourcesLocalizerInterface ociResourcesLocalizer;
    private ObjectMapper mapper;
    private int layersToKeep;
    private String seccomp;
    private static final String RESOLV_CONF = "/etc/resolv.conf";
    private static final String HOSTNAME = "/etc/hostname";
    private static final String HOSTS = "/etc/hosts";
    private static final String OCI_CONFIG_JSON = "oci-config.json";
    private static final String SQUASHFS_MEDIA_TYPE = "application/vnd.squashfs";
    private static final long CPU_CFS_PERIOD_US = 100000L;
    private final Map<String, Long> workerToContainerPid = new ConcurrentHashMap<String, Long>();
    private final Map<String, ExitCodeCallback> workerToExitCallback = new ConcurrentHashMap<String, ExitCodeCallback>();
    private final Map<String, String> workerToUser = new ConcurrentHashMap<String, String>();
    private StormTimer checkContainerAliveTimer;

    @Override
    public void prepare(Map<String, Object> conf) throws IOException {
        super.prepare(conf);
        this.imageTagToManifestPlugin = this.chooseImageTagToManifestPlugin();
        this.imageTagToManifestPlugin.init(conf);
        this.manifestToResourcesPlugin = this.chooseManifestToResourcesPlugin();
        this.manifestToResourcesPlugin.init(conf);
        this.ociResourcesLocalizer = this.chooseOciResourcesLocalizer();
        this.ociResourcesLocalizer.init(conf);
        this.layersToKeep = ObjectReader.getInt((Object)conf.get("storm.oci.layer.mounts.to.keep"), (Integer)100);
        this.mapper = new ObjectMapper();
        if (this.seccompJsonFile != null) {
            this.seccomp = new String(Files.readAllBytes(Paths.get(this.seccompJsonFile, new String[0])));
        }
        if (this.checkContainerAliveTimer == null) {
            this.checkContainerAliveTimer = new StormTimer("CheckRuncContainerAlive", Utils.createDefaultUncaughtExceptionHandler());
            this.checkContainerAliveTimer.scheduleRecurring(0, ((Integer)conf.get("supervisor.monitor.frequency.secs")).intValue(), () -> {
                try {
                    this.checkContainersAlive();
                }
                catch (Exception e) {
                    LOG.warn("The CheckRuncContainerAlive thread has exception. Ignored", (Throwable)e);
                }
            });
        }
    }

    private OciImageTagToManifestPluginInterface chooseImageTagToManifestPlugin() throws IllegalArgumentException {
        String pluginName = ObjectReader.getString(this.conf.get("storm.oci.image.tag.to.manifest.plugin"));
        LOG.info("imageTag-to-manifest Plugin is: {}", (Object)pluginName);
        return (OciImageTagToManifestPluginInterface)ReflectionUtils.newInstance((String)pluginName);
    }

    private OciManifestToResourcesPluginInterface chooseManifestToResourcesPlugin() throws IllegalArgumentException {
        String pluginName = ObjectReader.getString(this.conf.get("storm.oci.manifest.to.resources.plugin"));
        LOG.info("manifest to resource Plugin is: {}", (Object)pluginName);
        return (OciManifestToResourcesPluginInterface)ReflectionUtils.newInstance((String)pluginName);
    }

    private OciResourcesLocalizerInterface chooseOciResourcesLocalizer() throws IllegalArgumentException {
        String pluginName = ObjectReader.getString(this.conf.get("storm.oci.resources.localizer"));
        LOG.info("oci resource localizer is: {}", (Object)pluginName);
        return (OciResourcesLocalizerInterface)ReflectionUtils.newInstance((String)pluginName);
    }

    private String containerPidFile(String workerId) {
        return ConfigUtils.workerArtifactsSymlink((Map)this.conf, (String)workerId) + ConfigUtils.FILE_SEPARATOR + "container-" + workerId + ".pid";
    }

    @Override
    public void launchWorkerProcess(String user, String topologyId, Map<String, Object> topoConf, int port, String workerId, List<String> command, Map<String, String> env, String logPrefix, ExitCodeCallback processExitCallback, File targetDir) throws IOException {
        String imageName = this.getImageName(topoConf);
        if (imageName == null) {
            LOG.error("Image name for {} is not configured properly; will not continue to launch the worker", (Object)topologyId);
            return;
        }
        String containerId = this.getContainerId(workerId, port);
        ImageManifest manifest = this.imageTagToManifestPlugin.getManifestFromImageTag(imageName);
        LOG.debug("workerId {}: Got manifest: {}", (Object)workerId, (Object)manifest.toString());
        OciResource configResource = this.manifestToResourcesPlugin.getConfigResource(manifest);
        LOG.info("workerId {}: Got config metadata: {}", (Object)workerId, (Object)configResource.toString());
        this.saveRuncYaml(topologyId, port, containerId, imageName, configResource);
        List<OciResource> layersResource = this.manifestToResourcesPlugin.getLayerResources(manifest);
        LOG.info("workerId {}: Got layers metadata: {}", (Object)workerId, (Object)layersResource.toString());
        String configLocalPath = this.ociResourcesLocalizer.localize(configResource);
        ArrayList<String> ociEnv = new ArrayList<String>();
        ArrayList<String> args = new ArrayList<String>();
        ArrayList<OciContainerExecutorConfig.OciLayer> layers = new ArrayList<OciContainerExecutorConfig.OciLayer>();
        File file = new File(configLocalPath);
        List<String> imageEnv = this.extractImageEnv(file);
        if (imageEnv != null && !imageEnv.isEmpty()) {
            ociEnv.addAll(imageEnv);
        }
        for (Map.Entry<String, String> entry : env.entrySet()) {
            ociEnv.add(entry.getKey() + "=" + entry.getValue());
        }
        LOG.debug("workerId {}: ociEnv: {}", (Object)workerId, ociEnv);
        List<String> entrypoint = this.extractImageEntrypoint(file);
        if (entrypoint != null && !entrypoint.isEmpty()) {
            args.addAll(entrypoint);
        }
        LOG.debug("workerId {}: args: {}", (Object)workerId, args);
        List<String> layersLocalPath = this.ociResourcesLocalizer.localize(layersResource);
        for (String layerLocalPath : layersLocalPath) {
            OciContainerExecutorConfig.OciLayer layer = new OciContainerExecutorConfig.OciLayer(SQUASHFS_MEDIA_TYPE, layerLocalPath);
            layers.add(layer);
        }
        LOG.debug("workerId {}: layers: {}", (Object)workerId, layers);
        ArrayList<OciContainerExecutorConfig.OciRuntimeConfig.OciMount> mounts = new ArrayList<OciContainerExecutorConfig.OciRuntimeConfig.OciMount>();
        this.setContainerMounts(mounts, topologyId, workerId, port);
        LOG.debug("workerId {}: mounts: {}", (Object)workerId, mounts);
        Long cpusQuotas = null;
        if (this.workerToCpu.containsKey(workerId)) {
            cpusQuotas = (long)((Integer)this.workerToCpu.get(workerId)).intValue() * 100000L / 100L;
        }
        Long memoryInBytes = null;
        if (this.workerToMemoryMb.containsKey(workerId)) {
            memoryInBytes = (long)((Integer)this.workerToMemoryMb.get(workerId)).intValue() * 1024L * 1024L;
        }
        LOG.info("workerId {}: memoryInBytes set to {}; cpusQuotas set to {}", new Object[]{workerId, memoryInBytes, cpusQuotas});
        String workerDir = targetDir.getAbsolutePath();
        String workerScriptPath = ServerUtils.writeScript(workerDir, command, env, "0027");
        args.add("bash");
        args.add(workerScriptPath);
        String containerPidFilePath = this.containerPidFile(workerId);
        OciContainerExecutorConfig.OciRuntimeConfig.OciProcessConfig processConfig = this.createOciProcessConfig(workerDir, ociEnv, args);
        OciContainerExecutorConfig.OciRuntimeConfig.OciLinuxConfig linuxConfig = this.createOciLinuxConfig(cpusQuotas, memoryInBytes, this.cgroupParent + "/" + containerId, this.seccomp, workerId);
        OciContainerExecutorConfig.OciRuntimeConfig ociRuntimeConfig = new OciContainerExecutorConfig.OciRuntimeConfig(null, mounts, processConfig, null, null, null, linuxConfig);
        OciContainerExecutorConfig ociContainerExecutorConfig = this.createOciContainerExecutorConfig(user, containerId, containerPidFilePath, workerScriptPath, layers, ociRuntimeConfig);
        String executorConfigToJsonFile = this.writeOciExecutorConfigToJsonFile(this.mapper, ociContainerExecutorConfig, workerDir);
        LOG.info("workerId {}: oci-config.json file path: {}", (Object)workerId, (Object)executorConfigToJsonFile);
        List<String> cmdArgs = Arrays.asList(OciContainerManager.CmdType.RUN_OCI_CONTAINER.toString(), workerDir, executorConfigToJsonFile, ConfigUtils.workerArtifactsSymlink((Map)this.conf, (String)workerId));
        int exitCode = ClientSupervisorUtils.processLauncherAndWait((Map)this.conf, (String)user, cmdArgs, env, (String)logPrefix, (File)targetDir);
        if (exitCode != 0) {
            LOG.error("launchWorkerProcess RuncCommand {} exited with code: {}", (Object)("LaunchWorker-" + containerId), (Object)exitCode);
            throw new RuntimeException("launchWorkerProcess Failed to create Runc Container. ContainerId: " + containerId);
        }
        LOG.debug("Adding {} to the watched workers list", (Object)workerId);
        this.workerToExitCallback.put(workerId, processExitCallback);
        this.workerToUser.put(workerId, user);
    }

    private void checkContainersAlive() {
        this.workerToUser.forEach((workerId, user) -> {
            if (this.isContainerDead((String)workerId, (String)user)) {
                this.invokeProcessExitCallback((String)workerId);
            }
        });
    }

    private boolean isContainerDead(String workerId, String user) {
        boolean isDead = true;
        Long pid = this.getContainerPid(workerId);
        LOG.debug("Checking container {}, pid {}, user {}", new Object[]{workerId, pid, user});
        if (pid != null && user != null) {
            try {
                isDead = ServerUtils.areAllProcessesDead(this.conf, user, workerId, Collections.singleton(pid));
            }
            catch (IOException e) {
                LOG.debug("Error while checking if container is dead.", (Throwable)e);
            }
        }
        return isDead;
    }

    private void invokeProcessExitCallback(String workerId) {
        LOG.info("processExitCallback returned for workerId {}", (Object)workerId);
        ExitCodeCallback processExitCallback = this.workerToExitCallback.get(workerId);
        if (processExitCallback != null) {
            processExitCallback.call(0);
        }
    }

    private String getContainerId(String workerId, int port) throws IOException {
        if (port <= 0) {
            return this.getContainerIdFromOciJson(workerId);
        }
        return port + "-" + workerId;
    }

    private String getContainerIdFromOciJson(String workerId) throws IOException {
        String string;
        String ociJson = ConfigUtils.workerRoot((Map)this.conf, (String)workerId) + ConfigUtils.FILE_SEPARATOR + OCI_CONFIG_JSON;
        LOG.info("port unknown for workerId {}, looking up from {}", (Object)workerId, (Object)ociJson);
        JSONParser parser = new JSONParser();
        FileReader reader = new FileReader(ociJson);
        try {
            JSONObject jsonObject = (JSONObject)parser.parse((Reader)reader);
            string = (String)jsonObject.get((Object)"containerId");
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ParseException e) {
                throw new IOException("Unable to parse {}", e);
            }
        }
        ((Reader)reader).close();
        return string;
    }

    private void saveRuncYaml(String topologyId, int port, String containerId, String imageName, OciResource configResource) {
        String fname = String.format("runc-%s.yaml", containerId);
        File file = new File(ConfigUtils.workerArtifactsRoot((Map)this.conf, (String)topologyId, (Integer)port), fname);
        DumperOptions options = new DumperOptions();
        options.setIndent(2);
        options.setPrettyFlow(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("imageName", imageName);
        data.put("manifest", configResource.getFileName());
        data.put("configPath", configResource.getPath());
        try (FileWriter writer = new FileWriter(file);){
            yaml.dump(data, (Writer)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String writeOciExecutorConfigToJsonFile(ObjectMapper mapper, OciContainerExecutorConfig ociContainerExecutorConfig, String workerDir) throws IOException {
        File cmdDir = new File(workerDir);
        if (!cmdDir.exists()) {
            throw new IOException(workerDir + " doesn't exist");
        }
        File commandFile = new File(cmdDir + ConfigUtils.FILE_SEPARATOR + OCI_CONFIG_JSON);
        mapper.writeValue(commandFile, (Object)ociContainerExecutorConfig);
        return commandFile.getAbsolutePath();
    }

    private void setContainerMounts(ArrayList<OciContainerExecutorConfig.OciRuntimeConfig.OciMount> mounts, String topologyId, String workerId, Integer port) throws IOException {
        for (String readonlyMount : this.readonlyBindmounts) {
            this.addOciMountLocation(mounts, readonlyMount, readonlyMount, false, false);
        }
        for (String readwriteMount : this.readwriteBindmounts) {
            this.addOciMountLocation(mounts, readwriteMount, readwriteMount, false, true);
        }
        this.addOciMountLocation(mounts, RESOLV_CONF, RESOLV_CONF, false, false);
        this.addOciMountLocation(mounts, HOSTNAME, HOSTNAME, false, false);
        this.addOciMountLocation(mounts, HOSTS, HOSTS, false, false);
        this.addOciMountLocation(mounts, this.nscdPath, this.nscdPath, false, false);
        this.addOciMountLocation(mounts, this.stormHome, this.stormHome, false, false);
        this.addOciMountLocation(mounts, this.cgroupRootPath, this.cgroupRootPath, false, false);
        String supervisorLocalDir = ConfigUtils.supervisorLocalDir((Map)this.conf);
        this.addOciMountLocation(mounts, supervisorLocalDir, supervisorLocalDir, false, false);
        String workerRootDir = ConfigUtils.workerRoot((Map)this.conf, (String)workerId);
        this.addOciMountLocation(mounts, workerRootDir, workerRootDir, false, true);
        String workerArtifactsRoot = ConfigUtils.workerArtifactsRoot((Map)this.conf, (String)topologyId, (Integer)port);
        this.addOciMountLocation(mounts, workerArtifactsRoot, workerArtifactsRoot, false, true);
        String workerUserFile = ConfigUtils.workerUserFile((Map)this.conf, (String)workerId);
        this.addOciMountLocation(mounts, workerUserFile, workerUserFile, false, true);
        String sharedByTopologyDir = ConfigUtils.sharedByTopologyDir((Map)this.conf, (String)topologyId);
        this.addOciMountLocation(mounts, sharedByTopologyDir, sharedByTopologyDir, false, true);
        String workerTmpRoot = ConfigUtils.workerTmpRoot((Map)this.conf, (String)workerId);
        this.addOciMountLocation(mounts, workerTmpRoot, TMP_DIR, false, true);
    }

    private List<String> extractImageEnv(File config) throws IOException {
        JsonNode node = this.mapper.readTree(config);
        JsonNode envNode = node.path("config").path("Env");
        if (envNode.isMissingNode()) {
            return null;
        }
        return (List)this.mapper.treeToValue((TreeNode)envNode, List.class);
    }

    private List<String> extractImageEntrypoint(File config) throws IOException {
        JsonNode node = this.mapper.readTree(config);
        JsonNode entrypointNode = node.path("config").path("Entrypoint");
        if (entrypointNode.isMissingNode()) {
            return null;
        }
        return (List)this.mapper.treeToValue((TreeNode)entrypointNode, List.class);
    }

    private OciContainerExecutorConfig createOciContainerExecutorConfig(String username, String containerId, String pidFile, String containerScriptPath, List<OciContainerExecutorConfig.OciLayer> layers, OciContainerExecutorConfig.OciRuntimeConfig ociRuntimeConfig) {
        return new OciContainerExecutorConfig(username, containerId, pidFile, containerScriptPath, layers, this.layersToKeep, ociRuntimeConfig);
    }

    private OciContainerExecutorConfig.OciRuntimeConfig.OciProcessConfig createOciProcessConfig(String cwd, List<String> env, List<String> args) {
        return new OciContainerExecutorConfig.OciRuntimeConfig.OciProcessConfig(false, null, cwd, env, args, null, null, null, true, 0, null, null);
    }

    private OciContainerExecutorConfig.OciRuntimeConfig.OciLinuxConfig createOciLinuxConfig(Long cpusQuotas, Long memInBytes, String cgroupsPath, String seccomp, String workerId) {
        OciContainerExecutorConfig.OciRuntimeConfig.OciLinuxConfig.Resources.Cpu cgroupCpu = null;
        if (cpusQuotas != null) {
            cgroupCpu = new OciContainerExecutorConfig.OciRuntimeConfig.OciLinuxConfig.Resources.Cpu(0L, cpusQuotas, 100000L, 0L, 0L, null, null);
            if (this.workerToCores.containsKey(workerId)) {
                cgroupCpu.setCpus(StringUtils.join((Collection)((Collection)this.workerToCores.get(workerId)), (String)","));
                cgroupCpu.setMems((String)this.workerToMemoryZone.get(workerId));
            }
        }
        OciContainerExecutorConfig.OciRuntimeConfig.OciLinuxConfig.Resources.Memory cgroupMem = null;
        if (memInBytes != null) {
            cgroupMem = new OciContainerExecutorConfig.OciRuntimeConfig.OciLinuxConfig.Resources.Memory(memInBytes, 0L, 0L, 0L, 0L, 0L, false);
        }
        OciContainerExecutorConfig.OciRuntimeConfig.OciLinuxConfig.Resources cgroupResources = new OciContainerExecutorConfig.OciRuntimeConfig.OciLinuxConfig.Resources(null, cgroupMem, cgroupCpu, null, null, null, null, null);
        return new OciContainerExecutorConfig.OciRuntimeConfig.OciLinuxConfig(null, null, null, null, cgroupsPath, cgroupResources, null, null, seccomp, null, null, null, null);
    }

    private void addOciMountLocation(List<OciContainerExecutorConfig.OciRuntimeConfig.OciMount> mounts, String srcPath, String dstPath, boolean createSource, boolean isReadWrite) throws IOException {
        boolean sourceExists;
        if (!createSource && !(sourceExists = new File(srcPath).exists())) {
            throw new IOException("SourcePath " + srcPath + " doesn't exit");
        }
        ArrayList<String> options = new ArrayList<String>();
        if (isReadWrite) {
            options.add("rw");
        } else {
            options.add("ro");
        }
        options.add("rbind");
        options.add("rprivate");
        mounts.add(new OciContainerExecutorConfig.OciRuntimeConfig.OciMount(dstPath, "bind", srcPath, options));
    }

    @Override
    public long getMemoryUsage(String user, String workerId, int port) throws IOException {
        String containerId = this.getContainerId(workerId, port);
        String memoryCgroupPath = this.memoryCgroupRootPath + File.separator + containerId;
        MemoryCore memoryCore = new MemoryCore(memoryCgroupPath);
        LOG.debug("ContainerId {} : Got memory getPhysicalUsage {} from {}", new Object[]{containerId, memoryCore.getPhysicalUsage(), memoryCgroupPath});
        return memoryCore.getPhysicalUsage();
    }

    @Override
    public void kill(String user, String workerId) throws IOException {
        LOG.info("Killing {}", (Object)workerId);
        Long pid = this.getContainerPid(workerId);
        if (pid != null) {
            this.signal(pid, 15, user);
        } else {
            LOG.warn("Trying to kill container {} but pidfile is not found", (Object)workerId);
        }
    }

    private void signal(long pid, int signal, String user) throws IOException {
        List<String> commands = Arrays.asList("signal", String.valueOf(pid), String.valueOf(signal));
        String logPrefix = "kill -" + signal + " " + pid;
        ClientSupervisorUtils.processLauncherAndWait((Map)this.conf, (String)user, commands, null, (String)logPrefix);
    }

    @Override
    public void forceKill(String user, String workerId) throws IOException {
        LOG.debug("ForceKilling {}", (Object)workerId);
        Long pid = this.getContainerPid(workerId);
        if (pid != null) {
            this.signal(pid, 9, user);
        } else {
            LOG.warn("Trying to forceKill container for workerId {} but pidfile is not found", (Object)workerId);
        }
    }

    private Long getContainerPid(String workerId) {
        Long pid = this.workerToContainerPid.get(workerId);
        if (pid == null) {
            String containerPidFilePath = this.containerPidFile(workerId);
            if (!new File(containerPidFilePath).exists()) {
                LOG.warn("{} doesn't exist", (Object)containerPidFilePath);
            } else {
                try {
                    pid = Long.parseLong((String)CgroupUtils.readFileByLine((String)containerPidFilePath).get(0));
                    this.workerToContainerPid.put(workerId, pid);
                }
                catch (IOException e) {
                    LOG.warn("failed to read {}", (Object)containerPidFilePath);
                }
            }
        }
        return pid;
    }

    @Override
    public boolean areAllProcessesDead(String user, String workerId) throws IOException {
        boolean areAllDead = this.isContainerDead(workerId, user);
        LOG.debug("WorkerId {}: Checking areAllProcessesDead: {}", (Object)workerId, (Object)areAllDead);
        return areAllDead;
    }

    @Override
    public void cleanup(String user, String workerId, int port) throws IOException {
        super.cleanup(user, workerId, port);
        LOG.debug("clean up worker {}", (Object)workerId);
        try {
            String containerId = this.getContainerId(workerId, port);
            List<String> commands = Arrays.asList(OciContainerManager.CmdType.REAP_OCI_CONTAINER.toString(), containerId, String.valueOf(this.layersToKeep));
            String logPrefix = "Worker Process " + workerId;
            int result = ClientSupervisorUtils.processLauncherAndWait((Map)this.conf, (String)user, commands, null, (String)logPrefix);
            if (result != 0) {
                LOG.warn("Failed cleaning up RuncWorker {}", (Object)workerId);
            }
        }
        catch (FileNotFoundException e) {
            LOG.error("Failed to find container id for {} ({}), unable to reap container", (Object)workerId, (Object)e.getMessage());
        }
        LOG.debug("Removing {} from the watched workers list", (Object)workerId);
        this.workerToUser.remove(workerId);
        this.workerToExitCallback.remove(workerId);
        this.workerToContainerPid.remove(workerId);
    }

    @Override
    public boolean runProfilingCommand(String user, String workerId, List<String> command, Map<String, String> env, String logPrefix, File targetDir) throws IOException, InterruptedException {
        String workerDir = targetDir.getAbsolutePath();
        String profilingArgs = StringUtils.join(command, (String)" ");
        String nsenterScriptPath = this.writeToCommandFile(workerDir, profilingArgs, "profile");
        Long containerPid = this.getContainerPid(workerId);
        if (containerPid == null) {
            LOG.error("Couldn't get container PID for the worker {}. Skip profiling", (Object)workerId);
            return false;
        }
        List<String> args = Arrays.asList(OciContainerManager.CmdType.PROFILE_OCI_CONTAINER.toString(), containerPid.toString(), nsenterScriptPath);
        int exitCode = ClientSupervisorUtils.processLauncherAndWait((Map)this.conf, (String)user, args, env, (String)logPrefix, (File)targetDir);
        LOG.debug("WorkerId {} : exitCode from {}: {}", new Object[]{workerId, OciContainerManager.CmdType.PROFILE_OCI_CONTAINER.toString(), exitCode});
        return exitCode == 0;
    }

    @Override
    public boolean isResourceManaged() {
        return true;
    }
}

