/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.logviewer.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.storm.security.auth.ClientAuthUtils;
import org.apache.storm.security.auth.IGroupMappingServiceProvider;
import org.apache.storm.security.auth.IPrincipalToLocal;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ServerConfigUtils;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceAuthorizer {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceAuthorizer.class);
    private final Map<String, Object> stormConf;
    private final IGroupMappingServiceProvider groupMappingServiceProvider;
    private final IPrincipalToLocal principalToLocal;

    public ResourceAuthorizer(Map<String, Object> stormConf) {
        this.stormConf = stormConf;
        this.groupMappingServiceProvider = ClientAuthUtils.getGroupMappingServiceProviderPlugin(stormConf);
        this.principalToLocal = ClientAuthUtils.getPrincipalToLocalPlugin(stormConf);
    }

    public boolean isUserAllowedToAccessFile(String user, String fileName) {
        return !this.isLogviewerFilterConfigured() || this.isAuthorizedLogUser(user, fileName);
    }

    public boolean isAuthorizedLogUser(String user, String fileName) {
        Validate.isTrue((!fileName.contains(".." + FileSystems.getDefault().getSeparator()) ? 1 : 0) != 0);
        if (StringUtils.isEmpty((String)user) || StringUtils.isEmpty((String)fileName)) {
            return false;
        }
        LogUserGroupWhitelist whitelist = this.getLogUserGroupWhitelist(fileName);
        ArrayList<String> logsUsers = new ArrayList<String>();
        logsUsers.addAll(ObjectReader.getStrings((Object)this.stormConf.get("logs.users")));
        logsUsers.addAll(ObjectReader.getStrings((Object)this.stormConf.get("nimbus.admins")));
        if (whitelist != null) {
            logsUsers.addAll(whitelist.getUserWhitelist());
        }
        ArrayList<String> logsGroups = new ArrayList<String>();
        logsGroups.addAll(ObjectReader.getStrings((Object)this.stormConf.get("logs.groups")));
        logsGroups.addAll(ObjectReader.getStrings((Object)this.stormConf.get("nimbus.admins.groups")));
        if (whitelist != null) {
            logsGroups.addAll(whitelist.getGroupWhitelist());
        }
        String userName = this.principalToLocal.toLocal(user);
        Set<String> groups = this.getUserGroups(userName);
        return logsUsers.stream().anyMatch(u -> u.equals(userName)) || Sets.intersection(groups, new HashSet(logsGroups)).size() > 0;
    }

    public LogUserGroupWhitelist getLogUserGroupWhitelist(String fileName) {
        File wlFile = ServerConfigUtils.getLogMetaDataFile((String)fileName);
        Map map = (Map)Utils.readYamlFile((String)wlFile.getAbsolutePath());
        if (map == null) {
            return null;
        }
        List logsUsers = ObjectReader.getStrings(map.get("logs.users"));
        List logsGroups = ObjectReader.getStrings(map.get("logs.groups"));
        return new LogUserGroupWhitelist(logsUsers.isEmpty() ? new HashSet<String>() : new HashSet(logsUsers), logsGroups.isEmpty() ? new HashSet<String>() : new HashSet(logsGroups));
    }

    @VisibleForTesting
    Set<String> getUserGroups(String user) {
        try {
            if (StringUtils.isEmpty((String)user)) {
                return new HashSet<String>();
            }
            return this.groupMappingServiceProvider.getGroups(user);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isLogviewerFilterConfigured() {
        return StringUtils.isNotBlank((String)ObjectReader.getString((Object)this.stormConf.get("logviewer.filter"), null)) || StringUtils.isNotBlank((String)ObjectReader.getString((Object)this.stormConf.get("ui.filter"), null));
    }

    public static class LogUserGroupWhitelist {
        private Set<String> userWhitelist;
        private Set<String> groupWhitelist;

        public LogUserGroupWhitelist(Set<String> userWhitelist, Set<String> groupWhitelist) {
            this.userWhitelist = userWhitelist;
            this.groupWhitelist = groupWhitelist;
        }

        public Set<String> getUserWhitelist() {
            return this.userWhitelist;
        }

        public Set<String> getGroupWhitelist() {
            return this.groupWhitelist;
        }
    }
}

