/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.logviewer.handler;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.Response;
import net.minidev.json.JSONAware;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.storm.daemon.common.JsonResponseBuilder;
import org.apache.storm.daemon.logviewer.utils.DirectoryCleaner;
import org.apache.storm.daemon.logviewer.utils.LogviewerResponseBuilder;
import org.apache.storm.daemon.logviewer.utils.ResourceAuthorizer;
import org.apache.storm.daemon.logviewer.utils.WorkerLogs;
import org.apache.storm.daemon.supervisor.SupervisorUtils;
import org.apache.storm.daemon.ui.InvalidRequestException;
import org.apache.storm.daemon.utils.ListFunctionalSupport;
import org.apache.storm.daemon.utils.PathUtil;
import org.apache.storm.daemon.utils.UrlBuilder;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogviewerLogSearchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LogviewerLogSearchHandler.class);
    public static final int GREP_MAX_SEARCH_SIZE = 1024;
    public static final int GREP_BUF_SIZE = 2048;
    public static final int GREP_CONTEXT_SIZE = 128;
    public static final Pattern WORKER_LOG_FILENAME_PATTERN = Pattern.compile("^worker.log(.*)");
    private final Meter numDeepSearchNoResult;
    private final Histogram numFileScanned;
    private final Meter numSearchRequestNoResult;
    private final Meter numFileOpenExceptions;
    private final Meter numFileReadExceptions;
    private final Map<String, Object> stormConf;
    private final Path logRoot;
    private final Path daemonLogRoot;
    private final ResourceAuthorizer resourceAuthorizer;
    private final Integer logviewerPort;
    private final String scheme;
    private final DirectoryCleaner directoryCleaner;

    public LogviewerLogSearchHandler(Map<String, Object> stormConf, Path logRoot, Path daemonLogRoot, ResourceAuthorizer resourceAuthorizer, StormMetricsRegistry metricsRegistry) {
        this.stormConf = stormConf;
        this.logRoot = logRoot.toAbsolutePath().normalize();
        this.daemonLogRoot = daemonLogRoot.toAbsolutePath().normalize();
        this.resourceAuthorizer = resourceAuthorizer;
        Object httpsPort = stormConf.get("logviewer.https.port");
        if (httpsPort == null) {
            this.logviewerPort = ObjectReader.getInt((Object)stormConf.get("logviewer.port"));
            this.scheme = "http";
        } else {
            this.logviewerPort = ObjectReader.getInt((Object)httpsPort);
            this.scheme = "https";
        }
        this.numDeepSearchNoResult = metricsRegistry.registerMeter("logviewer:num-deep-search-no-result");
        this.numFileScanned = metricsRegistry.registerHistogram("logviewer:num-files-scanned-per-deep-search");
        this.numSearchRequestNoResult = metricsRegistry.registerMeter("logviewer:num-search-request-no-result");
        this.numFileOpenExceptions = metricsRegistry.registerMeter("logviewer:num-file-open-exceptions");
        this.numFileReadExceptions = metricsRegistry.registerMeter("logviewer:num-file-read-exceptions");
        this.directoryCleaner = new DirectoryCleaner(metricsRegistry);
    }

    public Response searchLogFile(String fileName, String user, boolean isDaemon, String search, String numMatchesStr, String offsetStr, String callback, String origin) throws IOException, InvalidRequestException {
        Response response;
        boolean noResult = true;
        Path rootDir = isDaemon ? this.daemonLogRoot : this.logRoot;
        Path rawFile = rootDir.resolve(fileName);
        Path absFile = rawFile.toAbsolutePath().normalize();
        if (!absFile.startsWith(rootDir) || !rawFile.normalize().toString().equals(rawFile.toString())) {
            return this.searchLogFileNotFound(callback);
        }
        if (isDaemon && Paths.get(fileName, new String[0]).getNameCount() != 1) {
            return this.searchLogFileNotFound(callback);
        }
        if (absFile.toFile().exists()) {
            if (isDaemon || this.resourceAuthorizer.isUserAllowedToAccessFile(user, fileName)) {
                Integer numMatchesInt = numMatchesStr != null ? this.tryParseIntParam("num-matches", numMatchesStr) : null;
                Integer offsetInt = offsetStr != null ? this.tryParseIntParam("start-byte-offset", offsetStr) : null;
                try {
                    if (!StringUtils.isNotEmpty((String)search) || search.getBytes("UTF-8").length > 1024) {
                        throw new InvalidRequestException("Search substring must be between 1 and 1024 UTF-8 bytes in size (inclusive)");
                    }
                    HashMap<String, Object> entity = new HashMap<String, Object>();
                    entity.put("isDaemon", isDaemon ? "yes" : "no");
                    Map<String, Object> res = this.substringSearch(absFile, search, isDaemon, numMatchesInt, offsetInt);
                    entity.putAll(res);
                    noResult = ((List)res.get("matches")).isEmpty();
                    response = LogviewerResponseBuilder.buildSuccessJsonResponse(entity, callback, origin);
                }
                catch (Exception ex) {
                    response = LogviewerResponseBuilder.buildExceptionJsonResponse(ex, callback);
                }
            } else {
                response = LogviewerResponseBuilder.buildUnauthorizedUserJsonResponse(user, callback);
            }
        } else {
            response = this.searchLogFileNotFound(callback);
        }
        if (noResult) {
            this.numSearchRequestNoResult.mark();
        }
        return response;
    }

    private Response searchLogFileNotFound(String callback) {
        HashMap<String, String> entity = new HashMap<String, String>();
        entity.put("error", "Not Found");
        entity.put("errorMessage", "The file was not found on this node.");
        return new JsonResponseBuilder().setData(entity).setCallback(callback).setStatus(404).build();
    }

    public Response deepSearchLogsForTopology(String topologyId, String user, String search, String numMatchesStr, String portStr, String fileOffsetStr, String offsetStr, Boolean searchArchived, String callback, String origin) throws IOException {
        Object returnValue;
        int numMatchedFiles = 0;
        int numScannedFiles = 0;
        Path rootDir = this.logRoot;
        Path absTopoDir = rootDir.resolve(topologyId).toAbsolutePath().normalize();
        if (StringUtils.isEmpty((String)search) || !absTopoDir.toFile().exists() || !absTopoDir.startsWith(rootDir)) {
            returnValue = new ArrayList();
        } else {
            int fileOffset = ObjectReader.getInt((Object)fileOffsetStr, (Integer)0);
            int offset = ObjectReader.getInt((Object)offsetStr, (Integer)0);
            int numMatches = ObjectReader.getInt((Object)numMatchesStr, (Integer)1);
            if (StringUtils.isEmpty((String)portStr) || portStr.equals("*")) {
                try (Stream<Path> topoDir = Files.list(absTopoDir);){
                    Stream<List> portsOfLogs = topoDir.map(portDir -> this.logsForPort(user, (Path)portDir)).filter(logs -> logs != null && !logs.isEmpty());
                    if (BooleanUtils.isNotTrue((Boolean)searchArchived)) {
                        portsOfLogs = portsOfLogs.map(fl -> Collections.singletonList((Path)ListFunctionalSupport.first(fl)));
                    }
                    List matchedList = portsOfLogs.map(logs -> this.findNMatches((List<Path>)logs, numMatches, 0, 0, search)).collect(Collectors.toList());
                    numMatchedFiles = matchedList.stream().mapToInt(match -> match.getMatches().size()).sum();
                    numScannedFiles = matchedList.stream().mapToInt(match -> match.openedFiles).sum();
                    returnValue = matchedList;
                }
            } else {
                int port = Integer.parseInt(portStr);
                List slotsPorts = SupervisorUtils.getSlotsPorts(this.stormConf);
                boolean containsPort = slotsPorts.stream().anyMatch(slotPort -> slotPort != null && slotPort == port);
                if (!containsPort) {
                    returnValue = new ArrayList();
                } else {
                    Path absPortDir = absTopoDir.resolve(Integer.toString(port)).toAbsolutePath().normalize();
                    if (!absPortDir.toFile().exists() || !absPortDir.startsWith(absTopoDir)) {
                        returnValue = new ArrayList();
                    } else {
                        List<Path> filteredLogs = this.logsForPort(user, absPortDir);
                        if (BooleanUtils.isNotTrue((Boolean)searchArchived)) {
                            filteredLogs = Collections.singletonList(ListFunctionalSupport.first(filteredLogs));
                            fileOffset = 0;
                        }
                        returnValue = this.findNMatches(filteredLogs, numMatches, fileOffset, offset, search);
                        numMatchedFiles = ((Matched)returnValue).getMatches().size();
                        numScannedFiles = ((Matched)returnValue).openedFiles;
                    }
                }
            }
        }
        if (numMatchedFiles == 0) {
            this.numDeepSearchNoResult.mark();
        }
        this.numFileScanned.update(numScannedFiles);
        return LogviewerResponseBuilder.buildSuccessJsonResponse(returnValue, callback, origin);
    }

    private Integer tryParseIntParam(String paramName, String value) throws InvalidRequestException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidRequestException("Could not parse " + paramName + " to an integer");
        }
    }

    @VisibleForTesting
    Map<String, Object> substringSearch(Path file, String searchString) throws InvalidRequestException {
        return this.substringSearch(file, searchString, false, 10, 0);
    }

    @VisibleForTesting
    Map<String, Object> substringSearch(Path file, String searchString, int numMatches) throws InvalidRequestException {
        return this.substringSearch(file, searchString, false, numMatches, 0);
    }

    @VisibleForTesting
    Map<String, Object> substringSearch(Path file, String searchString, int numMatches, int startByteOffset) throws InvalidRequestException {
        return this.substringSearch(file, searchString, false, numMatches, startByteOffset);
    }

    /*
     * Exception decompiling
     */
    private Map<String, Object> substringSearch(Path file, String searchString, boolean isDaemon, Integer numMatches, Integer startByteOffset) throws InvalidRequestException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @VisibleForTesting
    Map<String, Object> substringSearchDaemonLog(Path file, String searchString) throws InvalidRequestException {
        return this.substringSearch(file, searchString, true, 10, 0);
    }

    @VisibleForTesting
    List<Path> logsForPort(String user, Path portDir) {
        try {
            List workerLogs = this.directoryCleaner.getFilesForDir(portDir).stream().filter(file -> WORKER_LOG_FILENAME_PATTERN.asPredicate().test(file.getFileName().toString())).collect(Collectors.toList());
            return workerLogs.stream().filter(log -> this.resourceAuthorizer.isUserAllowedToAccessFile(user, WorkerLogs.getTopologyPortWorkerLog(log))).map(p -> {
                try {
                    return Pair.of((Object)p, (Object)Files.getLastModifiedTime(p, new LinkOption[0]));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).sorted(Comparator.comparing(p -> (FileTime)p.getRight()).reversed()).map(p -> (Path)p.getLeft()).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    Matched findNMatches(List<Path> logs, int numMatches, int fileOffset, int startByteOffset, String targetStr) {
        logs = ListFunctionalSupport.drop(logs, fileOffset);
        LOG.debug("{} files to scan", (Object)logs.size());
        ArrayList<Map<String, Object>> matches = new ArrayList<Map<String, Object>>();
        int matchCount = 0;
        int scannedFiles = 0;
        while (!logs.isEmpty()) {
            Map<Object, Object> matchInLog;
            Path firstLog = logs.get(0);
            try {
                LOG.debug("Looking through {}", (Object)firstLog);
                matchInLog = this.substringSearch(firstLog, targetStr, numMatches - matchCount, startByteOffset);
                ++scannedFiles;
            }
            catch (InvalidRequestException e) {
                LOG.error("Can't search past end of file.", (Throwable)e);
                matchInLog = new HashMap();
            }
            String fileName = WorkerLogs.getTopologyPortWorkerLog(firstLog);
            ArrayList<Map<String, Object>> newMatches = new ArrayList<Map<String, Object>>(matches);
            HashMap<String, String> currentFileMatch = new HashMap<String, String>(matchInLog);
            currentFileMatch.put("fileName", fileName);
            Path firstLogAbsPath = firstLog.toAbsolutePath().normalize();
            currentFileMatch.put("port", PathUtil.truncatePathToLastElements(firstLogAbsPath, 2).getName(0).toString());
            newMatches.add(currentFileMatch);
            int newCount = matchCount + matchInLog.getOrDefault("matches", Collections.emptyList()).size();
            if (newCount == matchCount) {
                logs = ListFunctionalSupport.rest(logs);
                startByteOffset = 0;
                ++fileOffset;
                continue;
            }
            if (newCount >= numMatches) {
                matches = newMatches;
                break;
            }
            matches = newMatches;
            logs = ListFunctionalSupport.rest(logs);
            startByteOffset = 0;
            ++fileOffset;
            matchCount = newCount;
        }
        LOG.debug("scanned {} files", (Object)scannedFiles);
        return new Matched(fileOffset, targetStr, matches, scannedFiles);
    }

    private SubstringSearchResult bufferSubstringSearch(boolean isDaemon, Path file, int fileLength, int offsetToBuf, int initBufOffset, BufferedInputStream stream, Integer bytesSkipped, int bytesRead, ByteBuffer haystack, byte[] needle, List<Map<String, Object>> initialMatches, Integer numMatches, byte[] beforeBytes) throws IOException {
        int bufOffset = initBufOffset;
        List<Map<String, Object>> matches = initialMatches;
        while (true) {
            int offset = this.offsetOfBytes(haystack.array(), needle, bufOffset);
            if (matches.size() >= numMatches || offset < 0) break;
            int fileOffset = offsetToBuf + offset;
            int bytesNeededAfterMatch = haystack.limit() - 128 - needle.length;
            byte[] beforeArg = null;
            byte[] afterArg = null;
            if (offset < 128) {
                beforeArg = beforeBytes;
            }
            if (offset > bytesNeededAfterMatch) {
                afterArg = this.tryReadAhead(stream, haystack, offset, fileLength, bytesRead);
            }
            bufOffset = offset + needle.length;
            matches.add(this.mkMatchData(needle, haystack, offset, fileOffset, file.toAbsolutePath().normalize(), isDaemon, beforeArg, afterArg));
        }
        int beforeStrToOffset = Math.min(haystack.limit(), 1024);
        int beforeStrFromOffset = Math.max(0, beforeStrToOffset - 128);
        byte[] newBeforeBytes = Arrays.copyOfRange(haystack.array(), beforeStrFromOffset, beforeStrToOffset);
        Integer newByteOffset = matches.size() >= numMatches ? Integer.valueOf(((Number)ListFunctionalSupport.last(matches).get("byteOffset")).intValue() + needle.length) : Integer.valueOf(bytesSkipped + bytesRead - 1024);
        return new SubstringSearchResult(matches, newByteOffset, newBeforeBytes);
    }

    private int rotateGrepBuffer(ByteBuffer buf, BufferedInputStream stream, int totalBytesRead, int fileLength) throws IOException {
        byte[] bufArray = buf.array();
        System.arraycopy(bufArray, 1024, bufArray, 0, 1024);
        Arrays.fill(bufArray, 1024, bufArray.length, (byte)0);
        int bytesRead = stream.read(bufArray, 1024, Math.min(fileLength, 1024));
        buf.limit(1024 + bytesRead);
        return totalBytesRead + bytesRead;
    }

    private Map<String, Object> mkMatchData(byte[] needle, ByteBuffer haystack, int haystackOffset, int fileOffset, Path canonicalPath, boolean isDaemon, byte[] beforeBytes, byte[] afterBytes) throws UnsupportedEncodingException, UnknownHostException {
        String afterString;
        String beforeString;
        String url = isDaemon ? this.urlToMatchCenteredInLogPageDaemonFile(needle, canonicalPath, fileOffset, this.logviewerPort) : this.urlToMatchCenteredInLogPage(needle, canonicalPath, fileOffset, this.logviewerPort);
        byte[] haystackBytes = haystack.array();
        if (haystackOffset >= 128) {
            beforeString = new String(haystackBytes, haystackOffset - 128, 128, "UTF-8");
        } else {
            int numDesired;
            int beforeSize = beforeBytes != null ? beforeBytes.length : 0;
            int numExpected = Math.min(beforeSize, numDesired = Math.max(0, 128 - haystackOffset));
            if (numExpected > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(new String(beforeBytes, beforeSize - numExpected, numExpected, "UTF-8"));
                sb.append(new String(haystackBytes, 0, haystackOffset, "UTF-8"));
                beforeString = sb.toString();
            } else {
                beforeString = new String(haystackBytes, 0, haystackOffset, "UTF-8");
            }
        }
        int needleSize = needle.length;
        int afterOffset = haystackOffset + needleSize;
        int haystackSize = haystack.limit();
        if (afterOffset + 128 < haystackSize) {
            afterString = new String(haystackBytes, afterOffset, 128, "UTF-8");
        } else {
            int numDesired;
            int afterSize = afterBytes != null ? afterBytes.length : 0;
            int numExpected = Math.min(afterSize, numDesired = 128 - (haystackSize - afterOffset));
            if (numExpected > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(new String(haystackBytes, afterOffset, haystackSize - afterOffset, "UTF-8"));
                sb.append(new String(afterBytes, 0, numExpected, "UTF-8"));
                afterString = sb.toString();
            } else {
                afterString = new String(haystackBytes, afterOffset, haystackSize - afterOffset, "UTF-8");
            }
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("byteOffset", fileOffset);
        ret.put("beforeString", beforeString);
        ret.put("afterString", afterString);
        ret.put("matchString", new String(needle, "UTF-8"));
        ret.put("logviewerURL", url);
        return ret;
    }

    private byte[] tryReadAhead(BufferedInputStream stream, ByteBuffer haystack, int offset, int fileLength, int bytesRead) throws IOException {
        int numExpected = Math.min(fileLength - bytesRead, 128);
        byte[] afterBytes = new byte[numExpected];
        stream.mark(numExpected);
        stream.read(afterBytes, 0, numExpected);
        stream.reset();
        return afterBytes;
    }

    private int offsetOfBytes(byte[] buffer, byte[] search, int initOffset) {
        if (search.length <= 0) {
            throw new IllegalArgumentException("Search array should not be empty.");
        }
        if (initOffset < 0) {
            throw new IllegalArgumentException("Start offset shouldn't be negative.");
        }
        int offset = initOffset;
        int candidateOffset = initOffset;
        int valOffset = 0;
        int retOffset = 0;
        while (true) {
            if (search.length - valOffset <= 0) {
                retOffset = candidateOffset;
                break;
            }
            if (offset >= buffer.length) {
                retOffset = -1;
                break;
            }
            if (search[valOffset] != buffer[offset]) {
                int newOffset;
                offset = newOffset = candidateOffset + 1;
                candidateOffset = newOffset;
                valOffset = 0;
                continue;
            }
            ++offset;
            ++valOffset;
        }
        return retOffset;
    }

    private Map<String, Object> mkGrepResponse(byte[] searchBytes, Integer offset, List<Map<String, Object>> matches, Integer nextByteOffset) throws UnsupportedEncodingException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("searchString", new String(searchBytes, "UTF-8"));
        ret.put("startByteOffset", offset);
        ret.put("matches", matches);
        if (nextByteOffset != null) {
            ret.put("nextByteOffset", nextByteOffset);
        }
        return ret;
    }

    @VisibleForTesting
    String urlToMatchCenteredInLogPage(byte[] needle, Path canonicalPath, int offset, Integer port) throws UnknownHostException {
        String host = Utils.hostname();
        Path truncatedFilePath = PathUtil.truncatePathToLastElements(canonicalPath, 3);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("file", truncatedFilePath.toString());
        parameters.put("start", Math.max(0, offset - 25600 - needle.length / -2));
        parameters.put("length", 51200);
        return UrlBuilder.build(String.format(this.scheme + "://%s:%d/api/v1/log", host, port), parameters);
    }

    @VisibleForTesting
    String urlToMatchCenteredInLogPageDaemonFile(byte[] needle, Path canonicalPath, int offset, Integer port) throws UnknownHostException {
        String host = Utils.hostname();
        Path truncatedFilePath = PathUtil.truncatePathToLastElements(canonicalPath, 1);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("file", truncatedFilePath.toString());
        parameters.put("start", Math.max(0, offset - 25600 - needle.length / -2));
        parameters.put("length", 51200);
        return UrlBuilder.build(String.format(this.scheme + "://%s:%d/api/v1/daemonlog", host, port), parameters);
    }

    private static class SubstringSearchResult {
        private List<Map<String, Object>> matches;
        private Integer newByteOffset;
        private byte[] newBeforeBytes;

        SubstringSearchResult(List<Map<String, Object>> matches, Integer newByteOffset, byte[] newBeforeBytes) {
            this.matches = matches;
            this.newByteOffset = newByteOffset;
            this.newBeforeBytes = newBeforeBytes;
        }

        public List<Map<String, Object>> getMatches() {
            return this.matches;
        }

        public Integer getNewByteOffset() {
            return this.newByteOffset;
        }

        public byte[] getNewBeforeBytes() {
            return this.newBeforeBytes;
        }
    }

    @VisibleForTesting
    public static class Matched
    implements JSONAware {
        private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
        private int fileOffset;
        private String searchString;
        private List<Map<String, Object>> matches;
        @JsonIgnore
        private final int openedFiles;

        public Matched(int fileOffset, String searchString, List<Map<String, Object>> matches, int openedFiles) {
            this.fileOffset = fileOffset;
            this.searchString = searchString;
            this.matches = matches;
            this.openedFiles = openedFiles;
        }

        public int getFileOffset() {
            return this.fileOffset;
        }

        public String getSearchString() {
            return this.searchString;
        }

        public List<Map<String, Object>> getMatches() {
            return this.matches;
        }

        public String toJSONString() {
            try {
                return OBJECT_MAPPER.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

