/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.bonecp;

import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.ConnectionHandle;
import com.jolbox.bonecp.ConnectionStrategy;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractConnectionStrategy
implements ConnectionStrategy,
Serializable {
    private static final long serialVersionUID = 27805973487155497L;
    protected BoneCP pool;
    protected Lock terminationLock = new ReentrantLock();

    protected long preConnection() throws SQLException {
        long statsObtainTime = 0L;
        if (this.pool.poolShuttingDown) {
            throw new SQLException(this.pool.shutdownStackTrace);
        }
        if (this.pool.statisticsEnabled) {
            statsObtainTime = System.nanoTime();
            this.pool.statistics.incrementConnectionsRequested();
        }
        return statsObtainTime;
    }

    protected void postConnection(ConnectionHandle handle, long statsObtainTime) {
        handle.renewConnection();
        if (handle.getConnectionHook() != null) {
            handle.getConnectionHook().onCheckOut(handle);
        }
        if (this.pool.closeConnectionWatch) {
            this.pool.watchConnection(handle);
        }
        if (this.pool.statisticsEnabled) {
            this.pool.statistics.addCumulativeConnectionWaitTime(System.nanoTime() - statsObtainTime);
        }
    }

    public Connection getConnection() throws SQLException {
        long statsObtainTime = this.preConnection();
        ConnectionHandle result = (ConnectionHandle)this.getConnectionInternal();
        if (result != null) {
            this.postConnection(result, statsObtainTime);
        }
        return result;
    }

    protected abstract Connection getConnectionInternal() throws SQLException;

    public ConnectionHandle pollConnection() {
        return null;
    }

    public void cleanupConnection(ConnectionHandle oldHandle, ConnectionHandle newHandle) {
    }
}

