/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api.repl.commands;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hive.hcatalog.api.repl.Command;
import org.apache.hive.hcatalog.api.repl.ReplicationUtils;
import org.apache.hive.hcatalog.data.ReaderWriter;

public class ImportCommand
implements Command {
    private String importLocation;
    private String dbName = null;
    private String tableName = null;
    private Map<String, String> ptnDesc = null;
    private long eventId;
    private boolean isDefinitionOnly = false;

    public ImportCommand(String dbName, String tableName, Map<String, String> ptnDesc, String importLocation, boolean isDefinitionOnly, long eventId) {
        this.dbName = dbName;
        this.tableName = tableName;
        this.ptnDesc = ptnDesc;
        this.importLocation = importLocation;
        this.isDefinitionOnly = isDefinitionOnly;
        this.eventId = eventId;
    }

    public ImportCommand() {
    }

    @Override
    public List<String> get() {
        StringBuilder sb = new StringBuilder();
        sb.append("IMPORT TABLE ");
        sb.append(this.dbName);
        sb.append('.');
        sb.append(this.tableName);
        sb.append(ReplicationUtils.partitionDescriptor(this.ptnDesc));
        sb.append(" FROM '");
        sb.append(this.importLocation);
        sb.append('\'');
        return Collections.singletonList(sb.toString());
    }

    @Override
    public boolean isRetriable() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public List<String> getUndo() {
        throw new UnsupportedOperationException("Attempted to getUndo() on a repl import that does not support undo.");
    }

    @Override
    public List<String> cleanupLocationsPerRetry() {
        return Collections.emptyList();
    }

    @Override
    public List<String> cleanupLocationsAfterEvent() {
        return Collections.singletonList(this.importLocation);
    }

    @Override
    public long getEventId() {
        return this.eventId;
    }

    public void write(DataOutput dataOutput) throws IOException {
        ReaderWriter.writeDatum((DataOutput)dataOutput, (Object)this.dbName);
        ReaderWriter.writeDatum((DataOutput)dataOutput, (Object)this.tableName);
        ReaderWriter.writeDatum((DataOutput)dataOutput, this.ptnDesc);
        ReaderWriter.writeDatum((DataOutput)dataOutput, (Object)this.importLocation);
        ReaderWriter.writeDatum((DataOutput)dataOutput, (Object)this.isDefinitionOnly);
        ReaderWriter.writeDatum((DataOutput)dataOutput, (Object)this.eventId);
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.dbName = (String)ReaderWriter.readDatum((DataInput)dataInput);
        this.tableName = (String)ReaderWriter.readDatum((DataInput)dataInput);
        this.ptnDesc = (Map)ReaderWriter.readDatum((DataInput)dataInput);
        this.importLocation = (String)ReaderWriter.readDatum((DataInput)dataInput);
        this.isDefinitionOnly = (Boolean)ReaderWriter.readDatum((DataInput)dataInput);
        this.eventId = (Long)ReaderWriter.readDatum((DataInput)dataInput);
    }
}

