/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hive.hcatalog.api.HCatTable;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hive.hcatalog.data.schema.HCatSchemaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class HCatPartition {
    private static final Logger LOG = LoggerFactory.getLogger(HCatPartition.class);
    private HCatTable hcatTable;
    private String tableName;
    private String dbName = "default";
    private List<String> values;
    private int createTime;
    private int lastAccessTime;
    private StorageDescriptor sd;
    private List<HCatFieldSchema> columns;
    private Map<String, String> parameters;

    HCatPartition(HCatTable hcatTable, Partition partition) throws HCatException {
        this.hcatTable = hcatTable;
        this.tableName = partition.getTableName();
        this.dbName = partition.getDbName();
        this.createTime = partition.getCreateTime();
        this.lastAccessTime = partition.getLastAccessTime();
        this.parameters = partition.getParameters();
        this.values = partition.getValues();
        if (hcatTable != null && partition.getValuesSize() != hcatTable.getPartCols().size()) {
            throw new HCatException("Mismatched number of partition columns between table:" + hcatTable.getDbName() + "." + hcatTable.getTableName() + " and partition " + partition.getValues());
        }
        this.sd = partition.getSd();
        this.columns = HCatPartition.getColumns(this.sd);
    }

    public HCatPartition(HCatTable hcatTable, Map<String, String> partitionKeyValues, String location) throws HCatException {
        this.hcatTable = hcatTable;
        this.tableName = hcatTable.getTableName();
        this.dbName = hcatTable.getDbName();
        this.sd = new StorageDescriptor(hcatTable.getSd());
        this.sd.setLocation(location);
        this.columns = HCatPartition.getColumns(this.sd);
        this.createTime = (int)(System.currentTimeMillis() / 1000L);
        this.lastAccessTime = -1;
        this.values = new ArrayList<String>(hcatTable.getPartCols().size());
        for (HCatFieldSchema partField : hcatTable.getPartCols()) {
            if (!partitionKeyValues.containsKey(partField.getName())) {
                throw new HCatException("Missing value for partition-key '" + partField.getName() + "' in table: " + hcatTable.getDbName() + "." + hcatTable.getTableName());
            }
            this.values.add(partitionKeyValues.get(partField.getName()));
        }
    }

    public HCatPartition(HCatPartition rhs, Map<String, String> partitionKeyValues, String location) throws HCatException {
        this.hcatTable = rhs.hcatTable;
        this.tableName = rhs.tableName;
        this.dbName = rhs.dbName;
        this.sd = new StorageDescriptor(rhs.sd);
        this.sd.setLocation(location);
        this.columns = HCatPartition.getColumns(this.sd);
        this.createTime = (int)(System.currentTimeMillis() / 1000L);
        this.lastAccessTime = -1;
        this.values = new ArrayList<String>(this.hcatTable.getPartCols().size());
        for (HCatFieldSchema partField : this.hcatTable.getPartCols()) {
            if (!partitionKeyValues.containsKey(partField.getName())) {
                throw new HCatException("Missing value for partition-key '" + partField.getName() + "' in table: " + this.hcatTable.getDbName() + "." + this.hcatTable.getTableName());
            }
            this.values.add(partitionKeyValues.get(partField.getName()));
        }
    }

    private static List<HCatFieldSchema> getColumns(StorageDescriptor sd) throws HCatException {
        ArrayList<HCatFieldSchema> columns = new ArrayList<HCatFieldSchema>(sd.getColsSize());
        for (FieldSchema fieldSchema : sd.getCols()) {
            columns.add(HCatSchemaUtils.getHCatFieldSchema((FieldSchema)fieldSchema));
        }
        return columns;
    }

    Partition toHivePartition() throws HCatException {
        Partition hivePtn = new Partition();
        hivePtn.setDbName(this.dbName);
        hivePtn.setTableName(this.tableName);
        hivePtn.setValues(this.values);
        hivePtn.setParameters(this.parameters);
        if (this.sd.getLocation() == null) {
            LOG.warn("Partition location is not set! Attempting to construct default partition location.");
            try {
                String partName = Warehouse.makePartName((List)HCatSchemaUtils.getFieldSchemas(this.hcatTable.getPartCols()), this.values);
                this.sd.setLocation(new Path(this.hcatTable.getSd().getLocation(), partName).toString());
            }
            catch (MetaException exception) {
                throw new HCatException("Could not construct default partition-path for " + this.hcatTable.getDbName() + "." + this.hcatTable.getTableName() + "[" + this.values + "]");
            }
        }
        hivePtn.setSd(this.sd);
        hivePtn.setCreateTime((int)(System.currentTimeMillis() / 1000L));
        hivePtn.setLastAccessTimeIsSet(false);
        return hivePtn;
    }

    public HCatTable hcatTable() {
        return this.hcatTable;
    }

    public HCatPartition hcatTable(HCatTable hcatTable) {
        this.hcatTable = hcatTable;
        this.tableName = hcatTable.getTableName();
        this.dbName = hcatTable.getDbName();
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDatabaseName() {
        return this.dbName;
    }

    public List<HCatFieldSchema> getColumns() {
        return this.columns;
    }

    public List<HCatFieldSchema> getPartColumns() {
        return this.hcatTable.getPartCols();
    }

    public String getInputFormat() {
        return this.sd.getInputFormat();
    }

    public String getOutputFormat() {
        return this.sd.getOutputFormat();
    }

    public String getStorageHandler() {
        return (String)this.sd.getParameters().get("storage_handler");
    }

    public String getLocation() {
        return this.sd.getLocation();
    }

    public HCatPartition location(String location) {
        this.sd.setLocation(location);
        return this;
    }

    public String getSerDe() {
        return this.sd.getSerdeInfo().getSerializationLib();
    }

    public Map<String, String> getSerdeParams() {
        return this.sd.getSerdeInfo().getParameters();
    }

    public HCatPartition parameters(Map<String, String> parameters) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        if (!this.parameters.equals(parameters)) {
            this.parameters.clear();
            this.parameters.putAll(parameters);
        }
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public int getLastAccessTime() {
        return this.lastAccessTime;
    }

    public int getCreateTime() {
        return this.createTime;
    }

    public List<String> getValues() {
        return this.values;
    }

    public LinkedHashMap<String, String> getPartitionKeyValMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(this.hcatTable.getPartCols().size());
        for (int i = 0; i < this.hcatTable.getPartCols().size(); ++i) {
            map.put(this.hcatTable.getPartCols().get(i).getName(), this.values.get(i));
        }
        return map;
    }

    public HCatPartition setPartitionKeyValues(Map<String, String> partitionKeyValues) throws HCatException {
        for (HCatFieldSchema partField : this.hcatTable.getPartCols()) {
            if (!partitionKeyValues.containsKey(partField.getName())) {
                throw new HCatException("Missing value for partition-key '" + partField.getName() + "' in table: " + this.hcatTable.getDbName() + "." + this.hcatTable.getTableName());
            }
            this.values.add(partitionKeyValues.get(partField.getName()));
        }
        return this;
    }

    public List<String> getBucketCols() {
        return this.sd.getBucketCols();
    }

    public int getNumBuckets() {
        return this.sd.getNumBuckets();
    }

    public List<Order> getSortCols() {
        return this.sd.getSortCols();
    }

    public String toString() {
        return "HCatPartition [ tableName=" + this.tableName + ",dbName=" + this.dbName + ",values=" + this.values + ",createTime=" + this.createTime + ",lastAccessTime=" + this.lastAccessTime + ",sd=" + this.sd + ",parameters=" + this.parameters + "]";
    }
}

