/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.gzip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.annotation.Priority;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;

@Provider
@Priority(value=4000)
public class GZipDecoder
implements ReaderInterceptor {
    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException {
        String contentEncoding;
        if (!context.getHeaders().containsKey((Object)"Accept-Encoding")) {
            context.getHeaders().add((Object)"Accept-Encoding", (Object)"gzip");
        }
        if ((contentEncoding = (String)context.getHeaders().getFirst((Object)"Content-Encoding")) != null && (contentEncoding.equals("gzip") || contentEncoding.equals("x-gzip"))) {
            context.setInputStream((InputStream)new GZIPInputStream(context.getInputStream()));
        }
        return context.proceed();
    }
}

