/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.trace;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.ContextKey;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.trace.HBaseSemanticAttributes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class HFileContextAttributesBuilderConsumer
implements Consumer<AttributesBuilder> {
    public static final ContextKey<Consumer<AttributesBuilder>> CONTEXT_KEY = ContextKey.named((String)"db.hbase.io.hfile.context_attributes");
    private final HFileContext hFileContext;
    private boolean skipChecksum = false;
    private HBaseSemanticAttributes.ReadType readType = null;

    public HFileContextAttributesBuilderConsumer(HFileContext hFileContext) {
        this.hFileContext = Objects.requireNonNull(hFileContext);
    }

    public HFileContextAttributesBuilderConsumer setSkipChecksum(boolean skipChecksum) {
        this.skipChecksum = skipChecksum;
        return this;
    }

    public HFileContextAttributesBuilderConsumer setReadType(HBaseSemanticAttributes.ReadType readType) {
        this.readType = readType;
        return this;
    }

    @Override
    public void accept(AttributesBuilder builder) {
        if (this.hFileContext.getHFileName() != null) {
            builder.put(HBaseSemanticAttributes.HFILE_NAME_KEY, (Object)this.hFileContext.getHFileName());
        }
        if (this.hFileContext.getCompression() != null) {
            builder.put(HBaseSemanticAttributes.COMPRESSION_ALGORITHM_KEY, (Object)this.hFileContext.getCompression().getName());
        }
        if (this.hFileContext.getDataBlockEncoding() != null) {
            builder.put(HBaseSemanticAttributes.DATA_BLOCK_ENCODING_KEY, (Object)this.hFileContext.getDataBlockEncoding().name());
        }
        if (this.hFileContext.getEncryptionContext() != null && this.hFileContext.getEncryptionContext().getCipher() != null) {
            builder.put(HBaseSemanticAttributes.ENCRYPTION_CIPHER_KEY, (Object)this.hFileContext.getEncryptionContext().getCipher().getName());
        }
        if (!this.skipChecksum && this.hFileContext.getChecksumType() != null) {
            builder.put(HBaseSemanticAttributes.CHECKSUM_KEY, (Object)this.hFileContext.getChecksumType().getName());
        }
        if (this.readType != null) {
            builder.put(HBaseSemanticAttributes.READ_TYPE_KEY, (Object)this.readType.name());
        }
    }
}

