/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class FilterScalarOrColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final long value;
    private final int colNum;

    public FilterScalarOrColumn() {
        this.value = 0L;
        this.colNum = -1;
    }

    public FilterScalarOrColumn(long scalarVal, int colNum) {
        this.value = scalarVal;
        this.colNum = colNum;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.value == 0L) {
            super.evaluateChildren(batch);
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return "val " + this.value + ", " + this.getColumnParamString(1, this.colNum);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.FILTER).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.INT_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

