/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class GetOpenTxnsResponse
implements TBase<GetOpenTxnsResponse, _Fields>,
Serializable,
Cloneable,
Comparable<GetOpenTxnsResponse> {
    private static final TStruct STRUCT_DESC = new TStruct("GetOpenTxnsResponse");
    private static final TField TXN_HIGH_WATER_MARK_FIELD_DESC = new TField("txn_high_water_mark", 10, 1);
    private static final TField OPEN_TXNS_FIELD_DESC = new TField("open_txns", 15, 2);
    private static final TField MIN_OPEN_TXN_FIELD_DESC = new TField("min_open_txn", 10, 3);
    private static final TField ABORTED_BITS_FIELD_DESC = new TField("abortedBits", 11, 4);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    private long txn_high_water_mark;
    private List<Long> open_txns;
    private long min_open_txn;
    private ByteBuffer abortedBits;
    private static final int __TXN_HIGH_WATER_MARK_ISSET_ID = 0;
    private static final int __MIN_OPEN_TXN_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public GetOpenTxnsResponse() {
    }

    public GetOpenTxnsResponse(long txn_high_water_mark, List<Long> open_txns2, ByteBuffer abortedBits) {
        this();
        this.txn_high_water_mark = txn_high_water_mark;
        this.setTxn_high_water_markIsSet(true);
        this.open_txns = open_txns2;
        this.abortedBits = TBaseHelper.copyBinary(abortedBits);
    }

    public GetOpenTxnsResponse(GetOpenTxnsResponse other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.txn_high_water_mark = other.txn_high_water_mark;
        if (other.isSetOpen_txns()) {
            ArrayList<Long> __this__open_txns = new ArrayList<Long>(other.open_txns);
            this.open_txns = __this__open_txns;
        }
        this.min_open_txn = other.min_open_txn;
        if (other.isSetAbortedBits()) {
            this.abortedBits = TBaseHelper.copyBinary(other.abortedBits);
        }
    }

    public GetOpenTxnsResponse deepCopy() {
        return new GetOpenTxnsResponse(this);
    }

    @Override
    public void clear() {
        this.setTxn_high_water_markIsSet(false);
        this.txn_high_water_mark = 0L;
        this.open_txns = null;
        this.setMin_open_txnIsSet(false);
        this.min_open_txn = 0L;
        this.abortedBits = null;
    }

    public long getTxn_high_water_mark() {
        return this.txn_high_water_mark;
    }

    public void setTxn_high_water_mark(long txn_high_water_mark) {
        this.txn_high_water_mark = txn_high_water_mark;
        this.setTxn_high_water_markIsSet(true);
    }

    public void unsetTxn_high_water_mark() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 0);
    }

    public boolean isSetTxn_high_water_mark() {
        return EncodingUtils.testBit(this.__isset_bitfield, 0);
    }

    public void setTxn_high_water_markIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 0, value);
    }

    public int getOpen_txnsSize() {
        return this.open_txns == null ? 0 : this.open_txns.size();
    }

    public Iterator<Long> getOpen_txnsIterator() {
        return this.open_txns == null ? null : this.open_txns.iterator();
    }

    public void addToOpen_txns(long elem) {
        if (this.open_txns == null) {
            this.open_txns = new ArrayList<Long>();
        }
        this.open_txns.add(elem);
    }

    public List<Long> getOpen_txns() {
        return this.open_txns;
    }

    public void setOpen_txns(List<Long> open_txns2) {
        this.open_txns = open_txns2;
    }

    public void unsetOpen_txns() {
        this.open_txns = null;
    }

    public boolean isSetOpen_txns() {
        return this.open_txns != null;
    }

    public void setOpen_txnsIsSet(boolean value) {
        if (!value) {
            this.open_txns = null;
        }
    }

    public long getMin_open_txn() {
        return this.min_open_txn;
    }

    public void setMin_open_txn(long min_open_txn) {
        this.min_open_txn = min_open_txn;
        this.setMin_open_txnIsSet(true);
    }

    public void unsetMin_open_txn() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 1);
    }

    public boolean isSetMin_open_txn() {
        return EncodingUtils.testBit(this.__isset_bitfield, 1);
    }

    public void setMin_open_txnIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 1, value);
    }

    public byte[] getAbortedBits() {
        this.setAbortedBits(TBaseHelper.rightSize(this.abortedBits));
        return this.abortedBits == null ? null : this.abortedBits.array();
    }

    public ByteBuffer bufferForAbortedBits() {
        return TBaseHelper.copyBinary(this.abortedBits);
    }

    public void setAbortedBits(byte[] abortedBits) {
        this.abortedBits = abortedBits == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(abortedBits, abortedBits.length));
    }

    public void setAbortedBits(ByteBuffer abortedBits) {
        this.abortedBits = TBaseHelper.copyBinary(abortedBits);
    }

    public void unsetAbortedBits() {
        this.abortedBits = null;
    }

    public boolean isSetAbortedBits() {
        return this.abortedBits != null;
    }

    public void setAbortedBitsIsSet(boolean value) {
        if (!value) {
            this.abortedBits = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case TXN_HIGH_WATER_MARK: {
                if (value == null) {
                    this.unsetTxn_high_water_mark();
                    break;
                }
                this.setTxn_high_water_mark((Long)value);
                break;
            }
            case OPEN_TXNS: {
                if (value == null) {
                    this.unsetOpen_txns();
                    break;
                }
                this.setOpen_txns((List)value);
                break;
            }
            case MIN_OPEN_TXN: {
                if (value == null) {
                    this.unsetMin_open_txn();
                    break;
                }
                this.setMin_open_txn((Long)value);
                break;
            }
            case ABORTED_BITS: {
                if (value == null) {
                    this.unsetAbortedBits();
                    break;
                }
                this.setAbortedBits((ByteBuffer)value);
            }
        }
    }

    @Override
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TXN_HIGH_WATER_MARK: {
                return this.getTxn_high_water_mark();
            }
            case OPEN_TXNS: {
                return this.getOpen_txns();
            }
            case MIN_OPEN_TXN: {
                return this.getMin_open_txn();
            }
            case ABORTED_BITS: {
                return this.getAbortedBits();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TXN_HIGH_WATER_MARK: {
                return this.isSetTxn_high_water_mark();
            }
            case OPEN_TXNS: {
                return this.isSetOpen_txns();
            }
            case MIN_OPEN_TXN: {
                return this.isSetMin_open_txn();
            }
            case ABORTED_BITS: {
                return this.isSetAbortedBits();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof GetOpenTxnsResponse) {
            return this.equals((GetOpenTxnsResponse)that);
        }
        return false;
    }

    public boolean equals(GetOpenTxnsResponse that) {
        if (that == null) {
            return false;
        }
        boolean this_present_txn_high_water_mark = true;
        boolean that_present_txn_high_water_mark = true;
        if (this_present_txn_high_water_mark || that_present_txn_high_water_mark) {
            if (!this_present_txn_high_water_mark || !that_present_txn_high_water_mark) {
                return false;
            }
            if (this.txn_high_water_mark != that.txn_high_water_mark) {
                return false;
            }
        }
        boolean this_present_open_txns = this.isSetOpen_txns();
        boolean that_present_open_txns = that.isSetOpen_txns();
        if (this_present_open_txns || that_present_open_txns) {
            if (!this_present_open_txns || !that_present_open_txns) {
                return false;
            }
            if (!this.open_txns.equals(that.open_txns)) {
                return false;
            }
        }
        boolean this_present_min_open_txn = this.isSetMin_open_txn();
        boolean that_present_min_open_txn = that.isSetMin_open_txn();
        if (this_present_min_open_txn || that_present_min_open_txn) {
            if (!this_present_min_open_txn || !that_present_min_open_txn) {
                return false;
            }
            if (this.min_open_txn != that.min_open_txn) {
                return false;
            }
        }
        boolean this_present_abortedBits = this.isSetAbortedBits();
        boolean that_present_abortedBits = that.isSetAbortedBits();
        if (this_present_abortedBits || that_present_abortedBits) {
            if (!this_present_abortedBits || !that_present_abortedBits) {
                return false;
            }
            if (!this.abortedBits.equals(that.abortedBits)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_txn_high_water_mark = true;
        list.add(present_txn_high_water_mark);
        if (present_txn_high_water_mark) {
            list.add(this.txn_high_water_mark);
        }
        boolean present_open_txns = this.isSetOpen_txns();
        list.add(present_open_txns);
        if (present_open_txns) {
            list.add(this.open_txns);
        }
        boolean present_min_open_txn = this.isSetMin_open_txn();
        list.add(present_min_open_txn);
        if (present_min_open_txn) {
            list.add(this.min_open_txn);
        }
        boolean present_abortedBits = this.isSetAbortedBits();
        list.add(present_abortedBits);
        if (present_abortedBits) {
            list.add(this.abortedBits);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(GetOpenTxnsResponse other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetTxn_high_water_mark()).compareTo(other.isSetTxn_high_water_mark());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTxn_high_water_mark() && (lastComparison = TBaseHelper.compareTo(this.txn_high_water_mark, other.txn_high_water_mark)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOpen_txns()).compareTo(other.isSetOpen_txns());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOpen_txns() && (lastComparison = TBaseHelper.compareTo(this.open_txns, other.open_txns)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetMin_open_txn()).compareTo(other.isSetMin_open_txn());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMin_open_txn() && (lastComparison = TBaseHelper.compareTo(this.min_open_txn, other.min_open_txn)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetAbortedBits()).compareTo(other.isSetAbortedBits());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAbortedBits() && (lastComparison = TBaseHelper.compareTo(this.abortedBits, other.abortedBits)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (GetOpenTxnsResponse)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (GetOpenTxnsResponse)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GetOpenTxnsResponse(");
        boolean first = true;
        sb.append("txn_high_water_mark:");
        sb.append(this.txn_high_water_mark);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("open_txns:");
        if (this.open_txns == null) {
            sb.append("null");
        } else {
            sb.append(this.open_txns);
        }
        first = false;
        if (this.isSetMin_open_txn()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("min_open_txn:");
            sb.append(this.min_open_txn);
            first = false;
        }
        if (!first) {
            sb.append(", ");
        }
        sb.append("abortedBits:");
        if (this.abortedBits == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString(this.abortedBits, sb);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetTxn_high_water_mark()) {
            throw new TProtocolException("Required field 'txn_high_water_mark' is unset! Struct:" + this.toString());
        }
        if (!this.isSetOpen_txns()) {
            throw new TProtocolException("Required field 'open_txns' is unset! Struct:" + this.toString());
        }
        if (!this.isSetAbortedBits()) {
            throw new TProtocolException("Required field 'abortedBits' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new GetOpenTxnsResponseStandardSchemeFactory());
        schemes.put(TupleScheme.class, new GetOpenTxnsResponseTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.MIN_OPEN_TXN};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TXN_HIGH_WATER_MARK, new FieldMetaData("txn_high_water_mark", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.OPEN_TXNS, new FieldMetaData("open_txns", 1, new ListMetaData(15, new FieldValueMetaData(10))));
        tmpMap.put(_Fields.MIN_OPEN_TXN, new FieldMetaData("min_open_txn", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.ABORTED_BITS, new FieldMetaData("abortedBits", 1, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(GetOpenTxnsResponse.class, metaDataMap);
    }

    private static class GetOpenTxnsResponseTupleScheme
    extends TupleScheme<GetOpenTxnsResponse> {
        private GetOpenTxnsResponseTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, GetOpenTxnsResponse struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI64(struct.txn_high_water_mark);
            oprot.writeI32(struct.open_txns.size());
            Iterator iterator = struct.open_txns.iterator();
            while (iterator.hasNext()) {
                long _iter566 = (Long)iterator.next();
                oprot.writeI64(_iter566);
            }
            oprot.writeBinary(struct.abortedBits);
            BitSet optionals = new BitSet();
            if (struct.isSetMin_open_txn()) {
                optionals.set(0);
            }
            oprot.writeBitSet(optionals, 1);
            if (struct.isSetMin_open_txn()) {
                oprot.writeI64(struct.min_open_txn);
            }
        }

        @Override
        public void read(TProtocol prot, GetOpenTxnsResponse struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.txn_high_water_mark = iprot.readI64();
            struct.setTxn_high_water_markIsSet(true);
            TList _list567 = new TList(10, iprot.readI32());
            struct.open_txns = new ArrayList(_list567.size);
            for (int _i569 = 0; _i569 < _list567.size; ++_i569) {
                long _elem568 = iprot.readI64();
                struct.open_txns.add(_elem568);
            }
            struct.setOpen_txnsIsSet(true);
            struct.abortedBits = iprot.readBinary();
            struct.setAbortedBitsIsSet(true);
            BitSet incoming = iprot.readBitSet(1);
            if (incoming.get(0)) {
                struct.min_open_txn = iprot.readI64();
                struct.setMin_open_txnIsSet(true);
            }
        }
    }

    private static class GetOpenTxnsResponseTupleSchemeFactory
    implements SchemeFactory {
        private GetOpenTxnsResponseTupleSchemeFactory() {
        }

        public GetOpenTxnsResponseTupleScheme getScheme() {
            return new GetOpenTxnsResponseTupleScheme();
        }
    }

    private static class GetOpenTxnsResponseStandardScheme
    extends StandardScheme<GetOpenTxnsResponse> {
        private GetOpenTxnsResponseStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, GetOpenTxnsResponse struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 10) {
                            struct.txn_high_water_mark = iprot.readI64();
                            struct.setTxn_high_water_markIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 15) {
                            TList _list562 = iprot.readListBegin();
                            struct.open_txns = new ArrayList(_list562.size);
                            for (int _i564 = 0; _i564 < _list562.size; ++_i564) {
                                long _elem563 = iprot.readI64();
                                struct.open_txns.add(_elem563);
                            }
                            iprot.readListEnd();
                            struct.setOpen_txnsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 10) {
                            struct.min_open_txn = iprot.readI64();
                            struct.setMin_open_txnIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.abortedBits = iprot.readBinary();
                            struct.setAbortedBitsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, GetOpenTxnsResponse struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(TXN_HIGH_WATER_MARK_FIELD_DESC);
            oprot.writeI64(struct.txn_high_water_mark);
            oprot.writeFieldEnd();
            if (struct.open_txns != null) {
                oprot.writeFieldBegin(OPEN_TXNS_FIELD_DESC);
                oprot.writeListBegin(new TList(10, struct.open_txns.size()));
                Iterator iterator = struct.open_txns.iterator();
                while (iterator.hasNext()) {
                    long _iter565 = (Long)iterator.next();
                    oprot.writeI64(_iter565);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetMin_open_txn()) {
                oprot.writeFieldBegin(MIN_OPEN_TXN_FIELD_DESC);
                oprot.writeI64(struct.min_open_txn);
                oprot.writeFieldEnd();
            }
            if (struct.abortedBits != null) {
                oprot.writeFieldBegin(ABORTED_BITS_FIELD_DESC);
                oprot.writeBinary(struct.abortedBits);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class GetOpenTxnsResponseStandardSchemeFactory
    implements SchemeFactory {
        private GetOpenTxnsResponseStandardSchemeFactory() {
        }

        public GetOpenTxnsResponseStandardScheme getScheme() {
            return new GetOpenTxnsResponseStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TXN_HIGH_WATER_MARK(1, "txn_high_water_mark"),
        OPEN_TXNS(2, "open_txns"),
        MIN_OPEN_TXN(3, "min_open_txn"),
        ABORTED_BITS(4, "abortedBits");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TXN_HIGH_WATER_MARK;
                }
                case 2: {
                    return OPEN_TXNS;
                }
                case 3: {
                    return MIN_OPEN_TXN;
                }
                case 4: {
                    return ABORTED_BITS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

