/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.curator.framework.imps;

import java.util.UUID;
import org.apache.storm.shade.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.storm.shade.org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProtectedMode {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile String protectedId = null;
    private volatile long sessionId = 0L;

    ProtectedMode() {
    }

    void setProtectedMode() {
        this.resetProtectedId();
    }

    void resetProtectedId() {
        this.protectedId = UUID.randomUUID().toString();
    }

    boolean doProtected() {
        return this.protectedId != null;
    }

    String protectedId() {
        return this.protectedId;
    }

    void checkSetSessionId(CuratorFrameworkImpl client, CreateMode createMode) throws Exception {
        if (this.doProtected() && this.sessionId == 0L && createMode.isEphemeral()) {
            this.sessionId = client.getZooKeeper().getSessionId();
        }
    }

    String validateFoundNode(CuratorFrameworkImpl client, CreateMode createMode, String foundNode) throws Exception {
        long clientSessionId;
        if (this.doProtected() && createMode.isEphemeral() && this.sessionId != (clientSessionId = client.getZooKeeper().getSessionId())) {
            this.log.info("Session has changed during protected mode with ephemeral. old: {} new: {}", (Object)this.sessionId, (Object)clientSessionId);
            if (foundNode != null) {
                this.log.info("Deleted old session's found node: {}", (Object)foundNode);
                client.getFailedDeleteManager().executeGuaranteedOperationInBackground(foundNode);
                foundNode = null;
            }
            this.sessionId = clientSessionId;
        }
        return foundNode;
    }
}

