/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.storm.shade.org.apache.commons.io.FileUtils;
import org.apache.storm.utils.Time;

public class VersionedStore {
    private static final String FINISHED_VERSION_SUFFIX = ".version";
    private String root;

    public VersionedStore(String path, boolean createRootDir) throws IOException {
        this.root = path;
        if (createRootDir) {
            this.mkdirs(this.root);
        }
    }

    public String getRoot() {
        return this.root;
    }

    public String versionPath(long version) {
        return new File(this.root, "" + version).getAbsolutePath();
    }

    public String mostRecentVersionPath() throws IOException {
        Long v = this.mostRecentVersion();
        if (v == null) {
            return null;
        }
        return this.versionPath(v);
    }

    public String mostRecentVersionPath(long maxVersion) throws IOException {
        Long v = this.mostRecentVersion(maxVersion);
        if (v == null) {
            return null;
        }
        return this.versionPath(v);
    }

    public Long mostRecentVersion() throws IOException {
        List<Long> all = this.getAllVersions();
        if (all.size() == 0) {
            return null;
        }
        return all.get(0);
    }

    public Long mostRecentVersion(long maxVersion) throws IOException {
        List<Long> all = this.getAllVersions();
        for (Long v : all) {
            if (v > maxVersion) continue;
            return v;
        }
        return null;
    }

    public String createVersion() throws IOException {
        Long mostRecent = this.mostRecentVersion();
        long version = Time.currentTimeMillis();
        if (mostRecent != null && version <= mostRecent) {
            version = mostRecent + 1L;
        }
        return this.createVersion(version);
    }

    public String createVersion(long version) throws IOException {
        String ret = this.versionPath(version);
        if (this.getAllVersions().contains(version)) {
            throw new RuntimeException("Version already exists or data already exists");
        }
        return ret;
    }

    public void failVersion(String path) throws IOException {
        this.deleteVersion(this.validateAndGetVersion(path));
    }

    public void deleteVersion(long version) throws IOException {
        File versionFile = new File(this.versionPath(version));
        File tokenFile = new File(this.tokenPath(version));
        if (tokenFile.exists()) {
            FileUtils.forceDelete((File)tokenFile);
        }
        if (versionFile.exists()) {
            FileUtils.forceDelete((File)versionFile);
        }
    }

    public void succeedVersion(String path) throws IOException {
        long version = this.validateAndGetVersion(path);
        this.createNewFile(this.tokenPath(version));
    }

    public void cleanup() throws IOException {
        this.cleanup(-1);
    }

    public void cleanup(int versionsToKeep) throws IOException {
        List<Long> versions = this.getAllVersions();
        if (versionsToKeep >= 0) {
            versions = versions.subList(0, Math.min(versions.size(), versionsToKeep));
        }
        HashSet<Long> keepers = new HashSet<Long>(versions);
        for (String p : this.listDir(this.root)) {
            Long v = this.parseVersion(p);
            if (v == null || keepers.contains(v)) continue;
            this.deleteVersion(v);
        }
    }

    public List<Long> getAllVersions() throws IOException {
        ArrayList<Long> ret = new ArrayList<Long>();
        for (String s : this.listDir(this.root)) {
            if (!s.endsWith(FINISHED_VERSION_SUFFIX) || !new File(s.substring(0, s.length() - FINISHED_VERSION_SUFFIX.length())).exists()) continue;
            ret.add(this.validateAndGetVersion(s));
        }
        Collections.sort(ret);
        Collections.reverse(ret);
        return ret;
    }

    private String tokenPath(long version) {
        return new File(this.root, version + FINISHED_VERSION_SUFFIX).getAbsolutePath();
    }

    private long validateAndGetVersion(String path) {
        Long v = this.parseVersion(path);
        if (v == null) {
            throw new RuntimeException(path + " is not a valid version");
        }
        return v;
    }

    private Long parseVersion(String path) {
        String name = new File(path).getName();
        if (name.endsWith(FINISHED_VERSION_SUFFIX)) {
            name = name.substring(0, name.length() - FINISHED_VERSION_SUFFIX.length());
        }
        try {
            return Long.parseLong(name);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void createNewFile(String path) throws IOException {
        new File(path).createNewFile();
    }

    private void mkdirs(String path) throws IOException {
        new File(path).mkdirs();
    }

    private List<String> listDir(String dir) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        File[] contents = new File(dir).listFiles();
        if (contents != null) {
            for (File f : contents) {
                ret.add(f.getAbsolutePath());
            }
        }
        return ret;
    }
}

