/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.topology;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.storm.Config;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseRichSpout;
import org.apache.storm.trident.spout.ITridentSpout;
import org.apache.storm.trident.topology.TransactionAttempt;
import org.apache.storm.trident.topology.state.TransactionalState;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.WindowedTimeThrottler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterBatchCoordinator
extends BaseRichSpout {
    public static final Logger LOG = LoggerFactory.getLogger(MasterBatchCoordinator.class);
    public static final long INIT_TXID = 1L;
    public static final String BATCH_STREAM_ID = "$batch";
    public static final String COMMIT_STREAM_ID = "$commit";
    public static final String SUCCESS_STREAM_ID = "$success";
    private static final String CURRENT_TX = "currtx";
    private static final String CURRENT_ATTEMPTS = "currattempts";
    TreeMap<Long, TransactionStatus> activeTx = new TreeMap();
    TreeMap<Long, Integer> attemptIds;
    Long currTransaction;
    int maxTransactionActive;
    List<ITridentSpout.BatchCoordinator> coordinators = new ArrayList<ITridentSpout.BatchCoordinator>();
    List<String> managedSpoutIds;
    List<ITridentSpout> spouts;
    WindowedTimeThrottler throttler;
    boolean active = true;
    private List<TransactionalState> states = new ArrayList<TransactionalState>();
    private SpoutOutputCollector collector;

    public MasterBatchCoordinator(List<String> spoutIds, List<ITridentSpout> spouts) {
        if (spoutIds.isEmpty()) {
            throw new IllegalArgumentException("Must manage at least one spout");
        }
        this.managedSpoutIds = spoutIds;
        this.spouts = spouts;
        LOG.debug("Created {}", (Object)this);
    }

    public List<String> getManagedSpoutIds() {
        return this.managedSpoutIds;
    }

    @Override
    public void activate() {
        this.active = true;
    }

    @Override
    public void deactivate() {
        this.active = false;
    }

    @Override
    public void open(Map<String, Object> conf, TopologyContext context, SpoutOutputCollector collector) {
        this.throttler = new WindowedTimeThrottler((Number)conf.get("topology.trident.batch.emit.interval.millis"), 1);
        for (String spoutId : this.managedSpoutIds) {
            this.states.add(TransactionalState.newCoordinatorState(conf, spoutId));
        }
        this.currTransaction = this.getStoredCurrTransaction();
        this.collector = collector;
        Number active = (Number)conf.get("topology.max.spout.pending");
        this.maxTransactionActive = active == null ? 1 : active.intValue();
        this.attemptIds = this.getStoredCurrAttempts(this.currTransaction, this.maxTransactionActive);
        for (int i = 0; i < this.spouts.size(); ++i) {
            String txId = this.managedSpoutIds.get(i);
            this.coordinators.add(this.spouts.get(i).getCoordinator(txId, conf, context));
        }
        LOG.debug("Opened {}", (Object)this);
    }

    @Override
    public void close() {
        for (TransactionalState state : this.states) {
            state.close();
        }
        LOG.debug("Closed {}", (Object)this);
    }

    @Override
    public void nextTuple() {
        this.sync();
    }

    @Override
    public void ack(Object msgId) {
        TransactionAttempt tx = (TransactionAttempt)msgId;
        TransactionStatus status = this.activeTx.get(tx.getTransactionId());
        LOG.debug("Ack. [tx_attempt = {}], [tx_status = {}], [{}]", new Object[]{tx, status, this});
        if (status != null && tx.equals(status.attempt)) {
            if (status.status == AttemptStatus.PROCESSING) {
                status.status = AttemptStatus.PROCESSED;
                LOG.debug("Changed status. [tx_attempt = {}] [tx_status = {}]", (Object)tx, (Object)status);
            } else if (status.status == AttemptStatus.COMMITTING) {
                this.activeTx.remove(tx.getTransactionId());
                this.attemptIds.remove(tx.getTransactionId());
                this.collector.emit(SUCCESS_STREAM_ID, new Values(tx));
                this.currTransaction = this.nextTransactionId(tx.getTransactionId());
                for (TransactionalState state : this.states) {
                    state.setData(CURRENT_TX, this.currTransaction);
                }
                LOG.debug("Emitted on [stream = {}], [tx_attempt = {}], [tx_status = {}], [{}]", new Object[]{SUCCESS_STREAM_ID, tx, status, this});
            }
            this.sync();
        }
    }

    @Override
    public void fail(Object msgId) {
        TransactionAttempt tx = (TransactionAttempt)msgId;
        TransactionStatus stored = this.activeTx.remove(tx.getTransactionId());
        LOG.debug("Fail. [tx_attempt = {}], [tx_status = {}], [{}]", new Object[]{tx, stored, this});
        if (stored != null && tx.equals(stored.attempt)) {
            this.activeTx.tailMap(tx.getTransactionId()).clear();
            this.sync();
        }
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declareStream(BATCH_STREAM_ID, new Fields("tx"));
        declarer.declareStream(COMMIT_STREAM_ID, new Fields("tx"));
        declarer.declareStream(SUCCESS_STREAM_ID, new Fields("tx"));
    }

    private void sync() {
        TransactionStatus maybeCommit = this.activeTx.get(this.currTransaction);
        if (maybeCommit != null && maybeCommit.status == AttemptStatus.PROCESSED) {
            maybeCommit.status = AttemptStatus.COMMITTING;
            this.collector.emit(COMMIT_STREAM_ID, new Values(maybeCommit.attempt), maybeCommit.attempt);
            LOG.debug("Emitted on [stream = {}], [tx_status = {}], [{}]", new Object[]{COMMIT_STREAM_ID, maybeCommit, this});
        }
        if (this.active && this.activeTx.size() < this.maxTransactionActive) {
            Long curr = this.currTransaction;
            for (int i = 0; i < this.maxTransactionActive; ++i) {
                if (!this.activeTx.containsKey(curr) && this.isReady(curr)) {
                    Integer attemptId = this.attemptIds.get(curr);
                    if (attemptId == null) {
                        attemptId = 0;
                    } else {
                        Integer n = attemptId;
                        Integer n2 = attemptId = Integer.valueOf(attemptId + 1);
                    }
                    this.attemptIds.put(curr, attemptId);
                    for (TransactionalState state : this.states) {
                        state.setData(CURRENT_ATTEMPTS, this.attemptIds);
                    }
                    TransactionAttempt attempt = new TransactionAttempt(curr, attemptId);
                    TransactionStatus newTransactionStatus = new TransactionStatus(attempt);
                    this.activeTx.put(curr, newTransactionStatus);
                    this.collector.emit(BATCH_STREAM_ID, new Values(attempt), attempt);
                    LOG.debug("Emitted on [stream = {}], [tx_attempt = {}], [tx_status = {}], [{}]", new Object[]{BATCH_STREAM_ID, attempt, newTransactionStatus, this});
                    this.throttler.markEvent();
                }
                curr = this.nextTransactionId(curr);
            }
        }
    }

    private boolean isReady(long txid) {
        if (this.throttler.isThrottled()) {
            return false;
        }
        for (ITridentSpout.BatchCoordinator coord : this.coordinators) {
            if (!coord.isReady(txid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        Config ret = new Config();
        ret.setMaxTaskParallelism(1);
        ret.registerSerialization(TransactionAttempt.class);
        return ret;
    }

    private Long nextTransactionId(Long id) {
        return id + 1L;
    }

    private Long getStoredCurrTransaction() {
        Long ret = 1L;
        for (TransactionalState state : this.states) {
            Long curr = (Long)state.getData(CURRENT_TX);
            if (curr == null || curr.compareTo(ret) <= 0) continue;
            ret = curr;
        }
        return ret;
    }

    private TreeMap<Long, Integer> getStoredCurrAttempts(long currTransaction, int maxBatches) {
        TreeMap<Long, Integer> ret = new TreeMap<Long, Integer>();
        for (TransactionalState state : this.states) {
            HashMap attempts = (HashMap)state.getData(CURRENT_ATTEMPTS);
            if (attempts == null) {
                attempts = new HashMap();
            }
            for (Map.Entry e : attempts.entrySet()) {
                Number txidObj = e.getKey() instanceof String ? (Number)Long.parseLong((String)e.getKey()) : (Number)((Number)e.getKey());
                long txid = txidObj.longValue();
                int attemptId = ((Number)e.getValue()).intValue();
                Integer curr = ret.get(txid);
                if (curr != null && attemptId <= curr) continue;
                ret.put(txid, attemptId);
            }
        }
        ret.headMap(currTransaction).clear();
        ret.tailMap(currTransaction + (long)maxBatches - 1L).clear();
        return ret;
    }

    public String toString() {
        return "MasterBatchCoordinator{states=" + this.states + ", activeTx=" + this.activeTx + ", attemptIds=" + this.attemptIds + ", collector=" + this.collector + ", currTransaction=" + this.currTransaction + ", maxTransactionActive=" + this.maxTransactionActive + ", coordinators=" + this.coordinators + ", managedSpoutIds=" + this.managedSpoutIds + ", spouts=" + this.spouts + ", throttler=" + this.throttler + ", active=" + this.active + "}";
    }

    private static class TransactionStatus {
        TransactionAttempt attempt;
        AttemptStatus status;

        TransactionStatus(TransactionAttempt attempt) {
            this.attempt = attempt;
            this.status = AttemptStatus.PROCESSING;
        }

        public String toString() {
            return this.attempt.toString() + " <" + this.status.toString() + ">";
        }
    }

    private static enum AttemptStatus {
        PROCESSING,
        PROCESSED,
        COMMITTING;

    }
}

