/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.spout;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.storm.spout.ISpoutOutputCollector;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.spout.ITridentSpout;
import org.apache.storm.trident.topology.TransactionAttempt;
import org.apache.storm.trident.util.TridentUtils;
import org.apache.storm.tuple.Fields;
import org.apache.storm.utils.RotatingMap;

public class RichSpoutBatchExecutor
implements ITridentSpout<Object> {
    public static final String MAX_BATCH_SIZE_CONF = "topology.spout.max.batch.size";
    IRichSpout spout;

    public RichSpoutBatchExecutor(IRichSpout spout) {
        this.spout = spout;
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return this.spout.getComponentConfiguration();
    }

    @Override
    public Fields getOutputFields() {
        return TridentUtils.getSingleOutputStreamFields(this.spout);
    }

    @Override
    public ITridentSpout.BatchCoordinator<Object> getCoordinator(String txStateId, Map<String, Object> conf, TopologyContext context) {
        return new RichSpoutCoordinator();
    }

    @Override
    public ITridentSpout.Emitter<Object> getEmitter(String txStateId, Map<String, Object> conf, TopologyContext context) {
        return new RichSpoutEmitter(conf, context);
    }

    class RichSpoutEmitter
    implements ITridentSpout.Emitter<Object> {
        int maxBatchSize;
        boolean prepared = false;
        CaptureCollector collector;
        RotatingMap<Long, List<Object>> idsMap;
        Map conf;
        TopologyContext context;
        long lastRotate = System.currentTimeMillis();
        long rotateTime;

        RichSpoutEmitter(Map<String, Object> conf, TopologyContext context) {
            this.conf = conf;
            this.context = context;
            Number batchSize = (Number)conf.get(RichSpoutBatchExecutor.MAX_BATCH_SIZE_CONF);
            if (batchSize == null) {
                batchSize = 1000;
            }
            this.maxBatchSize = batchSize.intValue();
            this.collector = new CaptureCollector();
            this.idsMap = new RotatingMap(3);
            this.rotateTime = 1000L * (long)((Number)conf.get("topology.message.timeout.secs")).intValue();
        }

        @Override
        public void emitBatch(TransactionAttempt tx, Object coordinatorMeta, TridentCollector collector) {
            long txid = tx.getTransactionId();
            long now = System.currentTimeMillis();
            if (now - this.lastRotate > this.rotateTime) {
                Map<Long, List<Object>> failed = this.idsMap.rotate();
                for (Long id : failed.keySet()) {
                    this.fail(id);
                }
                this.lastRotate = now;
            }
            if (this.idsMap.containsKey(txid)) {
                this.fail(txid);
            }
            this.collector.reset(collector);
            if (!this.prepared) {
                RichSpoutBatchExecutor.this.spout.open(this.conf, this.context, new SpoutOutputCollector(this.collector));
                this.prepared = true;
            }
            for (int i = 0; i < this.maxBatchSize; ++i) {
                RichSpoutBatchExecutor.this.spout.nextTuple();
                if (this.collector.numEmitted < i) break;
            }
            this.idsMap.put(txid, this.collector.ids);
            this.collector.pendingCount = this.idsMap.size();
        }

        @Override
        public void success(TransactionAttempt tx) {
            this.ack(tx.getTransactionId());
        }

        private void ack(long batchId) {
            List<Object> ids = this.idsMap.remove(batchId);
            if (ids != null) {
                for (Object id : ids) {
                    RichSpoutBatchExecutor.this.spout.ack(id);
                }
            }
        }

        private void fail(long batchId) {
            List<Object> ids = this.idsMap.remove(batchId);
            if (ids != null) {
                for (Object id : ids) {
                    RichSpoutBatchExecutor.this.spout.fail(id);
                }
            }
        }

        @Override
        public void close() {
            RichSpoutBatchExecutor.this.spout.close();
        }
    }

    static class CaptureCollector
    implements ISpoutOutputCollector {
        public List<Object> ids;
        public int numEmitted;
        public long pendingCount;
        TridentCollector collector;

        CaptureCollector() {
        }

        public void reset(TridentCollector c) {
            this.collector = c;
            this.ids = new ArrayList<Object>();
        }

        @Override
        public void reportError(Throwable t) {
            this.collector.reportError(t);
        }

        @Override
        public List<Integer> emit(String stream, List<Object> values, Object id) {
            if (id != null) {
                this.ids.add(id);
            }
            ++this.numEmitted;
            this.collector.emit(values);
            return null;
        }

        @Override
        public void emitDirect(int task, String stream, List<Object> values, Object id) {
            throw new UnsupportedOperationException("Trident does not support direct streams");
        }

        @Override
        public void flush() {
            this.collector.flush();
        }

        @Override
        public long getPendingCount() {
            return this.pendingCount;
        }
    }

    private static class RichSpoutCoordinator
    implements ITridentSpout.BatchCoordinator<Object> {
        private RichSpoutCoordinator() {
        }

        @Override
        public Object initializeTransaction(long txid, Object prevMetadata, Object currMetadata) {
            return null;
        }

        @Override
        public void success(long txid) {
        }

        @Override
        public boolean isReady(long txid) {
            return true;
        }

        @Override
        public void close() {
        }
    }
}

