/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import java.util.Map;
import org.apache.storm.security.auth.ClientAuthUtils;
import org.apache.storm.security.auth.ITransportPlugin;
import org.apache.storm.security.auth.TBackoffConnect;
import org.apache.storm.security.auth.ThriftConnectionType;
import org.apache.storm.thrift.protocol.TBinaryProtocol;
import org.apache.storm.thrift.protocol.TProtocol;
import org.apache.storm.thrift.transport.TSocket;
import org.apache.storm.thrift.transport.TTransport;
import org.apache.storm.utils.ObjectReader;

public class ThriftClient
implements AutoCloseable {
    protected TProtocol protocol;
    protected boolean retryForever = false;
    private TTransport transport;
    private String host;
    private Integer port;
    private Integer timeout;
    private Map conf;
    private ThriftConnectionType type;
    private String asUser;

    public ThriftClient(Map<String, Object> topoConf, ThriftConnectionType type, String host) {
        this(topoConf, type, host, null, null, null);
    }

    public ThriftClient(Map<String, Object> topoConf, ThriftConnectionType type, String host, Integer port, Integer timeout) {
        this(topoConf, type, host, port, timeout, null);
    }

    public ThriftClient(Map<String, Object> topoConf, ThriftConnectionType type, String host, Integer port, Integer timeout, String asUser) {
        if (host == null) {
            throw new IllegalArgumentException("host is not set");
        }
        if (port == null) {
            port = type.getPort(topoConf);
        }
        if (timeout == null) {
            timeout = type.getSocketTimeOut(topoConf);
        }
        if (port <= 0 && !type.isFake()) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        this.host = host;
        this.port = port;
        this.timeout = timeout;
        this.conf = topoConf;
        this.type = type;
        this.asUser = asUser;
        if (!type.isFake()) {
            this.reconnect();
        }
    }

    public synchronized TTransport transport() {
        return this.transport;
    }

    public synchronized void reconnect() {
        this.close();
        TSocket socket = null;
        try {
            socket = new TSocket(this.host, this.port.intValue());
            if (this.timeout != null) {
                socket.setTimeout(this.timeout.intValue());
            }
            ITransportPlugin transportPlugin = ClientAuthUtils.getTransportPlugin(this.type, this.conf);
            TBackoffConnect connectionRetry = new TBackoffConnect(ObjectReader.getInt(this.conf.get("storm.nimbus.retry.times")), ObjectReader.getInt(this.conf.get("storm.nimbus.retry.interval.millis")), ObjectReader.getInt(this.conf.get("storm.nimbus.retry.intervalceiling.millis")), this.retryForever);
            this.transport = connectionRetry.doConnectWithRetry(transportPlugin, (TTransport)socket, this.host, this.asUser);
        }
        catch (Exception ex) {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new RuntimeException(ex);
        }
        this.protocol = null;
        if (this.transport != null) {
            this.protocol = new TBinaryProtocol(this.transport);
        }
    }

    @Override
    public synchronized void close() {
        if (this.transport != null) {
            this.transport.close();
            this.transport = null;
            this.protocol = null;
        }
    }
}

