/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.executor.spout;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.storm.ICredentialsListener;
import org.apache.storm.daemon.StormCommon;
import org.apache.storm.daemon.Task;
import org.apache.storm.daemon.worker.WorkerState;
import org.apache.storm.executor.Executor;
import org.apache.storm.executor.TupleInfo;
import org.apache.storm.executor.spout.SpoutOutputCollectorImpl;
import org.apache.storm.hooks.info.SpoutAckInfo;
import org.apache.storm.hooks.info.SpoutFailInfo;
import org.apache.storm.metrics2.RateCounter;
import org.apache.storm.policy.IWaitStrategy;
import org.apache.storm.spout.ISpout;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.stats.SpoutExecutorStats;
import org.apache.storm.tuple.AddressedTuple;
import org.apache.storm.tuple.TupleImpl;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.MutableLong;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ReflectionUtils;
import org.apache.storm.utils.RotatingMap;
import org.apache.storm.utils.Time;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpoutExecutor
extends Executor {
    private static final Logger LOG = LoggerFactory.getLogger(SpoutExecutor.class);
    private final IWaitStrategy spoutWaitStrategy = (IWaitStrategy)ReflectionUtils.newInstance((String)this.topoConf.get("topology.spout.wait.strategy"));
    private final IWaitStrategy backPressureWaitStrategy;
    private final AtomicBoolean lastActive;
    private final MutableLong emittedCount;
    private final MutableLong emptyEmitStreak;
    private final boolean hasAckers;
    private final SpoutExecutorStats stats;
    SpoutOutputCollectorImpl spoutOutputCollector;
    private Integer maxSpoutPending;
    private List<ISpout> spouts;
    private List<SpoutOutputCollector> outputCollectors;
    private RotatingMap<Long, TupleInfo> pending;
    private long threadId = 0L;
    private final RateCounter skippedMaxSpoutMs;
    private final RateCounter skippedInactiveMs;
    private final RateCounter skippedBackpressureMs;

    public SpoutExecutor(WorkerState workerData, List<Long> executorId, Map<String, String> credentials) {
        super(workerData, executorId, credentials, "spout");
        this.spoutWaitStrategy.prepare(this.topoConf, IWaitStrategy.WaitSituation.SPOUT_WAIT);
        this.backPressureWaitStrategy = (IWaitStrategy)ReflectionUtils.newInstance((String)this.topoConf.get("topology.backpressure.wait.strategy"));
        this.backPressureWaitStrategy.prepare(this.topoConf, IWaitStrategy.WaitSituation.BACK_PRESSURE_WAIT);
        this.lastActive = new AtomicBoolean(false);
        this.hasAckers = StormCommon.hasAckers(this.topoConf);
        this.emittedCount = new MutableLong(0L);
        this.emptyEmitStreak = new MutableLong(0L);
        this.stats = new SpoutExecutorStats(ConfigUtils.samplingRate(this.getTopoConf()), ObjectReader.getInt(this.getTopoConf().get("num.stat.buckets")));
        this.skippedMaxSpoutMs = workerData.getMetricRegistry().rateCounter("__skipped-max-spout-ms", this.componentId, (Integer)this.taskIds.get(0));
        this.skippedInactiveMs = workerData.getMetricRegistry().rateCounter("__skipped-inactive-ms", this.componentId, (Integer)this.taskIds.get(0));
        this.skippedBackpressureMs = workerData.getMetricRegistry().rateCounter("__skipped-backpressure-ms", this.componentId, (Integer)this.taskIds.get(0));
    }

    @Override
    public SpoutExecutorStats getStats() {
        return this.stats;
    }

    public void init(final ArrayList<Task> idToTask, final int idToTaskBase) throws InterruptedException {
        this.threadId = Thread.currentThread().getId();
        this.executorTransfer.initLocalRecvQueues();
        this.workerReady.await();
        while (!this.stormActive.get()) {
            Utils.sleepNoSimulation(100L);
        }
        LOG.info("Opening spout {}:{}", (Object)this.componentId, (Object)this.taskIds);
        this.idToTask = idToTask;
        this.maxSpoutPending = ObjectReader.getInt(this.topoConf.get("topology.max.spout.pending"), 0) * idToTask.size();
        this.spouts = new ArrayList<ISpout>();
        for (Task task : idToTask) {
            if (task == null) continue;
            this.spouts.add((ISpout)task.getTaskObject());
        }
        this.pending = new RotatingMap<Long, TupleInfo>(2, new RotatingMap.ExpiredCallback<Long, TupleInfo>(){

            @Override
            public void expire(Long key, TupleInfo tupleInfo) {
                Long timeDelta = null;
                if (tupleInfo.getTimestamp() != 0L) {
                    timeDelta = Time.deltaMs(tupleInfo.getTimestamp());
                }
                SpoutExecutor.this.failSpoutMsg(SpoutExecutor.this, (Task)idToTask.get(tupleInfo.getTaskId() - idToTaskBase), timeDelta, tupleInfo, "TIMEOUT");
            }
        });
        this.outputCollectors = new ArrayList<SpoutOutputCollector>();
        for (int i = 0; i < idToTask.size(); ++i) {
            Task taskData = idToTask.get(i);
            if (taskData == null) continue;
            ISpout spoutObject = (ISpout)taskData.getTaskObject();
            this.spoutOutputCollector = new SpoutOutputCollectorImpl(spoutObject, this, taskData, this.emittedCount, this.hasAckers, this.rand, this.hasEventLoggers, this.isDebug, this.pending);
            SpoutOutputCollector outputCollector = new SpoutOutputCollector(this.spoutOutputCollector);
            this.outputCollectors.add(outputCollector);
            if (spoutObject instanceof ICredentialsListener) {
                ((ICredentialsListener)((Object)spoutObject)).setCredentials(this.credentials);
            }
            spoutObject.open(this.topoConf, taskData.getUserContext(), outputCollector);
        }
        this.openOrPrepareWasCalled.set(true);
        LOG.info("Opened spout {}:{}", (Object)this.componentId, (Object)this.taskIds);
        this.setupTicks(true);
        this.setupMetrics();
    }

    public Callable<Long> call() throws Exception {
        this.init(this.idToTask, this.idToTaskBase);
        return new Callable<Long>(){
            final int recvqCheckSkipCountMax;
            int recvqCheckSkips;
            int swIdleCount;
            int bpIdleCount;
            int rmspCount;
            {
                this.recvqCheckSkipCountMax = SpoutExecutor.this.getSpoutRecvqCheckSkipCount();
                this.recvqCheckSkips = 0;
                this.swIdleCount = 0;
                this.bpIdleCount = 0;
                this.rmspCount = 0;
            }

            @Override
            public Long call() throws Exception {
                SpoutExecutor.this.updateExecCredsIfRequired();
                int receiveCount = 0;
                if (this.recvqCheckSkips++ == this.recvqCheckSkipCountMax) {
                    receiveCount = SpoutExecutor.this.receiveQueue.consume(SpoutExecutor.this);
                    this.recvqCheckSkips = 0;
                }
                long currCount = SpoutExecutor.this.emittedCount.get();
                boolean reachedMaxSpoutPending = SpoutExecutor.this.maxSpoutPending != 0 && SpoutExecutor.this.pending.size() >= SpoutExecutor.this.maxSpoutPending;
                boolean isActive = SpoutExecutor.this.stormActive.get();
                if (!isActive) {
                    SpoutExecutor.this.inactiveExecute();
                    return 0L;
                }
                if (!SpoutExecutor.this.lastActive.get()) {
                    SpoutExecutor.this.lastActive.set(true);
                    SpoutExecutor.this.activateSpouts();
                }
                boolean pendingEmitsIsEmpty = this.tryFlushPendingEmits();
                boolean noEmits = true;
                long emptyStretch = 0L;
                if (!reachedMaxSpoutPending && pendingEmitsIsEmpty) {
                    for (int j = 0; j < SpoutExecutor.this.spouts.size(); ++j) {
                        SpoutExecutor.this.spouts.get(j).nextTuple();
                    }
                    boolean bl = noEmits = currCount == SpoutExecutor.this.emittedCount.get();
                    if (noEmits) {
                        SpoutExecutor.this.emptyEmitStreak.increment();
                    } else {
                        emptyStretch = SpoutExecutor.this.emptyEmitStreak.get();
                        SpoutExecutor.this.emptyEmitStreak.set(0L);
                    }
                }
                if (reachedMaxSpoutPending) {
                    if (this.rmspCount == 0) {
                        LOG.debug("Reached max spout pending");
                    }
                    ++this.rmspCount;
                } else {
                    if (this.rmspCount > 0) {
                        LOG.debug("Ended max spout pending stretch of {} iterations", (Object)this.rmspCount);
                    }
                    this.rmspCount = 0;
                }
                if (receiveCount > 1) {
                    return 0L;
                }
                if (!SpoutExecutor.this.pendingEmits.isEmpty()) {
                    this.backPressureWaitStrategy();
                    return 0L;
                }
                this.bpIdleCount = 0;
                if (noEmits) {
                    this.spoutWaitStrategy(reachedMaxSpoutPending, emptyStretch);
                    return 0L;
                }
                this.swIdleCount = 0;
                return 0L;
            }

            private void backPressureWaitStrategy() throws InterruptedException {
                long start = Time.currentTimeMillis();
                if (this.bpIdleCount == 0) {
                    LOG.debug("Experiencing Back Pressure from downstream components. Entering BackPressure Wait.");
                }
                this.bpIdleCount = SpoutExecutor.this.backPressureWaitStrategy.idle(this.bpIdleCount);
                SpoutExecutor.this.skippedBackpressureMs.inc(Time.currentTimeMillis() - start);
            }

            private void spoutWaitStrategy(boolean reachedMaxSpoutPending, long emptyStretch) throws InterruptedException {
                SpoutExecutor.this.emptyEmitStreak.increment();
                long start = Time.currentTimeMillis();
                this.swIdleCount = SpoutExecutor.this.spoutWaitStrategy.idle(this.swIdleCount);
                if (reachedMaxSpoutPending) {
                    SpoutExecutor.this.skippedMaxSpoutMs.inc(Time.currentTimeMillis() - start);
                } else if (emptyStretch > 0L) {
                    LOG.debug("Ending Spout Wait Stretch of {}", (Object)emptyStretch);
                }
            }

            private boolean tryFlushPendingEmits() {
                AddressedTuple t = (AddressedTuple)SpoutExecutor.this.pendingEmits.peek();
                while (t != null) {
                    if (!SpoutExecutor.this.executorTransfer.tryTransfer(t, null)) {
                        return false;
                    }
                    SpoutExecutor.this.pendingEmits.poll();
                    t = (AddressedTuple)SpoutExecutor.this.pendingEmits.peek();
                }
                return true;
            }
        };
    }

    private void activateSpouts() {
        LOG.info("Activating spout {}:{}", (Object)this.componentId, (Object)this.taskIds);
        for (ISpout spout : this.spouts) {
            spout.activate();
        }
    }

    private void deactivateSpouts() {
        LOG.info("Deactivating spout {}:{}", (Object)this.componentId, (Object)this.taskIds);
        for (ISpout spout : this.spouts) {
            spout.deactivate();
        }
    }

    private void inactiveExecute() throws InterruptedException {
        if (this.lastActive.get()) {
            this.lastActive.set(false);
            this.deactivateSpouts();
        }
        long start = Time.currentTimeMillis();
        Time.sleep(100L);
        this.skippedInactiveMs.inc(Time.currentTimeMillis() - start);
    }

    @Override
    public void tupleActionFn(int taskId, TupleImpl tuple) throws Exception {
        String streamId = tuple.getSourceStreamId();
        if ("__flush".equals(streamId)) {
            this.spoutOutputCollector.flush();
        } else if (streamId.equals("__tick")) {
            this.pending.rotate();
        } else if (streamId.equals("__metrics_tick")) {
            this.metricsTick((Task)this.idToTask.get(taskId - this.idToTaskBase), tuple);
        } else if (streamId.equals("__ack_reset_timeout")) {
            Long id = (Long)tuple.getValue(0);
            TupleInfo pendingForId = this.pending.get(id);
            if (pendingForId != null) {
                this.pending.put(id, pendingForId);
            }
        } else {
            Long id = (Long)tuple.getValue(0);
            Long timeDeltaMs = (Long)tuple.getValue(1);
            TupleInfo tupleInfo = this.pending.remove(id);
            if (tupleInfo != null && tupleInfo.getMessageId() != null) {
                long startTimeMs;
                if (taskId != tupleInfo.getTaskId()) {
                    throw new RuntimeException("Fatal error, mismatched task ids: " + taskId + " " + tupleInfo.getTaskId());
                }
                Long timeDelta = null;
                if (this.hasAckers && (startTimeMs = tupleInfo.getTimestamp()) != 0L) {
                    timeDelta = timeDeltaMs;
                }
                if (streamId.equals("__ack_ack")) {
                    this.ackSpoutMsg(this, (Task)this.idToTask.get(taskId - this.idToTaskBase), timeDelta, tupleInfo);
                } else if (streamId.equals("__ack_fail")) {
                    this.failSpoutMsg(this, (Task)this.idToTask.get(taskId - this.idToTaskBase), timeDelta, tupleInfo, "FAIL-STREAM");
                }
            }
        }
    }

    public void ackSpoutMsg(SpoutExecutor executor, Task taskData, Long timeDelta, TupleInfo tupleInfo) {
        try {
            ISpout spout = (ISpout)taskData.getTaskObject();
            int taskId = taskData.getTaskId();
            if (executor.getIsDebug().booleanValue()) {
                LOG.info("SPOUT Acking message {} {}", (Object)tupleInfo.getRootId(), tupleInfo.getMessageId());
            }
            spout.ack(tupleInfo.getMessageId());
            if (!taskData.getUserContext().getHooks().isEmpty()) {
                new SpoutAckInfo(tupleInfo.getMessageId(), taskId, timeDelta).applyOn(taskData.getUserContext());
            }
            if (this.hasAckers && timeDelta != null) {
                executor.getStats().spoutAckedTuple(tupleInfo.getStream(), timeDelta);
                taskData.getTaskMetrics().spoutAckedTuple(tupleInfo.getStream(), timeDelta);
            }
        }
        catch (Exception e) {
            throw Utils.wrapInRuntime(e);
        }
    }

    public void failSpoutMsg(SpoutExecutor executor, Task taskData, Long timeDelta, TupleInfo tupleInfo, String reason) {
        try {
            ISpout spout = (ISpout)taskData.getTaskObject();
            int taskId = taskData.getTaskId();
            if (executor.getIsDebug().booleanValue()) {
                LOG.info("SPOUT Failing {} : {} REASON: {}", new Object[]{tupleInfo.getRootId(), tupleInfo, reason});
            }
            spout.fail(tupleInfo.getMessageId());
            new SpoutFailInfo(tupleInfo.getMessageId(), taskId, timeDelta).applyOn(taskData.getUserContext());
            if (timeDelta != null) {
                executor.getStats().spoutFailedTuple(tupleInfo.getStream());
                taskData.getTaskMetrics().spoutFailedTuple(tupleInfo.getStream());
            }
        }
        catch (Exception e) {
            throw Utils.wrapInRuntime(e);
        }
    }

    public int getSpoutRecvqCheckSkipCount() {
        if (this.ackingEnabled) {
            return 0;
        }
        return ObjectReader.getInt(this.conf.get("topology.spout.recvq.skips"), 0);
    }

    public long getThreadId() {
        return this.threadId;
    }
}

