/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.generated.Nimbus;
import org.apache.storm.generated.NimbusSummary;
import org.apache.storm.security.auth.ReqContext;
import org.apache.storm.security.auth.ThriftClient;
import org.apache.storm.security.auth.ThriftConnectionType;
import org.apache.storm.thrift.transport.TTransportException;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.NimbusLeaderNotFoundException;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NimbusClient
extends ThriftClient {
    private static final Logger LOG = LoggerFactory.getLogger(NimbusClient.class);
    private static volatile Nimbus.Iface _localOverrideClient = null;
    private static String oldLeader = "";
    public final boolean isLocal;
    private final Nimbus.Iface client;

    @Deprecated
    public NimbusClient(Map<String, Object> conf, String host, int port) throws TTransportException {
        this(conf, host, port, null, null);
    }

    public NimbusClient(Map<String, Object> conf, String host, int port, Integer timeout) throws TTransportException {
        super(conf, ThriftConnectionType.NIMBUS, host, port, timeout, null);
        this.client = new Nimbus.Client(this.protocol);
        this.isLocal = false;
    }

    public NimbusClient(Map<String, Object> conf, String host, Integer port, Integer timeout, String asUser) throws TTransportException {
        super(conf, ThriftConnectionType.NIMBUS, host, port, timeout, asUser);
        this.client = new Nimbus.Client(this.protocol);
        this.isLocal = false;
    }

    public NimbusClient(Map<String, Object> conf, String host) throws TTransportException {
        super(conf, ThriftConnectionType.NIMBUS, host, null, null, null);
        this.client = new Nimbus.Client(this.protocol);
        this.isLocal = false;
    }

    private NimbusClient(Nimbus.Iface client) {
        super(new HashMap<String, Object>(), ThriftConnectionType.LOCAL_FAKE, "localhost", null, null, null);
        this.client = client;
        this.isLocal = true;
    }

    public static boolean isLocalOverride() {
        return _localOverrideClient != null;
    }

    public static void withConfiguredClient(WithNimbus cb) throws Exception {
        NimbusClient.withConfiguredClient(cb, ConfigUtils.readStormConfig());
    }

    public static void withConfiguredClient(WithNimbus cb, Map<String, Object> conf) throws Exception {
        try (NimbusClient client = NimbusClient.getConfiguredClientAs(conf, null);){
            cb.run(client.getClient());
        }
    }

    public static NimbusClient getConfiguredClient(Map<String, Object> conf) {
        return NimbusClient.getConfiguredClientAs(conf, null);
    }

    public static NimbusClient getConfiguredClient(Map<String, Object> conf, Integer timeout) {
        return NimbusClient.getConfiguredClientAs(conf, null, timeout);
    }

    private static synchronized boolean shouldLogLeader(String leader) {
        assert (leader != null);
        if (LOG.isDebugEnabled()) {
            return true;
        }
        if (oldLeader.equals(leader)) {
            return false;
        }
        oldLeader = leader;
        return true;
    }

    public static NimbusClient getConfiguredClientAs(Map<String, Object> conf, String asUser) {
        return NimbusClient.getConfiguredClientAs(conf, asUser, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NimbusClient getConfiguredClientAs(Map<String, Object> conf, String asUser, Integer timeout) {
        Nimbus.Iface override = _localOverrideClient;
        if (override != null) {
            return new NimbusClient(override);
        }
        Map<String, Object> fullConf = Utils.readStormConfig();
        fullConf.putAll(Utils.readCommandLineOpts());
        fullConf.putAll(conf);
        conf = fullConf;
        if (conf.containsKey("storm.doAsUser")) {
            if (asUser != null && !asUser.isEmpty()) {
                LOG.warn("You have specified a doAsUser as param {} and a doAsParam as config, config will take precedence.", (Object)asUser, conf.get("storm.doAsUser"));
            }
            asUser = (String)conf.get("storm.doAsUser");
        }
        if (asUser == null || asUser.isEmpty()) {
            ReqContext context = ReqContext.context();
            Principal principal = context.principal();
            asUser = principal == null ? null : principal.getName();
            LOG.debug("Will impersonate {} based off of request context.", (Object)asUser);
        }
        List seeds = (List)conf.get("nimbus.seeds");
        for (String host : seeds) {
            int port = Integer.parseInt(conf.get("nimbus.thrift.port").toString());
            ThriftClient client = null;
            try {
                client = new NimbusClient(conf, host, port, timeout, asUser);
                NimbusSummary nimbusSummary = ((NimbusClient)client).getClient().getLeader();
                if (nimbusSummary != null) {
                    String leaderNimbus = nimbusSummary.get_host() + ":" + nimbusSummary.get_port();
                    if (NimbusClient.shouldLogLeader(leaderNimbus)) {
                        LOG.info("Found leader nimbus : {}", (Object)leaderNimbus);
                    }
                    if (nimbusSummary.get_host().equals(host) && nimbusSummary.get_port() == port) {
                        ThriftClient ret = client;
                        client = null;
                        ThriftClient thriftClient = ret;
                        return thriftClient;
                    }
                    NimbusClient ret = new NimbusClient(conf, nimbusSummary.get_host(), nimbusSummary.get_port(), timeout, asUser);
                    return ret;
                }
            }
            catch (Exception e) {
                LOG.warn("Ignoring exception while trying to get leader nimbus info from " + host + ". will retry with a different seed host.", (Throwable)e);
                continue;
            }
            finally {
                if (client == null) continue;
                client.close();
                continue;
            }
            throw new NimbusLeaderNotFoundException("Could not find a nimbus leader, please try again after some time.");
        }
        throw new NimbusLeaderNotFoundException("Could not find leader nimbus from seed hosts " + seeds + ". Did you specify a valid list of nimbus hosts for config nimbus.seeds?");
    }

    public Nimbus.Iface getClient() {
        return this.client;
    }

    public static final class LocalOverride
    implements AutoCloseable {
        public LocalOverride(Nimbus.Iface client) {
            _localOverrideClient = client;
        }

        @Override
        public void close() throws Exception {
            _localOverrideClient = null;
        }
    }

    public static interface WithNimbus {
        public void run(Nimbus.Iface var1) throws Exception;
    }
}

