/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.generated;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.storm.generated.DebugOptions;
import org.apache.storm.generated.TopologyActionOptions;
import org.apache.storm.generated.TopologyStatus;
import org.apache.storm.thrift.EncodingUtils;
import org.apache.storm.thrift.TBase;
import org.apache.storm.thrift.TBaseHelper;
import org.apache.storm.thrift.TException;
import org.apache.storm.thrift.TFieldIdEnum;
import org.apache.storm.thrift.annotation.Nullable;
import org.apache.storm.thrift.meta_data.EnumMetaData;
import org.apache.storm.thrift.meta_data.FieldMetaData;
import org.apache.storm.thrift.meta_data.FieldValueMetaData;
import org.apache.storm.thrift.meta_data.MapMetaData;
import org.apache.storm.thrift.meta_data.StructMetaData;
import org.apache.storm.thrift.protocol.TCompactProtocol;
import org.apache.storm.thrift.protocol.TField;
import org.apache.storm.thrift.protocol.TMap;
import org.apache.storm.thrift.protocol.TProtocol;
import org.apache.storm.thrift.protocol.TProtocolException;
import org.apache.storm.thrift.protocol.TProtocolUtil;
import org.apache.storm.thrift.protocol.TStruct;
import org.apache.storm.thrift.protocol.TTupleProtocol;
import org.apache.storm.thrift.scheme.IScheme;
import org.apache.storm.thrift.scheme.SchemeFactory;
import org.apache.storm.thrift.scheme.StandardScheme;
import org.apache.storm.thrift.scheme.TupleScheme;
import org.apache.storm.thrift.transport.TIOStreamTransport;
import org.apache.storm.thrift.transport.TTransport;

public class StormBase
implements TBase<StormBase, _Fields>,
Serializable,
Cloneable,
Comparable<StormBase> {
    private static final TStruct STRUCT_DESC = new TStruct("StormBase");
    private static final TField NAME_FIELD_DESC = new TField("name", 11, 1);
    private static final TField STATUS_FIELD_DESC = new TField("status", 8, 2);
    private static final TField NUM_WORKERS_FIELD_DESC = new TField("num_workers", 8, 3);
    private static final TField COMPONENT_EXECUTORS_FIELD_DESC = new TField("component_executors", 13, 4);
    private static final TField LAUNCH_TIME_SECS_FIELD_DESC = new TField("launch_time_secs", 8, 5);
    private static final TField OWNER_FIELD_DESC = new TField("owner", 11, 6);
    private static final TField TOPOLOGY_ACTION_OPTIONS_FIELD_DESC = new TField("topology_action_options", 12, 7);
    private static final TField PREV_STATUS_FIELD_DESC = new TField("prev_status", 8, 8);
    private static final TField COMPONENT_DEBUG_FIELD_DESC = new TField("component_debug", 13, 9);
    private static final TField PRINCIPAL_FIELD_DESC = new TField("principal", 11, 10);
    private static final TField TOPOLOGY_VERSION_FIELD_DESC = new TField("topology_version", 11, 11);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new StormBaseStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new StormBaseTupleSchemeFactory();
    @Nullable
    private String name;
    @Nullable
    private TopologyStatus status;
    private int num_workers;
    @Nullable
    private Map<String, Integer> component_executors;
    private int launch_time_secs;
    @Nullable
    private String owner;
    @Nullable
    private TopologyActionOptions topology_action_options;
    @Nullable
    private TopologyStatus prev_status;
    @Nullable
    private Map<String, DebugOptions> component_debug;
    @Nullable
    private String principal;
    @Nullable
    private String topology_version;
    private static final int __NUM_WORKERS_ISSET_ID = 0;
    private static final int __LAUNCH_TIME_SECS_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.COMPONENT_EXECUTORS, _Fields.LAUNCH_TIME_SECS, _Fields.OWNER, _Fields.TOPOLOGY_ACTION_OPTIONS, _Fields.PREV_STATUS, _Fields.COMPONENT_DEBUG, _Fields.PRINCIPAL, _Fields.TOPOLOGY_VERSION};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public StormBase() {
    }

    public StormBase(String name, TopologyStatus status, int num_workers) {
        this();
        this.name = name;
        this.status = status;
        this.num_workers = num_workers;
        this.set_num_workers_isSet(true);
    }

    public StormBase(StormBase other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.is_set_name()) {
            this.name = other.name;
        }
        if (other.is_set_status()) {
            this.status = other.status;
        }
        this.num_workers = other.num_workers;
        if (other.is_set_component_executors()) {
            HashMap<String, Integer> __this__component_executors = new HashMap<String, Integer>(other.component_executors);
            this.component_executors = __this__component_executors;
        }
        this.launch_time_secs = other.launch_time_secs;
        if (other.is_set_owner()) {
            this.owner = other.owner;
        }
        if (other.is_set_topology_action_options()) {
            this.topology_action_options = new TopologyActionOptions(other.topology_action_options);
        }
        if (other.is_set_prev_status()) {
            this.prev_status = other.prev_status;
        }
        if (other.is_set_component_debug()) {
            HashMap<String, DebugOptions> __this__component_debug = new HashMap<String, DebugOptions>(other.component_debug.size());
            for (Map.Entry<String, DebugOptions> other_element : other.component_debug.entrySet()) {
                String other_element_key = other_element.getKey();
                DebugOptions other_element_value = other_element.getValue();
                String __this__component_debug_copy_key = other_element_key;
                DebugOptions __this__component_debug_copy_value = new DebugOptions(other_element_value);
                __this__component_debug.put(__this__component_debug_copy_key, __this__component_debug_copy_value);
            }
            this.component_debug = __this__component_debug;
        }
        if (other.is_set_principal()) {
            this.principal = other.principal;
        }
        if (other.is_set_topology_version()) {
            this.topology_version = other.topology_version;
        }
    }

    public StormBase deepCopy() {
        return new StormBase(this);
    }

    public void clear() {
        this.name = null;
        this.status = null;
        this.set_num_workers_isSet(false);
        this.num_workers = 0;
        this.component_executors = null;
        this.set_launch_time_secs_isSet(false);
        this.launch_time_secs = 0;
        this.owner = null;
        this.topology_action_options = null;
        this.prev_status = null;
        this.component_debug = null;
        this.principal = null;
        this.topology_version = null;
    }

    @Nullable
    public String get_name() {
        return this.name;
    }

    public void set_name(@Nullable String name) {
        this.name = name;
    }

    public void unset_name() {
        this.name = null;
    }

    public boolean is_set_name() {
        return this.name != null;
    }

    public void set_name_isSet(boolean value) {
        if (!value) {
            this.name = null;
        }
    }

    @Nullable
    public TopologyStatus get_status() {
        return this.status;
    }

    public void set_status(@Nullable TopologyStatus status) {
        this.status = status;
    }

    public void unset_status() {
        this.status = null;
    }

    public boolean is_set_status() {
        return this.status != null;
    }

    public void set_status_isSet(boolean value) {
        if (!value) {
            this.status = null;
        }
    }

    public int get_num_workers() {
        return this.num_workers;
    }

    public void set_num_workers(int num_workers) {
        this.num_workers = num_workers;
        this.set_num_workers_isSet(true);
    }

    public void unset_num_workers() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean is_set_num_workers() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void set_num_workers_isSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public int get_component_executors_size() {
        return this.component_executors == null ? 0 : this.component_executors.size();
    }

    public void put_to_component_executors(String key, int val) {
        if (this.component_executors == null) {
            this.component_executors = new HashMap<String, Integer>();
        }
        this.component_executors.put(key, val);
    }

    @Nullable
    public Map<String, Integer> get_component_executors() {
        return this.component_executors;
    }

    public void set_component_executors(@Nullable Map<String, Integer> component_executors) {
        this.component_executors = component_executors;
    }

    public void unset_component_executors() {
        this.component_executors = null;
    }

    public boolean is_set_component_executors() {
        return this.component_executors != null;
    }

    public void set_component_executors_isSet(boolean value) {
        if (!value) {
            this.component_executors = null;
        }
    }

    public int get_launch_time_secs() {
        return this.launch_time_secs;
    }

    public void set_launch_time_secs(int launch_time_secs) {
        this.launch_time_secs = launch_time_secs;
        this.set_launch_time_secs_isSet(true);
    }

    public void unset_launch_time_secs() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean is_set_launch_time_secs() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void set_launch_time_secs_isSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    @Nullable
    public String get_owner() {
        return this.owner;
    }

    public void set_owner(@Nullable String owner) {
        this.owner = owner;
    }

    public void unset_owner() {
        this.owner = null;
    }

    public boolean is_set_owner() {
        return this.owner != null;
    }

    public void set_owner_isSet(boolean value) {
        if (!value) {
            this.owner = null;
        }
    }

    @Nullable
    public TopologyActionOptions get_topology_action_options() {
        return this.topology_action_options;
    }

    public void set_topology_action_options(@Nullable TopologyActionOptions topology_action_options) {
        this.topology_action_options = topology_action_options;
    }

    public void unset_topology_action_options() {
        this.topology_action_options = null;
    }

    public boolean is_set_topology_action_options() {
        return this.topology_action_options != null;
    }

    public void set_topology_action_options_isSet(boolean value) {
        if (!value) {
            this.topology_action_options = null;
        }
    }

    @Nullable
    public TopologyStatus get_prev_status() {
        return this.prev_status;
    }

    public void set_prev_status(@Nullable TopologyStatus prev_status) {
        this.prev_status = prev_status;
    }

    public void unset_prev_status() {
        this.prev_status = null;
    }

    public boolean is_set_prev_status() {
        return this.prev_status != null;
    }

    public void set_prev_status_isSet(boolean value) {
        if (!value) {
            this.prev_status = null;
        }
    }

    public int get_component_debug_size() {
        return this.component_debug == null ? 0 : this.component_debug.size();
    }

    public void put_to_component_debug(String key, DebugOptions val) {
        if (this.component_debug == null) {
            this.component_debug = new HashMap<String, DebugOptions>();
        }
        this.component_debug.put(key, val);
    }

    @Nullable
    public Map<String, DebugOptions> get_component_debug() {
        return this.component_debug;
    }

    public void set_component_debug(@Nullable Map<String, DebugOptions> component_debug) {
        this.component_debug = component_debug;
    }

    public void unset_component_debug() {
        this.component_debug = null;
    }

    public boolean is_set_component_debug() {
        return this.component_debug != null;
    }

    public void set_component_debug_isSet(boolean value) {
        if (!value) {
            this.component_debug = null;
        }
    }

    @Nullable
    public String get_principal() {
        return this.principal;
    }

    public void set_principal(@Nullable String principal) {
        this.principal = principal;
    }

    public void unset_principal() {
        this.principal = null;
    }

    public boolean is_set_principal() {
        return this.principal != null;
    }

    public void set_principal_isSet(boolean value) {
        if (!value) {
            this.principal = null;
        }
    }

    @Nullable
    public String get_topology_version() {
        return this.topology_version;
    }

    public void set_topology_version(@Nullable String topology_version) {
        this.topology_version = topology_version;
    }

    public void unset_topology_version() {
        this.topology_version = null;
    }

    public boolean is_set_topology_version() {
        return this.topology_version != null;
    }

    public void set_topology_version_isSet(boolean value) {
        if (!value) {
            this.topology_version = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case NAME: {
                if (value == null) {
                    this.unset_name();
                    break;
                }
                this.set_name((String)value);
                break;
            }
            case STATUS: {
                if (value == null) {
                    this.unset_status();
                    break;
                }
                this.set_status((TopologyStatus)((Object)value));
                break;
            }
            case NUM_WORKERS: {
                if (value == null) {
                    this.unset_num_workers();
                    break;
                }
                this.set_num_workers((Integer)value);
                break;
            }
            case COMPONENT_EXECUTORS: {
                if (value == null) {
                    this.unset_component_executors();
                    break;
                }
                this.set_component_executors((Map)value);
                break;
            }
            case LAUNCH_TIME_SECS: {
                if (value == null) {
                    this.unset_launch_time_secs();
                    break;
                }
                this.set_launch_time_secs((Integer)value);
                break;
            }
            case OWNER: {
                if (value == null) {
                    this.unset_owner();
                    break;
                }
                this.set_owner((String)value);
                break;
            }
            case TOPOLOGY_ACTION_OPTIONS: {
                if (value == null) {
                    this.unset_topology_action_options();
                    break;
                }
                this.set_topology_action_options((TopologyActionOptions)((Object)value));
                break;
            }
            case PREV_STATUS: {
                if (value == null) {
                    this.unset_prev_status();
                    break;
                }
                this.set_prev_status((TopologyStatus)((Object)value));
                break;
            }
            case COMPONENT_DEBUG: {
                if (value == null) {
                    this.unset_component_debug();
                    break;
                }
                this.set_component_debug((Map)value);
                break;
            }
            case PRINCIPAL: {
                if (value == null) {
                    this.unset_principal();
                    break;
                }
                this.set_principal((String)value);
                break;
            }
            case TOPOLOGY_VERSION: {
                if (value == null) {
                    this.unset_topology_version();
                    break;
                }
                this.set_topology_version((String)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case NAME: {
                return this.get_name();
            }
            case STATUS: {
                return this.get_status();
            }
            case NUM_WORKERS: {
                return this.get_num_workers();
            }
            case COMPONENT_EXECUTORS: {
                return this.get_component_executors();
            }
            case LAUNCH_TIME_SECS: {
                return this.get_launch_time_secs();
            }
            case OWNER: {
                return this.get_owner();
            }
            case TOPOLOGY_ACTION_OPTIONS: {
                return this.get_topology_action_options();
            }
            case PREV_STATUS: {
                return this.get_prev_status();
            }
            case COMPONENT_DEBUG: {
                return this.get_component_debug();
            }
            case PRINCIPAL: {
                return this.get_principal();
            }
            case TOPOLOGY_VERSION: {
                return this.get_topology_version();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case NAME: {
                return this.is_set_name();
            }
            case STATUS: {
                return this.is_set_status();
            }
            case NUM_WORKERS: {
                return this.is_set_num_workers();
            }
            case COMPONENT_EXECUTORS: {
                return this.is_set_component_executors();
            }
            case LAUNCH_TIME_SECS: {
                return this.is_set_launch_time_secs();
            }
            case OWNER: {
                return this.is_set_owner();
            }
            case TOPOLOGY_ACTION_OPTIONS: {
                return this.is_set_topology_action_options();
            }
            case PREV_STATUS: {
                return this.is_set_prev_status();
            }
            case COMPONENT_DEBUG: {
                return this.is_set_component_debug();
            }
            case PRINCIPAL: {
                return this.is_set_principal();
            }
            case TOPOLOGY_VERSION: {
                return this.is_set_topology_version();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof StormBase) {
            return this.equals((StormBase)that);
        }
        return false;
    }

    public boolean equals(StormBase that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_name = this.is_set_name();
        boolean that_present_name = that.is_set_name();
        if (this_present_name || that_present_name) {
            if (!this_present_name || !that_present_name) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
        }
        boolean this_present_status = this.is_set_status();
        boolean that_present_status = that.is_set_status();
        if (this_present_status || that_present_status) {
            if (!this_present_status || !that_present_status) {
                return false;
            }
            if (!this.status.equals((Object)that.status)) {
                return false;
            }
        }
        boolean this_present_num_workers = true;
        boolean that_present_num_workers = true;
        if (this_present_num_workers || that_present_num_workers) {
            if (!this_present_num_workers || !that_present_num_workers) {
                return false;
            }
            if (this.num_workers != that.num_workers) {
                return false;
            }
        }
        boolean this_present_component_executors = this.is_set_component_executors();
        boolean that_present_component_executors = that.is_set_component_executors();
        if (this_present_component_executors || that_present_component_executors) {
            if (!this_present_component_executors || !that_present_component_executors) {
                return false;
            }
            if (!this.component_executors.equals(that.component_executors)) {
                return false;
            }
        }
        boolean this_present_launch_time_secs = this.is_set_launch_time_secs();
        boolean that_present_launch_time_secs = that.is_set_launch_time_secs();
        if (this_present_launch_time_secs || that_present_launch_time_secs) {
            if (!this_present_launch_time_secs || !that_present_launch_time_secs) {
                return false;
            }
            if (this.launch_time_secs != that.launch_time_secs) {
                return false;
            }
        }
        boolean this_present_owner = this.is_set_owner();
        boolean that_present_owner = that.is_set_owner();
        if (this_present_owner || that_present_owner) {
            if (!this_present_owner || !that_present_owner) {
                return false;
            }
            if (!this.owner.equals(that.owner)) {
                return false;
            }
        }
        boolean this_present_topology_action_options = this.is_set_topology_action_options();
        boolean that_present_topology_action_options = that.is_set_topology_action_options();
        if (this_present_topology_action_options || that_present_topology_action_options) {
            if (!this_present_topology_action_options || !that_present_topology_action_options) {
                return false;
            }
            if (!this.topology_action_options.equals(that.topology_action_options)) {
                return false;
            }
        }
        boolean this_present_prev_status = this.is_set_prev_status();
        boolean that_present_prev_status = that.is_set_prev_status();
        if (this_present_prev_status || that_present_prev_status) {
            if (!this_present_prev_status || !that_present_prev_status) {
                return false;
            }
            if (!this.prev_status.equals((Object)that.prev_status)) {
                return false;
            }
        }
        boolean this_present_component_debug = this.is_set_component_debug();
        boolean that_present_component_debug = that.is_set_component_debug();
        if (this_present_component_debug || that_present_component_debug) {
            if (!this_present_component_debug || !that_present_component_debug) {
                return false;
            }
            if (!this.component_debug.equals(that.component_debug)) {
                return false;
            }
        }
        boolean this_present_principal = this.is_set_principal();
        boolean that_present_principal = that.is_set_principal();
        if (this_present_principal || that_present_principal) {
            if (!this_present_principal || !that_present_principal) {
                return false;
            }
            if (!this.principal.equals(that.principal)) {
                return false;
            }
        }
        boolean this_present_topology_version = this.is_set_topology_version();
        boolean that_present_topology_version = that.is_set_topology_version();
        if (this_present_topology_version || that_present_topology_version) {
            if (!this_present_topology_version || !that_present_topology_version) {
                return false;
            }
            if (!this.topology_version.equals(that.topology_version)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.is_set_name() ? 131071 : 524287);
        if (this.is_set_name()) {
            hashCode = hashCode * 8191 + this.name.hashCode();
        }
        hashCode = hashCode * 8191 + (this.is_set_status() ? 131071 : 524287);
        if (this.is_set_status()) {
            hashCode = hashCode * 8191 + this.status.getValue();
        }
        hashCode = hashCode * 8191 + this.num_workers;
        hashCode = hashCode * 8191 + (this.is_set_component_executors() ? 131071 : 524287);
        if (this.is_set_component_executors()) {
            hashCode = hashCode * 8191 + this.component_executors.hashCode();
        }
        hashCode = hashCode * 8191 + (this.is_set_launch_time_secs() ? 131071 : 524287);
        if (this.is_set_launch_time_secs()) {
            hashCode = hashCode * 8191 + this.launch_time_secs;
        }
        hashCode = hashCode * 8191 + (this.is_set_owner() ? 131071 : 524287);
        if (this.is_set_owner()) {
            hashCode = hashCode * 8191 + this.owner.hashCode();
        }
        hashCode = hashCode * 8191 + (this.is_set_topology_action_options() ? 131071 : 524287);
        if (this.is_set_topology_action_options()) {
            hashCode = hashCode * 8191 + this.topology_action_options.hashCode();
        }
        hashCode = hashCode * 8191 + (this.is_set_prev_status() ? 131071 : 524287);
        if (this.is_set_prev_status()) {
            hashCode = hashCode * 8191 + this.prev_status.getValue();
        }
        hashCode = hashCode * 8191 + (this.is_set_component_debug() ? 131071 : 524287);
        if (this.is_set_component_debug()) {
            hashCode = hashCode * 8191 + this.component_debug.hashCode();
        }
        hashCode = hashCode * 8191 + (this.is_set_principal() ? 131071 : 524287);
        if (this.is_set_principal()) {
            hashCode = hashCode * 8191 + this.principal.hashCode();
        }
        hashCode = hashCode * 8191 + (this.is_set_topology_version() ? 131071 : 524287);
        if (this.is_set_topology_version()) {
            hashCode = hashCode * 8191 + this.topology_version.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(StormBase other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.is_set_name(), other.is_set_name());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.is_set_name() && (lastComparison = TBaseHelper.compareTo((String)this.name, (String)other.name)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.is_set_status(), other.is_set_status());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.is_set_status() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.status), (Comparable)((Object)other.status))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.is_set_num_workers(), other.is_set_num_workers());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.is_set_num_workers() && (lastComparison = TBaseHelper.compareTo((int)this.num_workers, (int)other.num_workers)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.is_set_component_executors(), other.is_set_component_executors());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.is_set_component_executors() && (lastComparison = TBaseHelper.compareTo(this.component_executors, other.component_executors)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.is_set_launch_time_secs(), other.is_set_launch_time_secs());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.is_set_launch_time_secs() && (lastComparison = TBaseHelper.compareTo((int)this.launch_time_secs, (int)other.launch_time_secs)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.is_set_owner(), other.is_set_owner());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.is_set_owner() && (lastComparison = TBaseHelper.compareTo((String)this.owner, (String)other.owner)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.is_set_topology_action_options(), other.is_set_topology_action_options());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.is_set_topology_action_options() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.topology_action_options), (Comparable)((Object)other.topology_action_options))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.is_set_prev_status(), other.is_set_prev_status());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.is_set_prev_status() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.prev_status), (Comparable)((Object)other.prev_status))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.is_set_component_debug(), other.is_set_component_debug());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.is_set_component_debug() && (lastComparison = TBaseHelper.compareTo(this.component_debug, other.component_debug)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.is_set_principal(), other.is_set_principal());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.is_set_principal() && (lastComparison = TBaseHelper.compareTo((String)this.principal, (String)other.principal)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.is_set_topology_version(), other.is_set_topology_version());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.is_set_topology_version() && (lastComparison = TBaseHelper.compareTo((String)this.topology_version, (String)other.topology_version)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        StormBase.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        StormBase.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StormBase(");
        boolean first = true;
        sb.append("name:");
        if (this.name == null) {
            sb.append("null");
        } else {
            sb.append(this.name);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("status:");
        if (this.status == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.status);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("num_workers:");
        sb.append(this.num_workers);
        first = false;
        if (this.is_set_component_executors()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("component_executors:");
            if (this.component_executors == null) {
                sb.append("null");
            } else {
                sb.append(this.component_executors);
            }
            first = false;
        }
        if (this.is_set_launch_time_secs()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("launch_time_secs:");
            sb.append(this.launch_time_secs);
            first = false;
        }
        if (this.is_set_owner()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("owner:");
            if (this.owner == null) {
                sb.append("null");
            } else {
                sb.append(this.owner);
            }
            first = false;
        }
        if (this.is_set_topology_action_options()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("topology_action_options:");
            if (this.topology_action_options == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.topology_action_options);
            }
            first = false;
        }
        if (this.is_set_prev_status()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("prev_status:");
            if (this.prev_status == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.prev_status);
            }
            first = false;
        }
        if (this.is_set_component_debug()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("component_debug:");
            if (this.component_debug == null) {
                sb.append("null");
            } else {
                sb.append(this.component_debug);
            }
            first = false;
        }
        if (this.is_set_principal()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("principal:");
            if (this.principal == null) {
                sb.append("null");
            } else {
                sb.append(this.principal);
            }
            first = false;
        }
        if (this.is_set_topology_version()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("topology_version:");
            if (this.topology_version == null) {
                sb.append("null");
            } else {
                sb.append(this.topology_version);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.is_set_name()) {
            throw new TProtocolException("Required field 'name' is unset! Struct:" + this.toString());
        }
        if (!this.is_set_status()) {
            throw new TProtocolException("Required field 'status' is unset! Struct:" + this.toString());
        }
        if (!this.is_set_num_workers()) {
            throw new TProtocolException("Required field 'num_workers' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.NAME, new FieldMetaData("name", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.STATUS, new FieldMetaData("status", 1, (FieldValueMetaData)new EnumMetaData(-1, TopologyStatus.class)));
        tmpMap.put(_Fields.NUM_WORKERS, new FieldMetaData("num_workers", 1, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.COMPONENT_EXECUTORS, new FieldMetaData("component_executors", 2, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(8))));
        tmpMap.put(_Fields.LAUNCH_TIME_SECS, new FieldMetaData("launch_time_secs", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.OWNER, new FieldMetaData("owner", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TOPOLOGY_ACTION_OPTIONS, new FieldMetaData("topology_action_options", 2, (FieldValueMetaData)new StructMetaData(12, TopologyActionOptions.class)));
        tmpMap.put(_Fields.PREV_STATUS, new FieldMetaData("prev_status", 2, (FieldValueMetaData)new EnumMetaData(-1, TopologyStatus.class)));
        tmpMap.put(_Fields.COMPONENT_DEBUG, new FieldMetaData("component_debug", 2, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), (FieldValueMetaData)new StructMetaData(12, DebugOptions.class))));
        tmpMap.put(_Fields.PRINCIPAL, new FieldMetaData("principal", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TOPOLOGY_VERSION, new FieldMetaData("topology_version", 2, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(StormBase.class, metaDataMap);
    }

    private static class StormBaseTupleScheme
    extends TupleScheme<StormBase> {
        private StormBaseTupleScheme() {
        }

        public void write(TProtocol prot, StormBase struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeString(struct.name);
            oprot.writeI32(struct.status.getValue());
            oprot.writeI32(struct.num_workers);
            BitSet optionals = new BitSet();
            if (struct.is_set_component_executors()) {
                optionals.set(0);
            }
            if (struct.is_set_launch_time_secs()) {
                optionals.set(1);
            }
            if (struct.is_set_owner()) {
                optionals.set(2);
            }
            if (struct.is_set_topology_action_options()) {
                optionals.set(3);
            }
            if (struct.is_set_prev_status()) {
                optionals.set(4);
            }
            if (struct.is_set_component_debug()) {
                optionals.set(5);
            }
            if (struct.is_set_principal()) {
                optionals.set(6);
            }
            if (struct.is_set_topology_version()) {
                optionals.set(7);
            }
            oprot.writeBitSet(optionals, 8);
            if (struct.is_set_component_executors()) {
                oprot.writeI32(struct.component_executors.size());
                for (Map.Entry<String, Integer> entry : struct.component_executors.entrySet()) {
                    oprot.writeString(entry.getKey());
                    oprot.writeI32(entry.getValue().intValue());
                }
            }
            if (struct.is_set_launch_time_secs()) {
                oprot.writeI32(struct.launch_time_secs);
            }
            if (struct.is_set_owner()) {
                oprot.writeString(struct.owner);
            }
            if (struct.is_set_topology_action_options()) {
                struct.topology_action_options.write((TProtocol)oprot);
            }
            if (struct.is_set_prev_status()) {
                oprot.writeI32(struct.prev_status.getValue());
            }
            if (struct.is_set_component_debug()) {
                oprot.writeI32(struct.component_debug.size());
                for (Map.Entry<String, Comparable<Integer>> entry : struct.component_debug.entrySet()) {
                    oprot.writeString(entry.getKey());
                    ((DebugOptions)entry.getValue()).write((TProtocol)oprot);
                }
            }
            if (struct.is_set_principal()) {
                oprot.writeString(struct.principal);
            }
            if (struct.is_set_topology_version()) {
                oprot.writeString(struct.topology_version);
            }
        }

        public void read(TProtocol prot, StormBase struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.name = iprot.readString();
            struct.set_name_isSet(true);
            struct.status = TopologyStatus.findByValue(iprot.readI32());
            struct.set_status_isSet(true);
            struct.num_workers = iprot.readI32();
            struct.set_num_workers_isSet(true);
            BitSet incoming = iprot.readBitSet(8);
            if (incoming.get(0)) {
                TMap _map814 = iprot.readMapBegin((byte)11, (byte)8);
                struct.component_executors = new HashMap<String, Integer>(2 * _map814.size);
                for (int _i817 = 0; _i817 < _map814.size; ++_i817) {
                    String _key815 = iprot.readString();
                    int _val816 = iprot.readI32();
                    struct.component_executors.put(_key815, _val816);
                }
                struct.set_component_executors_isSet(true);
            }
            if (incoming.get(1)) {
                struct.launch_time_secs = iprot.readI32();
                struct.set_launch_time_secs_isSet(true);
            }
            if (incoming.get(2)) {
                struct.owner = iprot.readString();
                struct.set_owner_isSet(true);
            }
            if (incoming.get(3)) {
                struct.topology_action_options = new TopologyActionOptions();
                struct.topology_action_options.read((TProtocol)iprot);
                struct.set_topology_action_options_isSet(true);
            }
            if (incoming.get(4)) {
                struct.prev_status = TopologyStatus.findByValue(iprot.readI32());
                struct.set_prev_status_isSet(true);
            }
            if (incoming.get(5)) {
                TMap _map818 = iprot.readMapBegin((byte)11, (byte)12);
                struct.component_debug = new HashMap<String, DebugOptions>(2 * _map818.size);
                for (int _i821 = 0; _i821 < _map818.size; ++_i821) {
                    String _key819 = iprot.readString();
                    DebugOptions _val820 = new DebugOptions();
                    _val820.read((TProtocol)iprot);
                    struct.component_debug.put(_key819, _val820);
                }
                struct.set_component_debug_isSet(true);
            }
            if (incoming.get(6)) {
                struct.principal = iprot.readString();
                struct.set_principal_isSet(true);
            }
            if (incoming.get(7)) {
                struct.topology_version = iprot.readString();
                struct.set_topology_version_isSet(true);
            }
        }
    }

    private static class StormBaseTupleSchemeFactory
    implements SchemeFactory {
        private StormBaseTupleSchemeFactory() {
        }

        public StormBaseTupleScheme getScheme() {
            return new StormBaseTupleScheme();
        }
    }

    private static class StormBaseStandardScheme
    extends StandardScheme<StormBase> {
        private StormBaseStandardScheme() {
        }

        public void read(TProtocol iprot, StormBase struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.name = iprot.readString();
                            struct.set_name_isSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 8) {
                            struct.status = TopologyStatus.findByValue(iprot.readI32());
                            struct.set_status_isSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 8) {
                            struct.num_workers = iprot.readI32();
                            struct.set_num_workers_isSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 13) {
                            TMap _map802 = iprot.readMapBegin();
                            struct.component_executors = new HashMap<String, Integer>(2 * _map802.size);
                            for (int _i805 = 0; _i805 < _map802.size; ++_i805) {
                                String _key803 = iprot.readString();
                                int _val804 = iprot.readI32();
                                struct.component_executors.put(_key803, _val804);
                            }
                            iprot.readMapEnd();
                            struct.set_component_executors_isSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 8) {
                            struct.launch_time_secs = iprot.readI32();
                            struct.set_launch_time_secs_isSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 11) {
                            struct.owner = iprot.readString();
                            struct.set_owner_isSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 12) {
                            struct.topology_action_options = new TopologyActionOptions();
                            struct.topology_action_options.read(iprot);
                            struct.set_topology_action_options_isSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 8) {
                            struct.prev_status = TopologyStatus.findByValue(iprot.readI32());
                            struct.set_prev_status_isSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 13) {
                            TMap _map806 = iprot.readMapBegin();
                            struct.component_debug = new HashMap<String, DebugOptions>(2 * _map806.size);
                            for (int _i809 = 0; _i809 < _map806.size; ++_i809) {
                                String _key807 = iprot.readString();
                                DebugOptions _val808 = new DebugOptions();
                                _val808.read(iprot);
                                struct.component_debug.put(_key807, _val808);
                            }
                            iprot.readMapEnd();
                            struct.set_component_debug_isSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 11) {
                            struct.principal = iprot.readString();
                            struct.set_principal_isSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 11) {
                            struct.topology_version = iprot.readString();
                            struct.set_topology_version_isSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, StormBase struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.name != null) {
                oprot.writeFieldBegin(NAME_FIELD_DESC);
                oprot.writeString(struct.name);
                oprot.writeFieldEnd();
            }
            if (struct.status != null) {
                oprot.writeFieldBegin(STATUS_FIELD_DESC);
                oprot.writeI32(struct.status.getValue());
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(NUM_WORKERS_FIELD_DESC);
            oprot.writeI32(struct.num_workers);
            oprot.writeFieldEnd();
            if (struct.component_executors != null && struct.is_set_component_executors()) {
                oprot.writeFieldBegin(COMPONENT_EXECUTORS_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 8, struct.component_executors.size()));
                for (Map.Entry<String, Integer> entry : struct.component_executors.entrySet()) {
                    oprot.writeString(entry.getKey());
                    oprot.writeI32(entry.getValue().intValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.is_set_launch_time_secs()) {
                oprot.writeFieldBegin(LAUNCH_TIME_SECS_FIELD_DESC);
                oprot.writeI32(struct.launch_time_secs);
                oprot.writeFieldEnd();
            }
            if (struct.owner != null && struct.is_set_owner()) {
                oprot.writeFieldBegin(OWNER_FIELD_DESC);
                oprot.writeString(struct.owner);
                oprot.writeFieldEnd();
            }
            if (struct.topology_action_options != null && struct.is_set_topology_action_options()) {
                oprot.writeFieldBegin(TOPOLOGY_ACTION_OPTIONS_FIELD_DESC);
                struct.topology_action_options.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.prev_status != null && struct.is_set_prev_status()) {
                oprot.writeFieldBegin(PREV_STATUS_FIELD_DESC);
                oprot.writeI32(struct.prev_status.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.component_debug != null && struct.is_set_component_debug()) {
                oprot.writeFieldBegin(COMPONENT_DEBUG_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 12, struct.component_debug.size()));
                for (Map.Entry<String, Comparable<Integer>> entry : struct.component_debug.entrySet()) {
                    oprot.writeString(entry.getKey());
                    ((DebugOptions)entry.getValue()).write(oprot);
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.principal != null && struct.is_set_principal()) {
                oprot.writeFieldBegin(PRINCIPAL_FIELD_DESC);
                oprot.writeString(struct.principal);
                oprot.writeFieldEnd();
            }
            if (struct.topology_version != null && struct.is_set_topology_version()) {
                oprot.writeFieldBegin(TOPOLOGY_VERSION_FIELD_DESC);
                oprot.writeString(struct.topology_version);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class StormBaseStandardSchemeFactory
    implements SchemeFactory {
        private StormBaseStandardSchemeFactory() {
        }

        public StormBaseStandardScheme getScheme() {
            return new StormBaseStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        NAME(1, "name"),
        STATUS(2, "status"),
        NUM_WORKERS(3, "num_workers"),
        COMPONENT_EXECUTORS(4, "component_executors"),
        LAUNCH_TIME_SECS(5, "launch_time_secs"),
        OWNER(6, "owner"),
        TOPOLOGY_ACTION_OPTIONS(7, "topology_action_options"),
        PREV_STATUS(8, "prev_status"),
        COMPONENT_DEBUG(9, "component_debug"),
        PRINCIPAL(10, "principal"),
        TOPOLOGY_VERSION(11, "topology_version");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return NAME;
                }
                case 2: {
                    return STATUS;
                }
                case 3: {
                    return NUM_WORKERS;
                }
                case 4: {
                    return COMPONENT_EXECUTORS;
                }
                case 5: {
                    return LAUNCH_TIME_SECS;
                }
                case 6: {
                    return OWNER;
                }
                case 7: {
                    return TOPOLOGY_ACTION_OPTIONS;
                }
                case 8: {
                    return PREV_STATUS;
                }
                case 9: {
                    return COMPONENT_DEBUG;
                }
                case 10: {
                    return PRINCIPAL;
                }
                case 11: {
                    return TOPOLOGY_VERSION;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

