/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.command;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.storm.blobstore.AtomicOutputStream;
import org.apache.storm.blobstore.BlobStore;
import org.apache.storm.blobstore.BlobStoreAclHandler;
import org.apache.storm.blobstore.ClientBlobStore;
import org.apache.storm.blobstore.InputStreamWithMeta;
import org.apache.storm.command.CLI;
import org.apache.storm.generated.AccessControl;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.generated.ReadableBlobMeta;
import org.apache.storm.generated.SettableBlobMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Blobstore {
    private static final Logger LOG = LoggerFactory.getLogger(Blobstore.class);

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            throw new IllegalArgumentException("You should provide command.");
        }
        String command = args[0];
        String[] newArgs = Arrays.copyOfRange(args, 1, args.length);
        switch (command) {
            case "cat": {
                Blobstore.readCli(newArgs);
                break;
            }
            case "create": {
                Blobstore.createCli(newArgs);
                break;
            }
            case "update": {
                Blobstore.updateCli(newArgs);
                break;
            }
            case "delete": {
                Blobstore.deleteCli(newArgs);
                break;
            }
            case "list": {
                Blobstore.listCli(newArgs);
                break;
            }
            case "set-acl": {
                Blobstore.setAclCli(newArgs);
                break;
            }
            case "replication": {
                Blobstore.replicationCli(newArgs);
                break;
            }
            default: {
                throw new RuntimeException(command + " is not a supported blobstore command");
            }
        }
    }

    private static void readCli(String[] args) throws Exception {
        Map<String, Object> cl = CLI.opt("f", "file", null, CLI.AS_STRING).arg("key", CLI.FIRST_WINS).parse(args);
        String key = (String)cl.get("key");
        String file = (String)cl.get("f");
        if (StringUtils.isNotEmpty((String)file)) {
            try (BufferedOutputStream f = new BufferedOutputStream(new FileOutputStream(file));){
                BlobStoreSupport.readBlob(key, f);
            }
        } else {
            BlobStoreSupport.readBlob(key, System.out);
        }
    }

    private static void createCli(String[] args) throws Exception {
        Map<String, Object> cl = CLI.opt("f", "file", null, CLI.AS_STRING).opt("a", "acl", Collections.emptyList(), new AsAclParser()).opt("r", "replication-factor", -1, CLI.AS_INT).arg("key", CLI.FIRST_WINS).parse(args);
        String key = (String)cl.get("key");
        String file = (String)cl.get("f");
        List acl = (List)cl.get("a");
        Integer replicationFactor = (Integer)cl.get("r");
        SettableBlobMeta meta = new SettableBlobMeta(acl);
        meta.set_replication_factor(replicationFactor.intValue());
        BlobStore.validateKey((String)key);
        LOG.info("Creating {} with ACL {}", (Object)key, Blobstore.generateAccessControlsInfo(acl));
        if (StringUtils.isNotEmpty((String)file)) {
            try (BufferedInputStream f = new BufferedInputStream(new FileInputStream(file));){
                BlobStoreSupport.createBlobFromStream(key, f, meta);
            }
        } else {
            BlobStoreSupport.createBlobFromStream(key, System.in, meta);
        }
        LOG.info("Successfully created {}", (Object)key);
    }

    private static void updateCli(String[] args) throws Exception {
        Map<String, Object> cl = CLI.opt("f", "file", null, CLI.AS_STRING).arg("key", CLI.FIRST_WINS).parse(args);
        String key = (String)cl.get("key");
        String file = (String)cl.get("f");
        if (StringUtils.isNotEmpty((String)file)) {
            try (BufferedInputStream f = new BufferedInputStream(new FileInputStream(file));){
                BlobStoreSupport.updateBlobFromStream(key, f);
            }
        } else {
            BlobStoreSupport.updateBlobFromStream(key, System.in);
        }
        LOG.info("Successfully updated {}", (Object)key);
    }

    private static void deleteCli(String[] args) throws Exception {
        ClientBlobStore.withConfiguredClient(blobStore -> {
            for (String key : args) {
                blobStore.deleteBlob(key);
                LOG.info("deleted {}", (Object)key);
            }
        });
    }

    private static void listCli(String[] args) throws Exception {
        ClientBlobStore.withConfiguredClient(blobStore -> {
            boolean isArgsEmpty = args == null || args.length == 0;
            Iterator<String> keys = isArgsEmpty ? blobStore.listKeys() : Arrays.asList(args).iterator();
            while (keys.hasNext()) {
                String key = keys.next();
                try {
                    ReadableBlobMeta meta = blobStore.getBlobMeta(key);
                    long version = meta.get_version();
                    List acl = meta.get_settable().get_acl();
                    LOG.info("{} {} {}", new Object[]{key, version, Blobstore.generateAccessControlsInfo(acl)});
                }
                catch (AuthorizationException ae) {
                    if (isArgsEmpty) continue;
                    LOG.error("ACCESS DENIED to key: {}", (Object)key);
                }
                catch (KeyNotFoundException knf) {
                    if (isArgsEmpty) continue;
                    LOG.error("{} NOT FOUND", (Object)key);
                }
            }
        });
    }

    private static void setAclCli(String[] args) throws Exception {
        Map<String, Object> cl = CLI.opt("s", "set", Collections.emptyList(), new AsAclParser()).arg("key", CLI.FIRST_WINS).parse(args);
        String key = (String)cl.get("key");
        List setAcl = (List)cl.get("s");
        ClientBlobStore.withConfiguredClient(blobStore -> {
            ReadableBlobMeta meta = blobStore.getBlobMeta(key);
            List acl = meta.get_settable().get_acl();
            List newAcl = setAcl != null && !setAcl.isEmpty() ? setAcl : acl;
            SettableBlobMeta newMeta = new SettableBlobMeta(newAcl);
            LOG.info("Setting ACL for {} to {}", (Object)key, Blobstore.generateAccessControlsInfo(newAcl));
            blobStore.setBlobMeta(key, newMeta);
        });
    }

    private static void replicationCli(String[] args) throws Exception {
        if (args.length == 0) {
            throw new IllegalArgumentException("replication command needs at least subcommand as parameter.");
        }
        final String subCommand = args[0];
        final String[] newArgs = Arrays.copyOfRange(args, 1, args.length);
        ClientBlobStore.withConfiguredClient((ClientBlobStore.WithBlobstore)new ClientBlobStore.WithBlobstore(){

            public void run(ClientBlobStore blobStore) throws Exception {
                switch (subCommand) {
                    case "--read": {
                        if (newArgs.length == 0) {
                            throw new IllegalArgumentException("replication --read needs key as parameter.");
                        }
                        String key = newArgs[0];
                        int blobReplication = blobStore.getBlobReplication(key);
                        LOG.info("Current replication factor {}", (Object)blobReplication);
                        break;
                    }
                    case "--update": {
                        this.updateReplicationFactor(blobStore, newArgs);
                        break;
                    }
                    default: {
                        throw new RuntimeException(subCommand + " is not a supported blobstore command");
                    }
                }
            }

            private void updateReplicationFactor(ClientBlobStore blobStore, String[] args) throws Exception {
                Map<String, Object> cl = CLI.opt("r", "replication-factor", null, CLI.AS_INT).arg("key", CLI.FIRST_WINS).parse(args);
                String key = (String)cl.get("key");
                Integer replicationFactor = (Integer)cl.get("r");
                if (replicationFactor == null) {
                    throw new RuntimeException("Please set the replication factor");
                }
                int blobReplication = blobStore.updateBlobReplication(key, replicationFactor.intValue());
                LOG.info("Replication factor is set to {}", (Object)blobReplication);
            }
        });
    }

    private static List<String> generateAccessControlsInfo(List<AccessControl> acl) {
        ArrayList<String> accessControlStrings = new ArrayList<String>();
        for (AccessControl ac : acl) {
            accessControlStrings.add(BlobStoreAclHandler.accessControlToString((AccessControl)ac));
        }
        return accessControlStrings;
    }

    private static final class AsAclParser
    implements CLI.Parse {
        private AsAclParser() {
        }

        @Override
        public Object parse(String value) {
            ArrayList<AccessControl> accessControls = new ArrayList<AccessControl>();
            for (String part : value.split(",")) {
                accessControls.add(this.asAccessControl(part));
            }
            return accessControls;
        }

        private AccessControl asAccessControl(String param) {
            return BlobStoreAclHandler.parseAccessControl((String)param);
        }
    }

    private static final class BlobStoreSupport {
        private BlobStoreSupport() {
        }

        static void readBlob(String key, OutputStream os) throws Exception {
            ClientBlobStore.withConfiguredClient(blobStore -> {
                try (InputStreamWithMeta is = blobStore.getBlob(key);){
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
            });
        }

        static void createBlobFromStream(String key, InputStream is, SettableBlobMeta meta) throws Exception {
            ClientBlobStore.withConfiguredClient(blobStore -> {
                AtomicOutputStream os = blobStore.createBlob(key, meta);
                BlobStoreSupport.copyInputStreamToBlobOutputStream(is, os);
            });
        }

        static void updateBlobFromStream(String key, InputStream is) throws Exception {
            ClientBlobStore.withConfiguredClient(blobStore -> {
                AtomicOutputStream os = blobStore.updateBlob(key);
                BlobStoreSupport.copyInputStreamToBlobOutputStream(is, os);
            });
        }

        static void copyInputStreamToBlobOutputStream(InputStream is, AtomicOutputStream os) throws IOException {
            try {
                IOUtils.copy((InputStream)is, (OutputStream)os);
                os.close();
            }
            catch (Exception e) {
                os.cancel();
                throw e;
            }
        }
    }
}

