/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource.normalization;

import java.util.Map;
import org.apache.storm.generated.WorkerResources;
import org.apache.storm.scheduler.resource.normalization.NormalizedResourceRequest;
import org.apache.storm.scheduler.resource.normalization.NormalizedResources;
import org.apache.storm.scheduler.resource.normalization.NormalizedResourcesWithMemory;
import org.apache.storm.scheduler.resource.normalization.ResourceMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalizedResourceOffer
implements NormalizedResourcesWithMemory {
    private static final Logger LOG = LoggerFactory.getLogger(NormalizedResourceOffer.class);
    private final NormalizedResources normalizedResources;
    private double totalMemoryMb;

    public NormalizedResourceOffer(Map<String, ? extends Number> resources) {
        Map<String, Double> normalizedResourceMap = NormalizedResources.RESOURCE_NAME_NORMALIZER.normalizedResourceMap(resources);
        this.totalMemoryMb = normalizedResourceMap.getOrDefault("memory.mb", 0.0);
        this.normalizedResources = new NormalizedResources(normalizedResourceMap);
    }

    public NormalizedResourceOffer() {
        this.normalizedResources = new NormalizedResources();
        this.totalMemoryMb = 0.0;
    }

    public NormalizedResourceOffer(NormalizedResourceOffer other) {
        this.totalMemoryMb = other.totalMemoryMb;
        this.normalizedResources = new NormalizedResources(other.normalizedResources);
    }

    @Override
    public double getTotalMemoryMb() {
        return this.totalMemoryMb;
    }

    public Map<String, Double> toNormalizedMap() {
        Map<String, Double> ret = this.normalizedResources.toNormalizedMap();
        ret.put("memory.mb", this.totalMemoryMb);
        return ret;
    }

    public void add(NormalizedResourcesWithMemory other) {
        this.normalizedResources.add(other.getNormalizedResources());
        this.totalMemoryMb += other.getTotalMemoryMb();
    }

    public boolean remove(NormalizedResourcesWithMemory other, ResourceMetrics resourceMetrics) {
        boolean negativeResources = this.normalizedResources.remove(other.getNormalizedResources(), resourceMetrics);
        this.totalMemoryMb -= other.getTotalMemoryMb();
        if (this.totalMemoryMb < 0.0) {
            negativeResources = true;
            if (resourceMetrics != null) {
                resourceMetrics.getNegativeResourceEventsMeter().mark();
            }
            this.totalMemoryMb = 0.0;
        }
        return negativeResources;
    }

    public boolean remove(NormalizedResourcesWithMemory other) {
        return this.remove(other, null);
    }

    public boolean remove(WorkerResources other, ResourceMetrics resourceMetrics) {
        boolean negativeResources = this.normalizedResources.remove(other);
        this.totalMemoryMb -= other.get_mem_off_heap() + other.get_mem_on_heap();
        if (this.totalMemoryMb < 0.0) {
            negativeResources = true;
            resourceMetrics.getNegativeResourceEventsMeter().mark();
            this.totalMemoryMb = 0.0;
        }
        return negativeResources;
    }

    public double calculateAveragePercentageUsedBy(NormalizedResourceOffer used) {
        return this.normalizedResources.calculateAveragePercentageUsedBy(used.getNormalizedResources(), this.getTotalMemoryMb(), used.getTotalMemoryMb());
    }

    public double calculateMinPercentageUsedBy(NormalizedResourceOffer used) {
        return this.normalizedResources.calculateMinPercentageUsedBy(used.getNormalizedResources(), this.getTotalMemoryMb(), used.getTotalMemoryMb());
    }

    public boolean couldHoldIgnoringSharedMemory(NormalizedResourcesWithMemory other) {
        return this.normalizedResources.couldHoldIgnoringSharedMemory(other.getNormalizedResources(), this.getTotalMemoryMb(), other.getTotalMemoryMb());
    }

    public boolean couldHoldIgnoringSharedMemoryAndCpu(NormalizedResourcesWithMemory other) {
        return this.normalizedResources.couldHoldIgnoringSharedMemoryAndCpu(other.getNormalizedResources(), this.getTotalMemoryMb(), other.getTotalMemoryMb());
    }

    public double getTotalCpu() {
        return this.normalizedResources.getTotalCpu();
    }

    @Override
    public NormalizedResources getNormalizedResources() {
        return this.normalizedResources;
    }

    public String toString() {
        return "Normalized resources: " + this.toNormalizedMap();
    }

    public void updateForRareResourceAffinity(NormalizedResourceRequest requestedResources) {
        this.normalizedResources.updateForRareResourceAffinity(requestedResources.getNormalizedResources());
    }

    @Override
    public void clear() {
        this.totalMemoryMb = 0.0;
        this.normalizedResources.clear();
    }

    @Override
    public boolean areAnyOverZero() {
        return this.totalMemoryMb > 0.0 || this.normalizedResources.areAnyOverZero();
    }

    public boolean couldFit(double minWorkerCpu, NormalizedResourceRequest requestedResources) {
        if (minWorkerCpu < 0.001) {
            return this.couldHoldIgnoringSharedMemory(requestedResources);
        }
        double requestedCpu = Math.max(requestedResources.getTotalCpu() - minWorkerCpu, 0.0);
        if (requestedCpu > this.getTotalCpu()) {
            return false;
        }
        return this.couldHoldIgnoringSharedMemoryAndCpu(requestedResources);
    }
}

