/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource;

import org.apache.storm.scheduler.resource.SchedulingStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulingResult {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulingResult.class);
    private final SchedulingStatus status;
    private final String message;
    private final String errorMessage;

    private SchedulingResult(SchedulingStatus status, String message, String errorMessage) {
        this.status = status;
        this.message = message;
        this.errorMessage = errorMessage;
    }

    public static SchedulingResult failure(SchedulingStatus status, String errorMessage) {
        return new SchedulingResult(status, null, errorMessage);
    }

    public static SchedulingResult success() {
        return SchedulingResult.success(null);
    }

    public static SchedulingResult success(String message) {
        return new SchedulingResult(SchedulingStatus.SUCCESS, message, null);
    }

    public SchedulingStatus getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isSuccess() {
        return SchedulingStatus.isStatusSuccess(this.status);
    }

    public boolean isFailure() {
        return SchedulingStatus.isStatusFailure(this.status);
    }

    public String toString() {
        String ret = null;
        ret = this.isSuccess() ? "Status: " + this.getStatus() + " message: " + this.getMessage() : "Status: " + this.getStatus() + " error message: " + this.getErrorMessage();
        return ret;
    }
}

