/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metricstore.rocksdb;

import com.codahale.metrics.Meter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.storm.metricstore.AggLevel;
import org.apache.storm.metricstore.Metric;
import org.apache.storm.metricstore.MetricException;
import org.apache.storm.metricstore.rocksdb.KeyType;
import org.apache.storm.metricstore.rocksdb.RocksDbKey;
import org.apache.storm.metricstore.rocksdb.RocksDbStore;
import org.apache.storm.metricstore.rocksdb.RocksDbValue;
import org.apache.storm.metricstore.rocksdb.StringMetadata;
import org.apache.storm.metricstore.rocksdb.StringMetadataCache;
import org.apache.storm.metricstore.rocksdb.WritableStringMetadataCache;
import org.rocksdb.FlushOptions;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDbMetricsWriter
implements Runnable,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(RocksDbMetricsWriter.class);
    private RocksDbStore store;
    private BlockingQueue queue;
    private WritableStringMetadataCache stringMetadataCache;
    private Set<Integer> unusedIds = new HashSet<Integer>();
    private TreeMap<RocksDbKey, RocksDbValue> insertBatch = new TreeMap();
    private WriteOptions writeOpts = new WriteOptions();
    private volatile boolean shutdown = false;
    private Meter failureMeter;
    private ArrayList<AggLevel> aggBuckets = new ArrayList();

    RocksDbMetricsWriter(RocksDbStore store, BlockingQueue queue, Meter failureMeter) {
        this.store = store;
        this.queue = queue;
        this.failureMeter = failureMeter;
        this.aggBuckets.add(AggLevel.AGG_LEVEL_1_MIN);
        this.aggBuckets.add(AggLevel.AGG_LEVEL_10_MIN);
        this.aggBuckets.add(AggLevel.AGG_LEVEL_60_MIN);
    }

    void init() throws MetricException {
        this.stringMetadataCache = StringMetadataCache.getWritableStringMetadataCache();
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            try {
                Metric m = (Metric)this.queue.take();
                this.processInsert(m);
            }
            catch (Exception e) {
                LOG.error("Failed to insert metric", (Throwable)e);
                if (this.failureMeter == null) continue;
                this.failureMeter.mark();
            }
        }
    }

    private void processInsert(Metric metric) throws MetricException {
        long metricTimestamp = metric.getTimestamp();
        Integer topologyId = this.storeMetadataString(KeyType.TOPOLOGY_STRING, metric.getTopologyId(), metricTimestamp);
        Integer metricId = this.storeMetadataString(KeyType.METRIC_STRING, metric.getMetricName(), metricTimestamp);
        Integer componentId = this.storeMetadataString(KeyType.COMPONENT_STRING, metric.getComponentId(), metricTimestamp);
        Integer executorId = this.storeMetadataString(KeyType.EXEC_ID_STRING, metric.getExecutorId(), metricTimestamp);
        Integer hostId = this.storeMetadataString(KeyType.HOST_STRING, metric.getHostname(), metricTimestamp);
        Integer streamId = this.storeMetadataString(KeyType.STREAM_ID_STRING, metric.getStreamId(), metricTimestamp);
        RocksDbKey key = RocksDbKey.createMetricKey(AggLevel.AGG_LEVEL_NONE, topologyId, metric.getTimestamp(), metricId, componentId, executorId, hostId, metric.getPort(), streamId);
        RocksDbValue value = new RocksDbValue(metric);
        this.insertBatch.put(key, value);
        ListIterator<AggLevel> li = this.aggBuckets.listIterator(this.aggBuckets.size());
        boolean populate = true;
        while (li.hasPrevious()) {
            AggLevel bucket = li.previous();
            Metric aggMetric = new Metric(metric);
            aggMetric.setAggLevel(bucket);
            long msToBucket = 60000L * (long)bucket.getValue();
            long roundedToBucket = msToBucket * (metric.getTimestamp() / msToBucket);
            aggMetric.setTimestamp(roundedToBucket);
            RocksDbKey aggKey = RocksDbKey.createMetricKey(bucket, topologyId, aggMetric.getTimestamp(), metricId, componentId, executorId, hostId, aggMetric.getPort(), streamId);
            if (populate) {
                if (this.store.populateFromKey(aggKey, aggMetric)) {
                    aggMetric.addValue(metric.getValue());
                } else {
                    populate = false;
                }
            }
            RocksDbValue aggVal = new RocksDbValue(aggMetric);
            this.insertBatch.put(aggKey, aggVal);
        }
        this.processBatchInsert(this.insertBatch);
        this.insertBatch.clear();
    }

    private int storeMetadataString(KeyType type, String s, long metricTimestamp) throws MetricException {
        if (s == null) {
            throw new MetricException("No string for metric metadata string type " + type);
        }
        StringMetadata stringMetadata = this.stringMetadataCache.get(s);
        if (stringMetadata != null) {
            stringMetadata.update(metricTimestamp, type);
            return stringMetadata.getStringId();
        }
        try {
            stringMetadata = this.store.rocksDbGetStringMetadata(type, s);
        }
        catch (RocksDBException e) {
            throw new MetricException("Error reading metrics data", e);
        }
        if (stringMetadata != null) {
            stringMetadata.update(metricTimestamp, type);
            this.stringMetadataCache.put(s, stringMetadata, false);
            return stringMetadata.getStringId();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(type + "." + s + " does not exist in cache or database");
        }
        int stringId = this.getUniqueMetadataStringId();
        stringMetadata = new StringMetadata(type, stringId, metricTimestamp);
        this.stringMetadataCache.put(s, stringMetadata, true);
        return stringMetadata.getStringId();
    }

    private int getUniqueMetadataStringId() throws MetricException {
        this.generateUniqueStringIds();
        int id = this.unusedIds.iterator().next();
        this.unusedIds.remove(id);
        return id;
    }

    private void generateUniqueStringIds() throws MetricException {
        int attempts = 0;
        while (this.unusedIds.isEmpty()) {
            if (++attempts > 100) {
                String message = "Failed to generate unique ids";
                LOG.error(message);
                throw new MetricException(message);
            }
            for (int i = 0; i < 600; ++i) {
                int n = ThreadLocalRandom.current().nextInt();
                if (n == 0 || this.stringMetadataCache.contains(n)) continue;
                this.unusedIds.add(n);
            }
            RocksDbKey firstPrefix = RocksDbKey.getPrefix(KeyType.METADATA_STRING_START);
            RocksDbKey lastPrefix = RocksDbKey.getPrefix(KeyType.METADATA_STRING_END);
            try {
                this.store.scanRange(firstPrefix, lastPrefix, (key, value) -> {
                    this.unusedIds.remove(key.getMetadataStringId());
                    return true;
                });
            }
            catch (RocksDBException e) {
                throw new MetricException("Error reading metrics data", e);
            }
        }
    }

    private void processBatchInsert(TreeMap<RocksDbKey, RocksDbValue> batchMap) throws MetricException {
        try (WriteBatch writeBatch = new WriteBatch();){
            for (RocksDbKey k : batchMap.keySet()) {
                RocksDbValue v = batchMap.get(k);
                writeBatch.put(k.getRaw(), v.getRaw());
            }
            this.store.db.write(this.writeOpts, writeBatch);
        }
        catch (Exception e) {
            String message = "Failed to store data to RocksDB";
            LOG.error(message, (Throwable)e);
            throw new MetricException(message, e);
        }
    }

    void handleEvictedMetadata(RocksDbKey key, RocksDbValue val) {
        try {
            this.store.db.put(key.getRaw(), val.getRaw());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public void close() {
        block11: {
            this.shutdown = true;
            TreeMap<RocksDbKey, RocksDbValue> batchMap = new TreeMap<RocksDbKey, RocksDbValue>();
            for (Map.Entry<String, StringMetadata> entry : this.stringMetadataCache.entrySet()) {
                String metadataString = entry.getKey();
                StringMetadata val = entry.getValue();
                RocksDbValue rval = new RocksDbValue(val.getLastTimestamp(), metadataString);
                for (KeyType type : val.getMetadataTypes()) {
                    RocksDbKey rkey = new RocksDbKey(type, val.getStringId());
                    batchMap.put(rkey, rval);
                }
            }
            try {
                this.processBatchInsert(batchMap);
            }
            catch (MetricException e) {
                LOG.error("Failed to insert all metadata", (Throwable)e);
            }
            try (FlushOptions flushOps = new FlushOptions();){
                flushOps.setWaitForFlush(true);
                this.store.db.flush(flushOps);
            }
            catch (RocksDBException e) {
                LOG.error("Failed ot flush RocksDB", (Throwable)e);
                if (this.failureMeter == null) break block11;
                this.failureMeter.mark();
            }
        }
    }
}

