/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.localizer;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.storm.blobstore.ClientBlobStore;
import org.apache.storm.daemon.supervisor.AdvancedFSOps;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.localizer.LocallyCachedBlob;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.ServerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocallyCachedTopologyBlob
extends LocallyCachedBlob {
    public static final long LOCAL_MODE_JAR_VERSION = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(LocallyCachedTopologyBlob.class);
    private static final Pattern EXTRACT_BASE_NAME_AND_VERSION = Pattern.compile("^(.*)\\.([0-9]+)$");
    private final TopologyBlobType type;
    private final String topologyId;
    private final boolean isLocalMode;
    private final Path topologyBasicBlobsRootDir;
    private final AdvancedFSOps fsOps;
    private final String owner;
    private volatile long version = -1L;
    private volatile long size = 0L;
    private final Map<String, Object> conf;

    protected LocallyCachedTopologyBlob(String topologyId, boolean isLocalMode, Map<String, Object> conf, AdvancedFSOps fsOps, TopologyBlobType type, String owner, StormMetricsRegistry metricsRegistry) throws IOException {
        super(topologyId + " " + type.getFileName(), type.getKey(topologyId), metricsRegistry);
        this.topologyId = topologyId;
        this.type = type;
        this.isLocalMode = isLocalMode;
        this.fsOps = fsOps;
        this.owner = owner;
        this.conf = conf;
        this.topologyBasicBlobsRootDir = Paths.get(ConfigUtils.supervisorStormDistRoot(conf, (String)topologyId), new String[0]);
        this.readVersion();
        this.updateSizeOnDisk();
    }

    private static String resourcesJar() throws IOException {
        String path = ServerUtils.currentClasspath();
        if (path == null) {
            return null;
        }
        for (String jpath : path.split(File.pathSeparator)) {
            if (!jpath.endsWith(".jar") || !ServerUtils.zipDoesContainDir(jpath, "resources")) continue;
            return jpath;
        }
        return null;
    }

    private void updateSizeOnDisk() throws IOException {
        long total = LocallyCachedTopologyBlob.getSizeOnDisk(this.topologyBasicBlobsRootDir.resolve(this.type.getFileName()));
        if (this.type.needsExtraction()) {
            total += LocallyCachedTopologyBlob.getSizeOnDisk(this.topologyBasicBlobsRootDir.resolve(this.type.getExtractionDir()));
        }
        this.size = total;
    }

    private void readVersion() throws IOException {
        Path versionFile = this.topologyBasicBlobsRootDir.resolve(this.type.getVersionFileName());
        if (!this.fsOps.fileExists(versionFile)) {
            this.version = -1L;
        } else {
            String ver = FileUtils.readFileToString((File)versionFile.toFile(), (String)"UTF8").trim();
            this.version = Long.parseLong(ver);
        }
    }

    @Override
    public long getLocalVersion() {
        LOG.debug("LOCAL VERSION {}/{} is {}", new Object[]{this.type, this.topologyId, this.version});
        return this.version;
    }

    @Override
    public long getRemoteVersion(ClientBlobStore store) throws KeyNotFoundException, AuthorizationException {
        if (this.isLocalMode && this.type == TopologyBlobType.TOPO_JAR) {
            LOG.debug("REMOTE VERSION LOCAL JAR {}", (Object)1L);
            return 1L;
        }
        return store.getBlobMeta(this.type.getKey(this.topologyId)).get_version();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long fetchUnzipToTemp(ClientBlobStore store) throws IOException, KeyNotFoundException, AuthorizationException {
        Class<LocallyCachedTopologyBlob> clazz = LocallyCachedTopologyBlob.class;
        synchronized (LocallyCachedTopologyBlob.class) {
            if (!Files.exists(this.topologyBasicBlobsRootDir, new LinkOption[0])) {
                Files.createDirectories(this.topologyBasicBlobsRootDir, new FileAttribute[0]);
                this.fsOps.setupStormCodeDir(this.owner, this.topologyBasicBlobsRootDir.toFile());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.isLocalMode && this.type == TopologyBlobType.TOPO_JAR) {
                LOG.debug("DOWNLOADING LOCAL JAR to TEMP LOCATION... {}", (Object)this.topologyId);
                String resourcesJar = LocallyCachedTopologyBlob.resourcesJar();
                URL url = ServerUtils.getResourceFromClassloader("resources");
                Path extractionDest = this.topologyBasicBlobsRootDir.resolve(this.type.getTempExtractionDir(1L));
                if (resourcesJar != null) {
                    LOG.info("Extracting resources from jar at {} to {}", (Object)resourcesJar, (Object)extractionDest);
                    this.extractDirFromJar(resourcesJar, "resources", extractionDest);
                } else if (url != null) {
                    LOG.info("Copying resources at {} to {}", (Object)url, (Object)extractionDest);
                    if ("jar".equals(url.getProtocol())) {
                        JarURLConnection urlConnection = (JarURLConnection)url.openConnection();
                        this.extractDirFromJar(urlConnection.getJarFileURL().getFile(), "resources", extractionDest);
                    } else {
                        this.fsOps.copyDirectory(new File(url.getFile()), extractionDest.toFile());
                    }
                } else if (!this.fsOps.fileExists(extractionDest)) {
                    this.fsOps.forceMkdir(extractionDest);
                }
                return 1L;
            }
            LocallyCachedBlob.DownloadMeta downloadMeta = this.fetch(store, this.type.getKey(this.topologyId), v -> {
                Path path = this.topologyBasicBlobsRootDir.resolve(this.type.getTempFileName((long)v));
                this.fsOps.forceMkdir(path.getParent());
                return path;
            }, arg_0 -> ((AdvancedFSOps)this.fsOps).getOutputStream(arg_0));
            Path tmpLocation = downloadMeta.getDownloadPath();
            if (this.type.needsExtraction()) {
                Path extractionDest = this.topologyBasicBlobsRootDir.resolve(this.type.getTempExtractionDir(downloadMeta.getVersion()));
                this.extractDirFromJar(tmpLocation.toAbsolutePath().toString(), "resources", extractionDest);
            }
            return downloadMeta.getVersion();
        }
    }

    protected void extractDirFromJar(String jarpath, String dir, Path dest) throws IOException {
        LOG.debug("EXTRACTING {} from {} and placing it at {}", new Object[]{dir, jarpath, dest});
        if (!Files.exists(dest, new LinkOption[0])) {
            Files.createDirectories(dest, new FileAttribute[0]);
        }
        try (JarFile jarFile = new JarFile(jarpath);){
            String prefix = dir + "/";
            ServerUtils.extractZipFile(jarFile, dest.toFile(), prefix);
        }
    }

    @Override
    public boolean isFullyDownloaded() {
        Path versionFile = this.topologyBasicBlobsRootDir.resolve(this.type.getVersionFileName());
        boolean ret = Files.exists(versionFile, new LinkOption[0]);
        Path dest = this.topologyBasicBlobsRootDir.resolve(this.type.getFileName());
        if (!this.isLocalMode || this.type != TopologyBlobType.TOPO_JAR) {
            boolean bl = ret = ret && Files.exists(dest, new LinkOption[0]);
        }
        if (this.type.needsExtraction()) {
            Path extractionDest = this.topologyBasicBlobsRootDir.resolve(this.type.getExtractionDir());
            ret = ret && Files.exists(extractionDest, new LinkOption[0]);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void commitNewVersion(long newVersion) throws IOException {
        Path tempLoc = this.topologyBasicBlobsRootDir.resolve(this.type.getTempFileName(newVersion));
        Path dest = this.topologyBasicBlobsRootDir.resolve(this.type.getFileName());
        Path versionFile = this.topologyBasicBlobsRootDir.resolve(this.type.getVersionFileName());
        LOG.debug("Removing version file {} to force download on failure", (Object)versionFile);
        this.fsOps.deleteIfExists(versionFile.toFile());
        LOG.debug("Removing destination file {} in preparation for move", (Object)dest);
        this.fsOps.deleteIfExists(dest.toFile());
        if (this.type.needsExtraction()) {
            Path extractionTemp = this.topologyBasicBlobsRootDir.resolve(this.type.getTempExtractionDir(newVersion));
            Path extractionDest = this.topologyBasicBlobsRootDir.resolve(this.type.getExtractionDir());
            LOG.debug("Removing extraction dest {} in preparation for extraction", (Object)extractionDest);
            this.fsOps.deleteIfExists(extractionDest.toFile());
            if (this.fsOps.fileExists(extractionTemp)) {
                this.fsOps.moveDirectoryPreferAtomic(extractionTemp.toFile(), extractionDest.toFile());
            }
        }
        if (!this.isLocalMode || this.type != TopologyBlobType.TOPO_JAR) {
            this.fsOps.moveFile(tempLoc.toFile(), dest.toFile());
        }
        Class<LocallyCachedTopologyBlob> clazz = LocallyCachedTopologyBlob.class;
        synchronized (LocallyCachedTopologyBlob.class) {
            this.fsOps.setupStormCodeDir(this.owner, this.topologyBasicBlobsRootDir.toFile());
            File sharedMemoryDirFinalLocation = new File(ConfigUtils.sharedByTopologyDir(this.conf, (String)this.topologyId));
            sharedMemoryDirFinalLocation.mkdirs();
            this.fsOps.setupWorkerArtifactsDir(this.owner, sharedMemoryDirFinalLocation);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            LOG.debug("Writing out version file {} with version {}", (Object)versionFile, (Object)newVersion);
            FileUtils.write((File)versionFile.toFile(), (CharSequence)Long.toString(newVersion), (String)"UTF8");
            this.version = newVersion;
            this.updateSizeOnDisk();
            LOG.debug("New version of {} - {} committed {}", new Object[]{this.topologyId, this.type, newVersion});
            return;
        }
    }

    @Override
    public void cleanupOrphanedData() throws IOException {
        this.cleanUpTemp(this.type.getFileName());
        if (this.type.needsExtraction()) {
            this.cleanUpTemp(this.type.getExtractionDir());
        }
    }

    private void cleanUpTemp(String baseName) throws IOException {
        LOG.debug("Cleaning up temporary data in {}", (Object)this.topologyBasicBlobsRootDir);
        try (DirectoryStream children = this.fsOps.newDirectoryStream(this.topologyBasicBlobsRootDir, p -> {
            String fileName = p.getFileName().toString();
            Matcher m = EXTRACT_BASE_NAME_AND_VERSION.matcher(fileName);
            return m.matches() && baseName.equals(m.group(1));
        });){
            if (children != null) {
                for (Path p2 : children) {
                    LOG.debug("Cleaning up {}", (Object)p2);
                    this.fsOps.deleteIfExists(p2.toFile());
                }
            }
        }
    }

    @Override
    public void completelyRemove() throws IOException {
        this.removeAll(this.type.getFileName());
        if (this.type.needsExtraction()) {
            this.removeAll(this.type.getExtractionDir());
        }
        this.touch();
    }

    private void removeAll(String baseName) throws IOException {
        try (DirectoryStream children = this.fsOps.newDirectoryStream(this.topologyBasicBlobsRootDir);){
            for (Path p : children) {
                String fileName = p.getFileName().toString();
                if (!fileName.startsWith(baseName)) continue;
                this.fsOps.deleteIfExists(p.toFile());
            }
        }
    }

    @Override
    public long getSizeOnDisk() {
        return this.size;
    }

    public boolean equals(Object other) {
        if (other instanceof LocallyCachedTopologyBlob) {
            LocallyCachedTopologyBlob o = (LocallyCachedTopologyBlob)other;
            return this.topologyId.equals(o.topologyId) && this.type == o.type && this.topologyBasicBlobsRootDir.equals(o.topologyBasicBlobsRootDir);
        }
        return false;
    }

    public int hashCode() {
        return this.topologyId.hashCode() + this.type.hashCode() + this.topologyBasicBlobsRootDir.hashCode();
    }

    public String toString() {
        return "LOCAL TOPO BLOB " + this.type + " " + this.topologyId;
    }

    public static enum TopologyBlobType {
        TOPO_JAR("stormjar.jar", "-stormjar.jar", "resources"),
        TOPO_CODE("stormcode.ser", "-stormcode.ser", null),
        TOPO_CONF("stormconf.ser", "-stormconf.ser", null);

        private final String fileName;
        private final String keySuffix;
        private final String extractionDir;

        private TopologyBlobType(String fileName, String keySuffix, String extractionDir) {
            this.fileName = fileName;
            this.keySuffix = keySuffix;
            this.extractionDir = extractionDir;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getTempFileName(long version) {
            return this.fileName + "." + version;
        }

        public String getVersionFileName() {
            return this.fileName + ".version";
        }

        public String getKey(String topologyId) {
            return topologyId + this.keySuffix;
        }

        public boolean needsExtraction() {
            return this.extractionDir != null;
        }

        public String getExtractionDir() {
            return this.extractionDir;
        }

        public String getTempExtractionDir(long version) {
            return this.extractionDir + "." + version;
        }
    }
}

