/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncRoundWithNumDigitsDecimalToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.RoundWithNumDigitsDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncRoundDecimalToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncRoundDoubleToDouble;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.RoundUtils;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantShortObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;

@Description(name="round", value="_FUNC_(x[, d]) - round x to d decimal places", extended="Example:\n  > SELECT _FUNC_(12.3456, 1) FROM src LIMIT 1;\n  12.3'")
@VectorizedExpressions(value={FuncRoundDoubleToDouble.class, RoundWithNumDigitsDoubleToDouble.class, FuncRoundWithNumDigitsDecimalToDecimal.class, FuncRoundDecimalToDecimal.class})
public class GenericUDFRound
extends GenericUDF {
    private transient PrimitiveObjectInspector inputOI;
    private int scale = 0;
    private transient PrimitiveObjectInspector.PrimitiveCategory inputType;
    private transient ObjectInspectorConverters.Converter converterFromString;
    private transient boolean constantScale = true;
    private transient PrimitiveObjectInspector scaleOI;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 1 || arguments.length > 2) {
            throw new UDFArgumentLengthException("ROUND requires one or two argument, got " + arguments.length);
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "ROUND input only takes primitive types, got " + arguments[0].getTypeName());
        }
        this.inputOI = (PrimitiveObjectInspector)arguments[0];
        if (arguments.length == 2) {
            if (arguments[1].getCategory() != ObjectInspector.Category.PRIMITIVE) {
                throw new UDFArgumentTypeException(1, "ROUND second argument only takes primitive types, got " + arguments[1].getTypeName());
            }
            this.scaleOI = (PrimitiveObjectInspector)arguments[1];
            switch (this.scaleOI.getPrimitiveCategory()) {
                case VOID: {
                    break;
                }
                case BYTE: {
                    if (this.scaleOI instanceof WritableConstantByteObjectInspector) {
                        this.scale = ((WritableConstantByteObjectInspector)this.scaleOI).getWritableConstantValue().get();
                        break;
                    }
                    this.constantScale = false;
                    break;
                }
                case SHORT: {
                    if (this.scaleOI instanceof WritableConstantShortObjectInspector) {
                        this.scale = ((WritableConstantShortObjectInspector)this.scaleOI).getWritableConstantValue().get();
                        break;
                    }
                    this.constantScale = false;
                    break;
                }
                case INT: {
                    if (this.scaleOI instanceof WritableConstantIntObjectInspector) {
                        this.scale = ((WritableConstantIntObjectInspector)this.scaleOI).getWritableConstantValue().get();
                        break;
                    }
                    this.constantScale = false;
                    break;
                }
                case LONG: {
                    if (this.scaleOI instanceof WritableConstantLongObjectInspector) {
                        long l = ((WritableConstantLongObjectInspector)this.scaleOI).getWritableConstantValue().get();
                        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                            throw new UDFArgumentException(this.getFuncName().toUpperCase() + " scale argument out of allowed range");
                        }
                        this.scale = (int)l;
                        break;
                    }
                    this.constantScale = false;
                    break;
                }
                default: {
                    throw new UDFArgumentTypeException(1, this.getFuncName().toUpperCase() + " second argument only takes numeric type");
                }
            }
        }
        this.inputType = this.inputOI.getPrimitiveCategory();
        AbstractPrimitiveWritableObjectInspector outputOI = null;
        switch (this.inputType) {
            case DECIMAL: {
                DecimalTypeInfo inputTypeInfo = (DecimalTypeInfo)this.inputOI.getTypeInfo();
                DecimalTypeInfo typeInfo = GenericUDFRound.getOutputTypeInfo(inputTypeInfo, this.scale);
                outputOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(typeInfo);
                if (this.constantScale) break;
                throw new UDFArgumentTypeException(1, this.getFuncName().toUpperCase() + " scale argument for decimal must be constant");
            }
            case VOID: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                outputOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(this.inputType);
                break;
            }
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                outputOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(PrimitiveObjectInspector.PrimitiveCategory.DOUBLE);
                this.converterFromString = ObjectInspectorConverters.getConverter((ObjectInspector)this.inputOI, (ObjectInspector)outputOI);
                break;
            }
            default: {
                throw new UDFArgumentTypeException(0, "Only numeric or string group data types are allowed for ROUND function. Got " + this.inputType.name());
            }
        }
        return outputOI;
    }

    private static DecimalTypeInfo getOutputTypeInfo(DecimalTypeInfo inputTypeInfo, int dec) {
        int prec = inputTypeInfo.precision();
        int scale = inputTypeInfo.scale();
        int intParts = prec - scale;
        int newIntParts = dec < scale ? intParts + 1 : intParts;
        int newScale = dec < 0 ? 0 : Math.min(dec, 38);
        int newPrec = Math.min(newIntParts + newScale, 38);
        return TypeInfoFactory.getDecimalTypeInfo(newPrec, newScale);
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (arguments.length == 2 && (arguments[1] == null || arguments[1].get() == null)) {
            return null;
        }
        if (arguments[0] == null) {
            return null;
        }
        Object input = arguments[0].get();
        if (input == null) {
            return null;
        }
        switch (this.inputType) {
            case VOID: {
                return null;
            }
            case DECIMAL: {
                HiveDecimalWritable decimalWritable = (HiveDecimalWritable)this.inputOI.getPrimitiveWritableObject(input);
                return this.round(decimalWritable, this.scale);
            }
            case BYTE: {
                ByteWritable byteWritable = (ByteWritable)((Object)this.inputOI.getPrimitiveWritableObject(input));
                if (!this.constantScale) {
                    this.scale = ((Number)this.scaleOI.getPrimitiveJavaObject(arguments[1].get())).intValue();
                }
                if (this.scale >= 0) {
                    return byteWritable;
                }
                return new ByteWritable((byte)this.round(byteWritable.get(), this.scale));
            }
            case SHORT: {
                ShortWritable shortWritable = (ShortWritable)this.inputOI.getPrimitiveWritableObject(input);
                if (!this.constantScale) {
                    this.scale = ((Number)this.scaleOI.getPrimitiveJavaObject(arguments[1].get())).intValue();
                }
                if (this.scale >= 0) {
                    return shortWritable;
                }
                return new ShortWritable((short)this.round(shortWritable.get(), this.scale));
            }
            case INT: {
                IntWritable intWritable = (IntWritable)this.inputOI.getPrimitiveWritableObject(input);
                if (!this.constantScale) {
                    this.scale = ((Number)this.scaleOI.getPrimitiveJavaObject(arguments[1].get())).intValue();
                }
                if (this.scale >= 0) {
                    return intWritable;
                }
                return new IntWritable((int)this.round(intWritable.get(), this.scale));
            }
            case LONG: {
                LongWritable longWritable = (LongWritable)this.inputOI.getPrimitiveWritableObject(input);
                if (!this.constantScale) {
                    this.scale = ((Number)this.scaleOI.getPrimitiveJavaObject(arguments[1].get())).intValue();
                }
                if (this.scale >= 0) {
                    return longWritable;
                }
                return new LongWritable(this.round(longWritable.get(), this.scale));
            }
            case FLOAT: {
                float f = ((FloatWritable)this.inputOI.getPrimitiveWritableObject(input)).get();
                if (!this.constantScale) {
                    this.scale = ((Number)this.scaleOI.getPrimitiveJavaObject(arguments[1].get())).intValue();
                }
                return new FloatWritable((float)this.round(f, this.scale));
            }
            case DOUBLE: {
                if (!this.constantScale) {
                    this.scale = ((Number)this.scaleOI.getPrimitiveJavaObject(arguments[1].get())).intValue();
                }
                return this.round((DoubleWritable)((Object)this.inputOI.getPrimitiveWritableObject(input)), this.scale);
            }
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                DoubleWritable doubleValue = (DoubleWritable)((Object)this.converterFromString.convert(input));
                if (doubleValue == null) {
                    return null;
                }
                if (!this.constantScale) {
                    this.scale = ((Number)this.scaleOI.getPrimitiveJavaObject(arguments[1].get())).intValue();
                }
                return this.round(doubleValue, this.scale);
            }
        }
        throw new UDFArgumentTypeException(0, "Only numeric or string group data types are allowed for ROUND function. Got " + this.inputType.name());
    }

    protected HiveDecimalWritable round(HiveDecimalWritable inputDecWritable, int scale) {
        HiveDecimalWritable result = new HiveDecimalWritable(inputDecWritable);
        result.mutateSetScale(scale, 4);
        return result;
    }

    protected long round(long input, int scale) {
        return RoundUtils.round(input, scale);
    }

    protected double round(double input, int scale) {
        return RoundUtils.round(input, scale);
    }

    protected DoubleWritable round(DoubleWritable input, int scale) {
        double d = input.get();
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return new DoubleWritable(d);
        }
        return new DoubleWritable(RoundUtils.round(d, scale));
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("round", children);
    }
}

