/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;

public class NullScanFileSystem
extends FileSystem {
    private final Token<?>[] DEFAULT_EMPTY_TOKEN_ARRAY = new Token[0];

    public static String getBase() {
        return NullScanFileSystem.getBaseScheme() + "://null/";
    }

    public static String getBaseScheme() {
        return "nullscan";
    }

    public String getScheme() {
        return NullScanFileSystem.getBaseScheme();
    }

    public URI getUri() {
        try {
            return new URI(NullScanFileSystem.getBase());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        throw new UnsupportedOperationException("Not supported");
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException("Not supported");
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException("Not supported");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return true;
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        throw new UnsupportedOperationException("Not supported");
    }

    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        return new FileStatus[]{new FileStatus(0L, false, 0, 0L, 0L, new Path(f, "null"))};
    }

    public void setWorkingDirectory(Path new_dir) {
    }

    public Path getWorkingDirectory() {
        return new Path(NullScanFileSystem.getBase());
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        throw new UnsupportedOperationException("Not supported");
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        return new FileStatus(0L, false, 0, 0L, 0L, f);
    }

    public Token<?>[] addDelegationTokens(String renewer, Credentials credentials) throws IOException {
        return this.DEFAULT_EMPTY_TOKEN_ARRAY;
    }

    public Token<?> getDelegationToken(String renewer) throws IOException {
        return null;
    }
}

