/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.worker;

import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SequenceValidator {
    private static final Logger LOG = LoggerFactory.getLogger(SequenceValidator.class);
    private Long lastWriteId;
    private Long lastRowId;

    SequenceValidator() {
    }

    boolean isInSequence(RecordIdentifier recordIdentifier) {
        if (this.lastWriteId != null && recordIdentifier.getWriteId() < this.lastWriteId) {
            LOG.debug("Non-sequential write ID. Expected >{}, recordIdentifier={}", (Object)this.lastWriteId, (Object)recordIdentifier);
            return false;
        }
        if (this.lastWriteId != null && recordIdentifier.getWriteId() == this.lastWriteId.longValue() && this.lastRowId != null && recordIdentifier.getRowId() <= this.lastRowId) {
            LOG.debug("Non-sequential row ID. Expected >{}, recordIdentifier={}", (Object)this.lastRowId, (Object)recordIdentifier);
            return false;
        }
        this.lastWriteId = recordIdentifier.getWriteId();
        this.lastRowId = recordIdentifier.getRowId();
        return true;
    }

    void reset() {
        this.lastWriteId = null;
        this.lastRowId = null;
        LOG.debug("reset");
    }

    public String toString() {
        return "SequenceValidator [lastWriteId=" + this.lastWriteId + ", lastRowId=" + this.lastRowId + "]";
    }
}

