/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.windowing;

import java.util.List;
import java.util.Map;
import org.apache.storm.shade.com.google.common.collect.Lists;
import org.apache.storm.shade.org.apache.commons.lang.IllegalClassException;
import org.apache.storm.topology.FailedException;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.operation.TridentOperationContext;
import org.apache.storm.trident.state.StateUpdater;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.trident.windowing.WindowTridentProcessor;
import org.apache.storm.trident.windowing.WindowsState;
import org.apache.storm.trident.windowing.WindowsStore;
import org.apache.storm.trident.windowing.WindowsStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsStateUpdater
implements StateUpdater<WindowsState> {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsStateUpdater.class);
    private final WindowsStoreFactory windowStoreFactory;
    private WindowsStore windowsStore;

    public WindowsStateUpdater(WindowsStoreFactory windowStoreFactory) {
        this.windowStoreFactory = windowStoreFactory;
    }

    @Override
    public void updateState(WindowsState state, List<TridentTuple> tuples, TridentCollector collector) {
        Long currentTxId = state.getCurrentTxId();
        LOG.debug("Removing triggers using WindowStateUpdater, txnId: [{}] ", (Object)currentTxId);
        for (TridentTuple tuple : tuples) {
            try {
                Object fieldValue = tuple.getValueByField("_task_info");
                if (!(fieldValue instanceof WindowTridentProcessor.TriggerInfo)) {
                    throw new IllegalClassException(WindowTridentProcessor.TriggerInfo.class, fieldValue.getClass());
                }
                WindowTridentProcessor.TriggerInfo triggerInfo = (WindowTridentProcessor.TriggerInfo)fieldValue;
                String triggerCompletedKey = WindowTridentProcessor.getWindowTriggerInprocessIdPrefix(triggerInfo.windowTaskId) + currentTxId;
                LOG.debug("Removing trigger key [{}] and trigger completed key [{}] from store: [{}]", new Object[]{triggerInfo, triggerCompletedKey, this.windowsStore});
                this.windowsStore.removeAll(Lists.newArrayList((Object[])new String[]{triggerInfo.generateTriggerKey(), triggerCompletedKey}));
            }
            catch (Exception ex) {
                LOG.warn(ex.getMessage());
                collector.reportError(ex);
                throw new FailedException(ex);
            }
        }
    }

    @Override
    public void prepare(Map<String, Object> conf, TridentOperationContext context) {
        this.windowsStore = this.windowStoreFactory.create(conf);
    }

    @Override
    public void cleanup() {
        this.windowsStore.shutdown();
    }
}

