/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.spout;

public class CheckPointState {
    private long txid;
    private State state;

    public CheckPointState(long txid, State state) {
        this.txid = txid;
        this.state = state;
    }

    public CheckPointState() {
    }

    public long getTxid() {
        return this.txid;
    }

    public State getState() {
        return this.state;
    }

    public CheckPointState nextState(boolean recovering) {
        CheckPointState nextState;
        switch (this.state) {
            case PREPARING: {
                nextState = recovering ? new CheckPointState(this.txid - 1L, State.COMMITTED) : new CheckPointState(this.txid, State.COMMITTING);
                break;
            }
            case COMMITTING: {
                nextState = new CheckPointState(this.txid, State.COMMITTED);
                break;
            }
            case COMMITTED: {
                nextState = recovering ? this : new CheckPointState(this.txid + 1L, State.PREPARING);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state " + this.state);
            }
        }
        return nextState;
    }

    public Action nextAction(boolean recovering) {
        Action action;
        switch (this.state) {
            case PREPARING: {
                action = recovering ? Action.ROLLBACK : Action.PREPARE;
                break;
            }
            case COMMITTING: {
                action = Action.COMMIT;
                break;
            }
            case COMMITTED: {
                action = recovering ? Action.INITSTATE : Action.PREPARE;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state " + this.state);
            }
        }
        return action;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckPointState that = (CheckPointState)o;
        if (this.txid != that.txid) {
            return false;
        }
        return this.state == that.state;
    }

    public int hashCode() {
        int result2 = (int)(this.txid ^ this.txid >>> 32);
        result2 = 31 * result2 + (this.state != null ? this.state.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "CheckPointState{txid=" + this.txid + ", state=" + this.state + "}";
    }

    public static enum State {
        COMMITTED,
        COMMITTING,
        PREPARING;

    }

    public static enum Action {
        PREPARE,
        COMMIT,
        ROLLBACK,
        INITSTATE;

    }
}

