/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util.resource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.codehaus.janino.util.resource.Resource;
import org.codehaus.janino.util.resource.ResourceFinder;

public class MapResourceFinder
extends ResourceFinder {
    private final Map<String, byte[]> map;
    private long lastModified;

    public MapResourceFinder(Map<String, byte[]> map) {
        this.map = map;
    }

    public final void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    @Override
    public final Resource findResource(final String resourceName) {
        final byte[] ba = this.map.get(resourceName);
        if (ba == null) {
            return null;
        }
        return new Resource(){

            @Override
            public InputStream open() {
                return new ByteArrayInputStream(ba);
            }

            @Override
            public String getFileName() {
                return resourceName;
            }

            @Override
            public long lastModified() {
                return MapResourceFinder.this.lastModified;
            }
        };
    }
}

