/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.logviewer.webapp;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.storm.daemon.common.JsonResponseBuilder;
import org.apache.storm.daemon.logviewer.handler.LogviewerLogDownloadHandler;
import org.apache.storm.daemon.logviewer.handler.LogviewerLogPageHandler;
import org.apache.storm.daemon.logviewer.handler.LogviewerLogSearchHandler;
import org.apache.storm.daemon.logviewer.handler.LogviewerProfileHandler;
import org.apache.storm.daemon.ui.InvalidRequestException;
import org.apache.storm.daemon.ui.UIHelpers;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.security.auth.IHttpCredentialsPlugin;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class LogviewerResource {
    private static final Logger LOG = LoggerFactory.getLogger(LogviewerResource.class);
    private final Meter meterLogPageHttpRequests;
    private final Meter meterDaemonLogPageHttpRequests;
    private final Meter meterDownloadLogFileHttpRequests;
    private final Meter meterDownloadLogDaemonFileHttpRequests;
    private final Meter meterListLogsHttpRequests;
    private final Meter numSearchLogRequests;
    private final Meter numDeepSearchArchived;
    private final Meter numDeepSearchNonArchived;
    private final Meter numReadLogExceptions;
    private final Meter numReadDaemonLogExceptions;
    private final Meter numListLogExceptions;
    private final Meter numListDumpExceptions;
    private final Meter numDownloadDumpExceptions;
    private final Meter numDownloadLogExceptions;
    private final Meter numDownloadDaemonLogExceptions;
    private final Meter numSearchExceptions;
    private final Timer searchLogRequestDuration;
    private final Timer deepSearchRequestDuration;
    private final LogviewerLogPageHandler logviewer;
    private final LogviewerProfileHandler profileHandler;
    private final LogviewerLogDownloadHandler logDownloadHandler;
    private final LogviewerLogSearchHandler logSearchHandler;
    private final IHttpCredentialsPlugin httpCredsHandler;

    public LogviewerResource(LogviewerLogPageHandler logviewerParam, LogviewerProfileHandler profileHandler, LogviewerLogDownloadHandler logDownloadHandler, LogviewerLogSearchHandler logSearchHandler, IHttpCredentialsPlugin httpCredsHandler, StormMetricsRegistry metricsRegistry) {
        this.meterLogPageHttpRequests = metricsRegistry.registerMeter("logviewer:num-log-page-http-requests");
        this.meterDaemonLogPageHttpRequests = metricsRegistry.registerMeter("logviewer:num-daemonlog-page-http-requests");
        this.meterDownloadLogFileHttpRequests = metricsRegistry.registerMeter("logviewer:num-download-log-file-http-requests");
        this.meterDownloadLogDaemonFileHttpRequests = metricsRegistry.registerMeter("logviewer:num-download-log-daemon-file-http-requests");
        this.meterListLogsHttpRequests = metricsRegistry.registerMeter("logviewer:num-list-logs-http-requests");
        this.numSearchLogRequests = metricsRegistry.registerMeter("logviewer:num-search-logs-requests");
        this.numDeepSearchArchived = metricsRegistry.registerMeter("logviewer:num-deep-search-requests-with-archived");
        this.numDeepSearchNonArchived = metricsRegistry.registerMeter("logviewer:num-deep-search-requests-without-archived");
        this.numReadLogExceptions = metricsRegistry.registerMeter("logviewer:num-read-log-exceptions");
        this.numReadDaemonLogExceptions = metricsRegistry.registerMeter("logviewer:num-read-daemon-log-exceptions");
        this.numListLogExceptions = metricsRegistry.registerMeter("logviewer:num-search-log-exceptions");
        this.numListDumpExceptions = metricsRegistry.registerMeter("logviewer:num-list-dump-files-exceptions");
        this.numDownloadDumpExceptions = metricsRegistry.registerMeter("logviewer:num-download-dump-exceptions");
        this.numDownloadLogExceptions = metricsRegistry.registerMeter("logviewer:num-download-log-exceptions");
        this.numDownloadDaemonLogExceptions = metricsRegistry.registerMeter("logviewer:num-download-daemon-log-exceptions");
        this.numSearchExceptions = metricsRegistry.registerMeter("logviewer:num-search-exceptions");
        this.searchLogRequestDuration = metricsRegistry.registerTimer("logviewer:search-requests-duration-ms");
        this.deepSearchRequestDuration = metricsRegistry.registerTimer("logviewer:deep-search-request-duration-ms");
        this.logviewer = logviewerParam;
        this.profileHandler = profileHandler;
        this.logDownloadHandler = logDownloadHandler;
        this.logSearchHandler = logSearchHandler;
        this.httpCredsHandler = httpCredsHandler;
    }

    @GET
    @Path(value="/log")
    public Response log(@Context HttpServletRequest request) throws IOException {
        this.meterLogPageHttpRequests.mark();
        try {
            String user = this.httpCredsHandler.getUserName(request);
            Integer start = request.getParameter("start") != null ? Integer.valueOf(this.parseIntegerFromMap(request.getParameterMap(), "start")) : null;
            Integer length = request.getParameter("length") != null ? Integer.valueOf(this.parseIntegerFromMap(request.getParameterMap(), "length")) : null;
            String decodedFileName = Utils.urlDecodeUtf8((String)request.getParameter("file"));
            String grep = request.getParameter("grep");
            return this.logviewer.logPage(decodedFileName, start, length, grep, user);
        }
        catch (InvalidRequestException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return Response.status((int)400).entity((Object)e.getMessage()).build();
        }
        catch (IOException e) {
            this.numReadLogExceptions.mark();
            throw e;
        }
    }

    @GET
    @Path(value="/daemonlog")
    public Response daemonLog(@Context HttpServletRequest request) throws IOException {
        this.meterDaemonLogPageHttpRequests.mark();
        try {
            String user = this.httpCredsHandler.getUserName(request);
            Integer start = request.getParameter("start") != null ? Integer.valueOf(this.parseIntegerFromMap(request.getParameterMap(), "start")) : null;
            Integer length = request.getParameter("length") != null ? Integer.valueOf(this.parseIntegerFromMap(request.getParameterMap(), "length")) : null;
            String decodedFileName = Utils.urlDecodeUtf8((String)request.getParameter("file"));
            String grep = request.getParameter("grep");
            return this.logviewer.daemonLogPage(decodedFileName, start, length, grep, user);
        }
        catch (InvalidRequestException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return Response.status((int)400).entity((Object)e.getMessage()).build();
        }
        catch (IOException e) {
            this.numReadDaemonLogExceptions.mark();
            throw e;
        }
    }

    @GET
    @Path(value="/searchLogs")
    public Response searchLogs(@Context HttpServletRequest request) throws IOException {
        String user = this.httpCredsHandler.getUserName(request);
        String topologyId = request.getParameter("topoId");
        String portStr = request.getParameter("port");
        String callback = request.getParameter("callbackParameterName");
        String origin = request.getHeader("Origin");
        return this.logviewer.listLogFiles(user, portStr != null ? Integer.valueOf(Integer.parseInt(portStr)) : null, topologyId, callback, origin);
    }

    @GET
    @Path(value="/listLogs")
    public Response listLogs(@Context HttpServletRequest request) throws IOException {
        this.meterListLogsHttpRequests.mark();
        String user = this.httpCredsHandler.getUserName(request);
        String topologyId = request.getParameter("topoId");
        String portStr = request.getParameter("port");
        String callback = request.getParameter("callback");
        String origin = request.getHeader("Origin");
        try {
            return this.logviewer.listLogFiles(user, portStr != null ? Integer.valueOf(Integer.parseInt(portStr)) : null, topologyId, callback, origin);
        }
        catch (IOException e) {
            this.numListLogExceptions.mark();
            throw e;
        }
    }

    @GET
    @Path(value="/dumps/{topo-id}/{host-port}")
    public Response listDumpFiles(@PathParam(value="topo-id") String topologyId, @PathParam(value="host-port") String hostPort, @Context HttpServletRequest request) throws IOException {
        String user = this.httpCredsHandler.getUserName(request);
        try {
            return this.profileHandler.listDumpFiles(topologyId, hostPort, user);
        }
        catch (IOException e) {
            this.numListDumpExceptions.mark();
            throw e;
        }
    }

    @GET
    @Path(value="/dumps/{topo-id}/{host-port}/{filename}")
    public Response downloadDumpFile(@PathParam(value="topo-id") String topologyId, @PathParam(value="host-port") String hostPort, @PathParam(value="filename") String fileName, @Context HttpServletRequest request) throws IOException {
        String user = this.httpCredsHandler.getUserName(request);
        try {
            return this.profileHandler.downloadDumpFile(topologyId, hostPort, fileName, user);
        }
        catch (IOException e) {
            this.numDownloadDumpExceptions.mark();
            throw e;
        }
    }

    @GET
    @Path(value="/download")
    public Response downloadLogFile(@Context HttpServletRequest request) throws IOException {
        this.meterDownloadLogFileHttpRequests.mark();
        String user = this.httpCredsHandler.getUserName(request);
        String file = request.getParameter("file");
        String decodedFileName = Utils.urlDecodeUtf8((String)file);
        try {
            String host = Utils.hostname();
            return this.logDownloadHandler.downloadLogFile(host, decodedFileName, user);
        }
        catch (IOException e) {
            this.numDownloadLogExceptions.mark();
            throw e;
        }
    }

    @GET
    @Path(value="/daemondownload")
    public Response downloadDaemonLogFile(@Context HttpServletRequest request) throws IOException {
        this.meterDownloadLogDaemonFileHttpRequests.mark();
        String user = this.httpCredsHandler.getUserName(request);
        String file = request.getParameter("file");
        String decodedFileName = Utils.urlDecodeUtf8((String)file);
        try {
            String host = Utils.hostname();
            return this.logDownloadHandler.downloadDaemonLogFile(host, decodedFileName, user);
        }
        catch (IOException e) {
            this.numDownloadDaemonLogExceptions.mark();
            throw e;
        }
    }

    @GET
    @Path(value="/search")
    public Response search(@Context HttpServletRequest request) throws IOException {
        Response response;
        block9: {
            this.numSearchLogRequests.mark();
            String user = this.httpCredsHandler.getUserName(request);
            boolean isDaemon = StringUtils.equals((String)request.getParameter("is-daemon"), (String)"yes");
            String file = request.getParameter("file");
            String decodedFileName = Utils.urlDecodeUtf8((String)file);
            String searchString = request.getParameter("search-string");
            String numMatchesStr = request.getParameter("num-matches");
            String startByteOffset = request.getParameter("start-byte-offset");
            String callback = request.getParameter("callback");
            String origin = request.getHeader("Origin");
            Timer.Context t = this.searchLogRequestDuration.time();
            try {
                response = this.logSearchHandler.searchLogFile(decodedFileName, user, isDaemon, searchString, numMatchesStr, startByteOffset, callback, origin);
                if (t == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidRequestException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    int statusCode = 400;
                    return new JsonResponseBuilder().setData(UIHelpers.exceptionToJson(e, statusCode)).setCallback(callback).setStatus(statusCode).build();
                }
                catch (IOException e) {
                    this.numSearchExceptions.mark();
                    throw e;
                }
            }
            t.close();
        }
        return response;
    }

    @GET
    @Path(value="/deepSearch/{topoId}")
    public Response deepSearch(@PathParam(value="topoId") String topologyId, @Context HttpServletRequest request) throws IOException {
        String user = this.httpCredsHandler.getUserName(request);
        String searchString = request.getParameter("search-string");
        String numMatchesStr = request.getParameter("num-matches");
        String portStr = request.getParameter("port");
        String startFileOffset = request.getParameter("start-file-offset");
        String startByteOffset = request.getParameter("start-byte-offset");
        String searchArchived = request.getParameter("search-archived");
        String callback = request.getParameter("callback");
        String origin = request.getHeader("Origin");
        Boolean alsoSearchArchived = BooleanUtils.toBooleanObject((String)searchArchived);
        if (BooleanUtils.isTrue((Boolean)alsoSearchArchived)) {
            this.numDeepSearchArchived.mark();
        } else {
            this.numDeepSearchNonArchived.mark();
        }
        try (Timer.Context t = this.deepSearchRequestDuration.time();){
            Response response = this.logSearchHandler.deepSearchLogsForTopology(topologyId, user, searchString, numMatchesStr, portStr, startFileOffset, startByteOffset, alsoSearchArchived, callback, origin);
            return response;
        }
    }

    private int parseIntegerFromMap(Map<String, String[]> map, String parameterKey) throws InvalidRequestException {
        try {
            return Integer.parseInt(map.get(parameterKey)[0]);
        }
        catch (NumberFormatException ex) {
            throw new InvalidRequestException("Could not make an integer out of the query parameter '" + parameterKey + "'", ex);
        }
    }
}

