/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.IndexBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockIndexChunk;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.BlockWithScanInfo;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.HFileIndexBlockEncoder;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class NoOpIndexBlockEncoder
implements HFileIndexBlockEncoder {
    public static final NoOpIndexBlockEncoder INSTANCE = new NoOpIndexBlockEncoder();

    private NoOpIndexBlockEncoder() {
    }

    @Override
    public void saveMetadata(HFile.Writer writer) {
    }

    @Override
    public void encode(BlockIndexChunk blockIndexChunk, boolean rootIndexBlock, DataOutput out) throws IOException {
        if (rootIndexBlock) {
            this.writeRoot(blockIndexChunk, out);
        } else {
            this.writeNonRoot(blockIndexChunk, out);
        }
    }

    private void writeNonRoot(BlockIndexChunk blockIndexChunk, DataOutput out) throws IOException {
        out.writeInt(blockIndexChunk.getNumEntries());
        if (blockIndexChunk.getSecondaryIndexOffsetMarks().size() != blockIndexChunk.getBlockKeys().size()) {
            throw new IOException("Corrupted block index chunk writer: " + blockIndexChunk.getBlockKeys().size() + " entries but " + blockIndexChunk.getSecondaryIndexOffsetMarks().size() + " secondary index items");
        }
        for (int currentSecondaryIndex : blockIndexChunk.getSecondaryIndexOffsetMarks()) {
            out.writeInt(currentSecondaryIndex);
        }
        out.writeInt(blockIndexChunk.getCurTotalNonRootEntrySize());
        for (int i = 0; i < blockIndexChunk.getNumEntries(); ++i) {
            out.writeLong(blockIndexChunk.getBlockOffset(i));
            out.writeInt(blockIndexChunk.getOnDiskDataSize(i));
            out.write(blockIndexChunk.getBlockKey(i));
        }
    }

    private void writeRoot(BlockIndexChunk blockIndexChunk, DataOutput out) throws IOException {
        for (int i = 0; i < blockIndexChunk.getNumEntries(); ++i) {
            out.writeLong(blockIndexChunk.getBlockOffset(i));
            out.writeInt(blockIndexChunk.getOnDiskDataSize(i));
            Bytes.writeByteArray((DataOutput)out, (byte[])blockIndexChunk.getBlockKey(i));
        }
    }

    @Override
    public IndexBlockEncoding getIndexBlockEncoding() {
        return IndexBlockEncoding.NONE;
    }

    @Override
    public HFileIndexBlockEncoder.EncodedSeeker createSeeker() {
        return new NoOpEncodedSeeker();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected static class NoOpEncodedSeeker
    implements HFileIndexBlockEncoder.EncodedSeeker {
        protected long[] blockOffsets;
        protected int[] blockDataSizes;
        protected int rootCount = 0;
        protected long midLeafBlockOffset = -1L;
        protected int midLeafBlockOnDiskSize = -1;
        protected int midKeyEntry = -1;
        private Cell[] blockKeys;
        private CellComparator comparator;
        protected int searchTreeLevel;
        private AtomicReference<Cell> midKey = new AtomicReference();

        protected NoOpEncodedSeeker() {
        }

        public long heapSize() {
            long heapSize = ClassSize.align((int)ClassSize.OBJECT);
            heapSize += 16L;
            if (this.blockOffsets != null) {
                heapSize += (long)ClassSize.align((int)(ClassSize.ARRAY + this.blockOffsets.length * 8));
            }
            if (this.blockDataSizes != null) {
                heapSize += (long)ClassSize.align((int)(ClassSize.ARRAY + this.blockDataSizes.length * 4));
            }
            if (this.blockKeys != null) {
                heapSize += (long)ClassSize.REFERENCE;
                heapSize += (long)ClassSize.align((int)(ClassSize.ARRAY + this.blockKeys.length * ClassSize.REFERENCE));
                for (Cell key : this.blockKeys) {
                    heapSize += ClassSize.align((long)key.heapSize());
                }
            }
            heapSize += (long)(2 * ClassSize.REFERENCE);
            return ClassSize.align((long)(heapSize += 8L));
        }

        @Override
        public boolean isEmpty() {
            return this.blockKeys.length == 0;
        }

        @Override
        public Cell getRootBlockKey(int i) {
            return this.blockKeys[i];
        }

        @Override
        public int getRootBlockCount() {
            return this.rootCount;
        }

        @Override
        public void initRootIndex(HFileBlock blk, int numEntries, CellComparator comparator, int treeLevel) throws IOException {
            this.comparator = comparator;
            this.searchTreeLevel = treeLevel;
            this.init(blk, numEntries);
        }

        private void init(HFileBlock blk, int numEntries) throws IOException {
            DataInputStream in = this.readRootIndex(blk, numEntries);
            if (in.available() < 16) {
                return;
            }
            this.midLeafBlockOffset = in.readLong();
            this.midLeafBlockOnDiskSize = in.readInt();
            this.midKeyEntry = in.readInt();
        }

        private DataInputStream readRootIndex(HFileBlock blk, int numEntries) throws IOException {
            DataInputStream in = blk.getByteStream();
            this.readRootIndex(in, numEntries);
            return in;
        }

        private void readRootIndex(DataInput in, int numEntries) throws IOException {
            this.blockOffsets = new long[numEntries];
            this.initialize(numEntries);
            this.blockDataSizes = new int[numEntries];
            if (numEntries > 0) {
                for (int i = 0; i < numEntries; ++i) {
                    long offset = in.readLong();
                    int dataSize = in.readInt();
                    byte[] key = Bytes.readByteArray((DataInput)in);
                    this.add(key, offset, dataSize);
                }
            }
        }

        private void initialize(int numEntries) {
            this.blockKeys = new Cell[numEntries];
        }

        private void add(byte[] key, long offset, int dataSize) {
            this.blockOffsets[this.rootCount] = offset;
            this.blockKeys[this.rootCount] = new KeyValue.KeyOnlyKeyValue(key, 0, key.length);
            this.blockDataSizes[this.rootCount] = dataSize;
            ++this.rootCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Cell midkey(HFile.CachingBlockReader cachingBlockReader) throws IOException {
            if (this.rootCount == 0) {
                throw new IOException("HFile empty");
            }
            Cell targetMidKey = this.midKey.get();
            if (targetMidKey != null) {
                return targetMidKey;
            }
            if (this.midLeafBlockOffset >= 0L) {
                if (cachingBlockReader == null) {
                    throw new IOException("Have to read the middle leaf block but no block reader available");
                }
                HFileBlock midLeafBlock = cachingBlockReader.readBlock(this.midLeafBlockOffset, this.midLeafBlockOnDiskSize, true, true, false, true, BlockType.LEAF_INDEX, null);
                try {
                    ByteBuff b = midLeafBlock.getBufferWithoutHeader();
                    int numDataBlocks = b.getIntAfterPosition(0);
                    int keyRelOffset = b.getIntAfterPosition(4 * (this.midKeyEntry + 1));
                    int keyLen = b.getIntAfterPosition(4 * (this.midKeyEntry + 2)) - keyRelOffset - 12;
                    int keyOffset = 4 * (numDataBlocks + 2) + keyRelOffset + 12;
                    byte[] bytes = b.toBytes(keyOffset, keyLen);
                    targetMidKey = new KeyValue.KeyOnlyKeyValue(bytes, 0, bytes.length);
                }
                finally {
                    midLeafBlock.release();
                }
            } else {
                targetMidKey = this.blockKeys[this.rootCount / 2];
            }
            this.midKey.set(targetMidKey);
            return targetMidKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BlockWithScanInfo loadDataBlockWithScanInfo(Cell key, HFileBlock currentBlock, boolean cacheBlocks, boolean pread, boolean isCompaction, DataBlockEncoding expectedDataBlockEncoding, HFile.CachingBlockReader cachingBlockReader) throws IOException {
            int rootLevelIndex = this.rootBlockContainingKey(key);
            if (rootLevelIndex < 0 || rootLevelIndex >= this.blockOffsets.length) {
                return null;
            }
            Cell nextIndexedKey = null;
            long currentOffset = this.blockOffsets[rootLevelIndex];
            int currentOnDiskSize = this.blockDataSizes[rootLevelIndex];
            nextIndexedKey = rootLevelIndex < this.blockKeys.length - 1 ? this.blockKeys[rootLevelIndex + 1] : KeyValueScanner.NO_NEXT_INDEXED_KEY;
            int lookupLevel = 1;
            int index = -1;
            HFileBlock block = null;
            KeyValue.KeyOnlyKeyValue tmpNextIndexKV = new KeyValue.KeyOnlyKeyValue();
            while (true) {
                try {
                    block = null;
                    if (currentBlock != null && currentBlock.getOffset() == currentOffset) {
                        block = currentBlock;
                    } else {
                        boolean shouldCache;
                        boolean bl = shouldCache = cacheBlocks || lookupLevel < this.searchTreeLevel;
                        BlockType expectedBlockType = lookupLevel < this.searchTreeLevel - 1 ? BlockType.INTERMEDIATE_INDEX : (lookupLevel == this.searchTreeLevel - 1 ? BlockType.LEAF_INDEX : BlockType.DATA);
                        block = cachingBlockReader.readBlock(currentOffset, currentOnDiskSize, shouldCache, pread, isCompaction, true, expectedBlockType, expectedDataBlockEncoding);
                    }
                    if (block == null) {
                        throw new IOException("Failed to read block at offset " + currentOffset + ", onDiskSize=" + currentOnDiskSize);
                    }
                    if (block.getBlockType().isData()) break;
                    if (++lookupLevel > this.searchTreeLevel) {
                        throw new IOException("Search Tree Level overflow: lookupLevel=" + lookupLevel + ", searchTreeLevel=" + this.searchTreeLevel);
                    }
                    ByteBuff buffer = block.getBufferWithoutHeader();
                    index = HFileBlockIndex.BlockIndexReader.locateNonRootIndexEntry(buffer, key, this.comparator);
                    if (index == -1) {
                        throw new IOException("The key " + CellUtil.getCellKeyAsString((Cell)key) + " is before the first key of the non-root index block " + block);
                    }
                    currentOffset = buffer.getLong();
                    currentOnDiskSize = buffer.getInt();
                    byte[] nonRootIndexedKey = this.getNonRootIndexedKey(buffer, index + 1);
                    if (nonRootIndexedKey == null) continue;
                    tmpNextIndexKV.setKey(nonRootIndexedKey, 0, nonRootIndexedKey.length);
                    nextIndexedKey = tmpNextIndexKV;
                    continue;
                }
                finally {
                    if (block == null || block.getBlockType().isData()) continue;
                    block.release();
                    continue;
                }
                break;
            }
            if (lookupLevel != this.searchTreeLevel) {
                assert (block.getBlockType().isData());
                if (block != null) {
                    block.release();
                }
                throw new IOException("Reached a data block at level " + lookupLevel + " but the number of levels is " + this.searchTreeLevel);
            }
            return new BlockWithScanInfo(block, nextIndexedKey);
        }

        @Override
        public int rootBlockContainingKey(Cell key) {
            int pos = Bytes.binarySearch((Cell[])this.blockKeys, (Cell)key, (CellComparator)this.comparator);
            if (pos >= 0) {
                assert (pos < this.blockKeys.length);
                return pos;
            }
            int i = -pos - 1;
            assert (0 <= i && i <= this.blockKeys.length);
            return i - 1;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("size=" + this.rootCount).append("\n");
            for (int i = 0; i < this.rootCount; ++i) {
                sb.append("key=").append(this.blockKeys[i]).append("\n  offset=").append(this.blockOffsets[i]).append(", dataSize=" + this.blockDataSizes[i]).append("\n");
            }
            return sb.toString();
        }

        protected byte[] getNonRootIndexedKey(ByteBuff nonRootIndex, int i) {
            int numEntries = nonRootIndex.getInt(0);
            if (i < 0 || i >= numEntries) {
                return null;
            }
            int entriesOffset = 4 * (numEntries + 2);
            int targetKeyRelOffset = nonRootIndex.getInt(4 * (i + 1));
            int targetKeyOffset = entriesOffset + targetKeyRelOffset + 12;
            int targetKeyLength = nonRootIndex.getInt(4 * (i + 2)) - targetKeyRelOffset - 12;
            return nonRootIndex.toBytes(targetKeyOffset, targetKeyLength);
        }
    }
}

