/*
 * Decompiled with CFR 0.152.
 */
package j2html.tags;

import j2html.attributes.Attribute;
import j2html.tags.DomContent;
import java.util.ArrayList;

public abstract class Tag<T extends Tag<T>>
extends DomContent {
    protected String tagName;
    private ArrayList<Attribute> attributes;

    protected Tag(String tagName) {
        this.tagName = tagName;
        this.attributes = new ArrayList();
    }

    public String getTagName() {
        return this.tagName;
    }

    String renderOpenTag() {
        StringBuilder sb = new StringBuilder("<").append(this.tagName);
        for (Attribute attribute : this.attributes) {
            sb.append(attribute.render());
        }
        sb.append(">");
        return sb.toString();
    }

    String renderCloseTag() {
        return "</" + this.tagName + ">";
    }

    boolean setAttribute(String name, String value) {
        if (value == null) {
            return this.attributes.add(new Attribute(name));
        }
        for (Attribute attribute : this.attributes) {
            if (!attribute.getName().equals(name)) continue;
            attribute.setValue(value);
            return true;
        }
        return this.attributes.add(new Attribute(name, value));
    }

    public T attr(String attribute, String value) {
        this.setAttribute(attribute, value);
        return (T)this;
    }

    public T attr(String attribute) {
        return this.attr(attribute, null);
    }

    public T condAttr(boolean condition, String attribute, String value) {
        return (T)(condition ? this.attr(attribute, value) : this);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Tag)) {
            return false;
        }
        return ((Tag)obj).render().equals(this.render());
    }

    public T withClasses(String ... classes) {
        StringBuilder sb = new StringBuilder();
        for (String s : classes) {
            sb.append(s != null ? s : "").append(" ");
        }
        return this.attr("class", sb.toString().trim());
    }

    public T isAutoComplete() {
        return this.attr("autocomplete", null);
    }

    public T isAutoFocus() {
        return this.attr("autofocus", null);
    }

    public T isHidden() {
        return this.attr("hidden", null);
    }

    public T isRequired() {
        return this.attr("required", null);
    }

    public T withAlt(String alt) {
        return this.attr("alt", alt);
    }

    public T withAction(String action) {
        return this.attr("action", action);
    }

    public T withCharset(String charset) {
        return this.attr("charset", charset);
    }

    public T withClass(String className) {
        return this.attr("class", className);
    }

    public T withContent(String content) {
        return this.attr("content", content);
    }

    public T withHref(String href) {
        return this.attr("href", href);
    }

    public T withId(String id) {
        return this.attr("id", id);
    }

    public T withData(String dataAttr, String value) {
        return this.attr("data-" + dataAttr, value);
    }

    public T withMethod(String method) {
        return this.attr("method", method);
    }

    public T withName(String name) {
        return this.attr("name", name);
    }

    public T withPlaceholder(String placeholder) {
        return this.attr("placeholder", placeholder);
    }

    public T withTarget(String target) {
        return this.attr("target", target);
    }

    public T withType(String type) {
        return this.attr("type", type);
    }

    public T withRel(String rel) {
        return this.attr("rel", rel);
    }

    public T withRole(String role) {
        return this.attr("role", role);
    }

    public T withSrc(String src) {
        return this.attr("src", src);
    }

    public T withStyle(String style) {
        return this.attr("style", style);
    }

    public T withValue(String value) {
        return this.attr("value", value);
    }

    public T withCondAutoComplete(boolean condition) {
        return this.condAttr(condition, "autocomplete", null);
    }

    public T withCondAutoFocus(boolean condition) {
        return this.condAttr(condition, "autofocus", null);
    }

    public T withCondHidden(boolean condition) {
        return this.condAttr(condition, "hidden", null);
    }

    public T withCondRequired(boolean condition) {
        return this.condAttr(condition, "required", null);
    }

    public T withCondAlt(boolean condition, String alt) {
        return this.condAttr(condition, "alt", alt);
    }

    public T withCondAction(boolean condition, String action) {
        return this.condAttr(condition, "action", action);
    }

    public T withCharset(boolean condition, String charset) {
        return this.condAttr(condition, "charset", charset);
    }

    public T withCondClass(boolean condition, String className) {
        return this.condAttr(condition, "class", className);
    }

    public T withCondContent(boolean condition, String content) {
        return this.condAttr(condition, "content", content);
    }

    public T withCondHref(boolean condition, String href) {
        return this.condAttr(condition, "href", href);
    }

    public T withCondId(boolean condition, String id) {
        return this.condAttr(condition, "id", id);
    }

    public T withCondData(boolean condition, String dataAttr, String value) {
        return this.condAttr(condition, "data-" + dataAttr, value);
    }

    public T withCondMethod(boolean condition, String method) {
        return this.condAttr(condition, "method", method);
    }

    public T withCondName(boolean condition, String name) {
        return this.condAttr(condition, "name", name);
    }

    public T withCondPlaceholder(boolean condition, String placeholder) {
        return this.condAttr(condition, "placeholder", placeholder);
    }

    public T withCondTarget(boolean condition, String target) {
        return this.condAttr(condition, "target", target);
    }

    public T withCondType(boolean condition, String type) {
        return this.condAttr(condition, "type", type);
    }

    public T withCondRel(boolean condition, String rel) {
        return this.condAttr(condition, "rel", rel);
    }

    public T withCondSrc(boolean condition, String src) {
        return this.condAttr(condition, "src", src);
    }

    public T withCondStyle(boolean condition, String style) {
        return this.condAttr(condition, "style", style);
    }

    public T withCondValue(boolean condition, String value) {
        return this.condAttr(condition, "value", value);
    }
}

