/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.drpc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.drpc.DRPCInvocationsClient;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.DistributedRPCInvocations;
import org.apache.storm.shade.org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.storm.shade.org.json.simple.JSONValue;
import org.apache.storm.shade.org.json.simple.parser.ParseException;
import org.apache.storm.thrift.TException;
import org.apache.storm.thrift.transport.TTransportException;
import org.apache.storm.trident.operation.MultiReducer;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.operation.TridentMultiReducerContext;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ServiceRegistry;

public class ReturnResultsReducer
implements MultiReducer<ReturnResultsState> {
    boolean local;
    Map<String, Object> conf;
    Map<List, DRPCInvocationsClient> clients = new HashMap<List, DRPCInvocationsClient>();

    @Override
    public void prepare(Map<String, Object> conf, TridentMultiReducerContext context) {
        this.conf = conf;
        this.local = conf.get("storm.cluster.mode").equals("local");
    }

    @Override
    public ReturnResultsState init(TridentCollector collector) {
        return new ReturnResultsState();
    }

    @Override
    public void execute(ReturnResultsState state, int streamIndex, TridentTuple input, TridentCollector collector) {
        if (streamIndex == 0) {
            state.returnInfo = input.getString(0);
        } else {
            state.results.add(input);
        }
    }

    @Override
    public void complete(ReturnResultsState state, TridentCollector collector) {
        if (state.returnInfo != null) {
            DistributedRPCInvocations.Iface client;
            Map retMap;
            String result2 = JSONValue.toJSONString(state.results);
            try {
                retMap = (Map)JSONValue.parseWithException((String)state.returnInfo);
            }
            catch (ParseException e) {
                collector.reportError(e);
                return;
            }
            final String host = (String)retMap.get("host");
            final int port = ObjectReader.getInt(retMap.get("port"));
            String id = (String)retMap.get("id");
            if (this.local) {
                client = (DistributedRPCInvocations.Iface)ServiceRegistry.getService(host);
            } else {
                ArrayList server = new ArrayList(){
                    {
                        this.add(host);
                        this.add(port);
                    }
                };
                if (!this.clients.containsKey(server)) {
                    try {
                        this.clients.put(server, new DRPCInvocationsClient(this.conf, host, port));
                    }
                    catch (TTransportException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                client = this.clients.get(server);
            }
            try {
                client.result(id, result2);
            }
            catch (AuthorizationException aze) {
                collector.reportError((Throwable)((Object)aze));
            }
            catch (TException e) {
                collector.reportError(e);
            }
        }
    }

    @Override
    public void cleanup() {
        for (DRPCInvocationsClient c : this.clients.values()) {
            c.close();
        }
    }

    public static class ReturnResultsState {
        List<TridentTuple> results = new ArrayList<TridentTuple>();
        String returnInfo;

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }
}

