/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.streams;

import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import org.apache.storm.annotation.InterfaceStability;
import org.apache.storm.streams.GroupingInfo;
import org.apache.storm.streams.Node;
import org.apache.storm.streams.PairStream;
import org.apache.storm.streams.PartitionNode;
import org.apache.storm.streams.ProcessorNode;
import org.apache.storm.streams.SinkNode;
import org.apache.storm.streams.SpoutNode;
import org.apache.storm.streams.StreamBuilder;
import org.apache.storm.streams.StreamState;
import org.apache.storm.streams.UniqueIdGen;
import org.apache.storm.streams.WindowNode;
import org.apache.storm.streams.operations.BiFunction;
import org.apache.storm.streams.operations.CombinerAggregator;
import org.apache.storm.streams.operations.Consumer;
import org.apache.storm.streams.operations.FlatMapFunction;
import org.apache.storm.streams.operations.Function;
import org.apache.storm.streams.operations.IdentityFunction;
import org.apache.storm.streams.operations.PairFlatMapFunction;
import org.apache.storm.streams.operations.PairFunction;
import org.apache.storm.streams.operations.Predicate;
import org.apache.storm.streams.operations.PrintConsumer;
import org.apache.storm.streams.operations.Reducer;
import org.apache.storm.streams.operations.aggregators.Count;
import org.apache.storm.streams.processors.AggregateProcessor;
import org.apache.storm.streams.processors.BranchProcessor;
import org.apache.storm.streams.processors.FilterProcessor;
import org.apache.storm.streams.processors.FlatMapProcessor;
import org.apache.storm.streams.processors.ForEachProcessor;
import org.apache.storm.streams.processors.MapProcessor;
import org.apache.storm.streams.processors.MergeAggregateProcessor;
import org.apache.storm.streams.processors.PeekProcessor;
import org.apache.storm.streams.processors.Processor;
import org.apache.storm.streams.processors.ReduceProcessor;
import org.apache.storm.streams.processors.StateQueryProcessor;
import org.apache.storm.streams.windowing.Window;
import org.apache.storm.topology.IBasicBolt;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.tuple.Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Unstable
public class Stream<T> {
    protected static final Fields KEY = new Fields("key");
    protected static final Fields VALUE = new Fields("value");
    protected static final Fields KEY_VALUE = new Fields("key", "value");
    private static final Logger LOG = LoggerFactory.getLogger(Stream.class);
    protected final StreamBuilder streamBuilder;
    protected final Node node;
    protected final String stream;

    Stream(StreamBuilder streamBuilder, Node node) {
        this(streamBuilder, node, node.getOutputStreams().iterator().next());
    }

    private Stream(StreamBuilder streamBuilder, Node node, String stream) {
        this.streamBuilder = streamBuilder;
        this.node = node;
        this.stream = stream;
    }

    public Stream<T> filter(Predicate<? super T> predicate) {
        return new Stream<T>(this.streamBuilder, this.addProcessorNode(new FilterProcessor<T>(predicate), VALUE, true));
    }

    public <R> Stream<R> map(Function<? super T, ? extends R> function) {
        return new Stream<T>(this.streamBuilder, this.addProcessorNode(new MapProcessor<T, R>(function), VALUE));
    }

    public <K, V> PairStream<K, V> mapToPair(PairFunction<? super T, ? extends K, ? extends V> function) {
        return new PairStream(this.streamBuilder, this.addProcessorNode(new MapProcessor(function), KEY_VALUE));
    }

    public <R> Stream<R> flatMap(FlatMapFunction<? super T, ? extends R> function) {
        return new Stream<T>(this.streamBuilder, this.addProcessorNode(new FlatMapProcessor<T, R>(function), VALUE));
    }

    public <K, V> PairStream<K, V> flatMapToPair(PairFlatMapFunction<? super T, ? extends K, ? extends V> function) {
        return new PairStream(this.streamBuilder, this.addProcessorNode(new FlatMapProcessor(function), KEY_VALUE));
    }

    public Stream<T> window(Window<?, ?> window) {
        return new Stream<T>(this.streamBuilder, this.addNode(new WindowNode(window, this.stream, this.node.getOutputFields())));
    }

    public void forEach(Consumer<? super T> action) {
        this.addProcessorNode(new ForEachProcessor<T>(action), new Fields(new String[0]));
    }

    public Stream<T> peek(Consumer<? super T> action) {
        return new Stream<T>(this.streamBuilder, this.addProcessorNode(new PeekProcessor<T>(action), this.node.getOutputFields(), true));
    }

    public <A, R> Stream<R> aggregate(CombinerAggregator<? super T, A, ? extends R> aggregator) {
        return this.combine(aggregator);
    }

    public <R> Stream<R> aggregate(R initialValue, BiFunction<? super R, ? super T, ? extends R> accumulator, BiFunction<? super R, ? super R, ? extends R> combiner) {
        return this.combine(CombinerAggregator.of(initialValue, accumulator, combiner));
    }

    public Stream<Long> count() {
        return this.aggregate(new Count());
    }

    public Stream<T> reduce(Reducer<T> reducer) {
        return this.combine(reducer);
    }

    public Stream<T> repartition(int parallelism) {
        if (parallelism < 1) {
            throw new IllegalArgumentException("Parallelism should be >= 1");
        }
        if (this.node.getParallelism() == parallelism) {
            LOG.debug("Node's current parallelism {}, new parallelism {}", (Object)this.node.getParallelism(), (Object)parallelism);
            return this;
        }
        Node partitionNode = this.addNode(this.node, (Node)new PartitionNode(this.stream, this.node.getOutputFields()), parallelism);
        return new Stream<T>(this.streamBuilder, partitionNode);
    }

    public Stream<T>[] branch(Predicate<? super T> ... predicates) {
        ArrayList<Stream<T>> childStreams = new ArrayList<Stream<T>>();
        if (predicates.length > 0) {
            BranchProcessor<? super T> branchProcessor = new BranchProcessor<T>();
            Node branchNode = this.addProcessorNode(branchProcessor, VALUE);
            for (Predicate<? super T> predicate : predicates) {
                ProcessorNode child = this.makeProcessorNode(new MapProcessor(new IdentityFunction()), this.node.getOutputFields());
                String branchStream = child.getOutputStreams().iterator().next() + "-branch";
                branchNode.addOutputStream(branchStream);
                this.addNode(branchNode, (Node)child, branchStream);
                childStreams.add(new Stream<T>(this.streamBuilder, child));
                branchProcessor.addPredicate(predicate, branchStream);
            }
        }
        return childStreams.toArray(new Stream[childStreams.size()]);
    }

    public void print() {
        this.forEach(new PrintConsumer());
    }

    public void to(IRichBolt bolt) {
        this.to(bolt, 1);
    }

    public void to(IRichBolt bolt, int parallelism) {
        this.addSinkNode(new SinkNode(bolt), parallelism);
    }

    public void to(IBasicBolt bolt) {
        this.to(bolt, 1);
    }

    public void to(IBasicBolt bolt, int parallelism) {
        this.addSinkNode(new SinkNode(bolt), parallelism);
    }

    public <V> PairStream<T, V> stateQuery(StreamState<T, V> streamState) {
        Node newNode = this.partitionBy(VALUE, this.node.getParallelism()).addProcessorNode(new StateQueryProcessor<T, V>(streamState), KEY_VALUE);
        return new PairStream(this.streamBuilder, newNode);
    }

    Node getNode() {
        return this.node;
    }

    Node addNode(Node parent, Node child, int parallelism) {
        return this.streamBuilder.addNode(parent, child, parallelism);
    }

    Node addNode(Node child) {
        return this.addNode(this.node, child);
    }

    private Node addNode(Node parent, Node child) {
        return this.streamBuilder.addNode(parent, child);
    }

    private Node addNode(Node parent, Node child, String parentStreamId) {
        return this.streamBuilder.addNode(parent, child, parentStreamId);
    }

    private Node addNode(Node parent, Node child, String parentStreamId, int parallelism) {
        return this.streamBuilder.addNode(parent, child, parentStreamId, parallelism);
    }

    Node addProcessorNode(Processor<?> processor, Fields outputFields) {
        return this.addNode(this.makeProcessorNode(processor, outputFields));
    }

    Node addProcessorNode(Processor<?> processor, Fields outputFields, boolean preservesKey) {
        return this.addNode(this.makeProcessorNode(processor, outputFields, preservesKey));
    }

    String getStream() {
        return this.stream;
    }

    private ProcessorNode makeProcessorNode(Processor<?> processor, Fields outputFields) {
        return this.makeProcessorNode(processor, outputFields, false);
    }

    ProcessorNode makeProcessorNode(Processor<?> processor, Fields outputFields, boolean preservesKey) {
        return new ProcessorNode(processor, UniqueIdGen.getInstance().getUniqueStreamId(), outputFields, preservesKey);
    }

    private void addSinkNode(SinkNode sinkNode, int parallelism) {
        String boltId = UniqueIdGen.getInstance().getUniqueBoltId();
        sinkNode.setComponentId(boltId);
        sinkNode.setParallelism(parallelism);
        if (this.node instanceof SpoutNode) {
            this.addNode(this.node, sinkNode, "default", parallelism);
        } else {
            this.addNode(this.node, (Node)sinkNode, parallelism);
        }
    }

    private Stream<T> global() {
        Node partitionNode = this.addNode(new PartitionNode(this.stream, this.node.getOutputFields(), GroupingInfo.global()));
        return new Stream<T>(this.streamBuilder, partitionNode);
    }

    protected Stream<T> partitionBy(Fields fields, int parallelism) {
        return new Stream<T>(this.streamBuilder, this.addNode(this.node, (Node)new PartitionNode(this.stream, this.node.getOutputFields(), GroupingInfo.fields(fields)), parallelism));
    }

    private boolean shouldPartition() {
        return this.node.getParallelism() > 1;
    }

    private <A> Stream<A> combinePartition(CombinerAggregator<? super T, A, ?> aggregator) {
        return new Stream<T>(this.streamBuilder, this.addProcessorNode(new AggregateProcessor(aggregator, true), VALUE, true));
    }

    private <R> Stream<R> merge(CombinerAggregator<?, T, ? extends R> aggregator) {
        return new Stream<T>(this.streamBuilder, this.addProcessorNode(new MergeAggregateProcessor(aggregator), VALUE));
    }

    private <A, R> Stream<R> aggregatePartition(CombinerAggregator<? super T, A, ? extends R> aggregator) {
        return new Stream<T>(this.streamBuilder, this.addProcessorNode(new AggregateProcessor<T, A, R>(aggregator), VALUE));
    }

    private Stream<T> reducePartition(Reducer<T> reducer) {
        return new Stream<T>(this.streamBuilder, this.addProcessorNode(new ReduceProcessor<T>(reducer), VALUE));
    }

    private <A, R> Stream<R> combine(CombinerAggregator<? super T, A, ? extends R> aggregator) {
        if (this.shouldPartition()) {
            Set<Node> parents;
            Optional<Node> nonWindowed;
            if (this.node instanceof ProcessorNode) {
                if (this.node.isWindowed()) {
                    return super.merge(aggregator);
                }
            } else if (this.node instanceof WindowNode && !(nonWindowed = (parents = this.node.getParents()).stream().filter((? super T p) -> !p.isWindowed()).findAny()).isPresent()) {
                parents.forEach((? super T p) -> {
                    ProcessorNode localAggregateNode = this.makeProcessorNode(new AggregateProcessor(aggregator, true), VALUE, true);
                    this.streamBuilder.insert((Node)p, localAggregateNode);
                });
                return super.merge(aggregator);
            }
            return super.aggregatePartition(aggregator);
        }
        return this.aggregatePartition(aggregator);
    }

    private Stream<T> combine(Reducer<T> reducer) {
        if (this.shouldPartition()) {
            if (this.node instanceof ProcessorNode) {
                if (this.node.isWindowed()) {
                    return super.reducePartition(reducer);
                }
            } else if (this.node instanceof WindowNode) {
                for (Node p : this.node.getParents()) {
                    if (!p.isWindowed()) continue;
                    ProcessorNode localReduceNode = this.makeProcessorNode(new ReduceProcessor<T>(reducer), VALUE);
                    this.streamBuilder.insert(p, localReduceNode);
                }
            }
            return super.reducePartition(reducer);
        }
        return this.reducePartition(reducer);
    }
}

