/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.worker;

import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.storm.daemon.worker.WorkerState;
import org.apache.storm.messaging.TaskMessage;
import org.apache.storm.policy.IWaitStrategy;
import org.apache.storm.serialization.ITupleSerializer;
import org.apache.storm.tuple.AddressedTuple;
import org.apache.storm.utils.JCQueue;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.TransferDrainer;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerTransfer
implements JCQueue.Consumer {
    static final Logger LOG = LoggerFactory.getLogger(WorkerTransfer.class);
    private final TransferDrainer drainer;
    private final WorkerState workerState;
    private final IWaitStrategy backPressureWaitStrategy;
    private JCQueue transferQueue;
    private final AtomicBoolean[] remoteBackPressureStatus;

    public WorkerTransfer(WorkerState workerState, Map<String, Object> topologyConf, int maxTaskIdInTopo) {
        this.workerState = workerState;
        this.backPressureWaitStrategy = IWaitStrategy.createBackPressureWaitStrategy(topologyConf);
        this.drainer = new TransferDrainer();
        this.remoteBackPressureStatus = new AtomicBoolean[maxTaskIdInTopo + 1];
        for (int i = 0; i < this.remoteBackPressureStatus.length; ++i) {
            this.remoteBackPressureStatus[i] = new AtomicBoolean(false);
        }
        Integer xferQueueSz = ObjectReader.getInt(topologyConf.get("topology.transfer.buffer.size"));
        Integer xferBatchSz = ObjectReader.getInt(topologyConf.get("topology.transfer.batch.size"));
        if (xferBatchSz > xferQueueSz / 2) {
            throw new IllegalArgumentException("topology.transfer.batch.size:" + xferBatchSz + " must be no more than half of " + "topology.transfer.buffer.size" + ":" + xferQueueSz);
        }
        this.transferQueue = new JCQueue("worker-transfer-queue", "worker-transfer-queue", xferQueueSz, 0, xferBatchSz, this.backPressureWaitStrategy, workerState.getTopologyId(), "__system", Collections.singletonList(-1), workerState.getPort(), workerState.getMetricRegistry());
    }

    public JCQueue getTransferQueue() {
        return this.transferQueue;
    }

    AtomicBoolean[] getRemoteBackPressureStatus() {
        return this.remoteBackPressureStatus;
    }

    public Utils.SmartThread makeTransferThread() {
        return Utils.asyncLoop(() -> {
            if (this.transferQueue.consume(this) == 0) {
                return 1L;
            }
            return 0L;
        });
    }

    @Override
    public void accept(Object tuple) {
        TaskMessage tm = (TaskMessage)tuple;
        this.drainer.add(tm);
    }

    @Override
    public void flush() throws InterruptedException {
        ReentrantReadWriteLock.ReadLock readLock = this.workerState.endpointSocketLock.readLock();
        try {
            readLock.lock();
            this.drainer.send(this.workerState.cachedTaskToNodePort.get(), this.workerState.cachedNodeToPortSocket.get());
        }
        finally {
            readLock.unlock();
        }
        this.drainer.clear();
    }

    public boolean tryTransferRemote(AddressedTuple addressedTuple, Queue<AddressedTuple> pendingEmits, ITupleSerializer serializer) {
        if (pendingEmits != null && !pendingEmits.isEmpty()) {
            pendingEmits.add(addressedTuple);
            return false;
        }
        if (!this.remoteBackPressureStatus[addressedTuple.dest].get()) {
            TaskMessage tm = new TaskMessage(addressedTuple.getDest(), serializer.serialize(addressedTuple.getTuple()));
            if (this.transferQueue.tryPublish(tm)) {
                return true;
            }
        } else {
            LOG.debug("Noticed Back Pressure in remote task {}", (Object)addressedTuple.dest);
        }
        if (pendingEmits != null) {
            pendingEmits.add(addressedTuple);
        }
        return false;
    }

    public void flushRemotes() throws InterruptedException {
        this.transferQueue.flush();
    }

    public boolean tryFlushRemotes() {
        return this.transferQueue.tryFlush();
    }

    public void haltTransferThd() {
        this.transferQueue.close();
    }
}

