/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cluster;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.storm.cluster.ExecutorBeat;
import org.apache.storm.cluster.VersionedData;
import org.apache.storm.generated.Assignment;
import org.apache.storm.generated.ClusterWorkerHeartbeat;
import org.apache.storm.generated.Credentials;
import org.apache.storm.generated.ErrorInfo;
import org.apache.storm.generated.ExecutorInfo;
import org.apache.storm.generated.LogConfig;
import org.apache.storm.generated.NimbusSummary;
import org.apache.storm.generated.NodeInfo;
import org.apache.storm.generated.PrivateWorkerKey;
import org.apache.storm.generated.ProfileRequest;
import org.apache.storm.generated.StormBase;
import org.apache.storm.generated.SupervisorInfo;
import org.apache.storm.generated.WorkerTokenServiceType;
import org.apache.storm.nimbus.NimbusInfo;

public interface IStormClusterState {
    public List<String> assignments(Runnable var1);

    public Assignment assignmentInfo(String var1, Runnable var2);

    public Assignment remoteAssignmentInfo(String var1, Runnable var2);

    public Map<String, Assignment> assignmentsInfo();

    public void syncRemoteAssignments(Map<String, byte[]> var1);

    public boolean isAssignmentsBackendSynchronized();

    public boolean isPacemakerStateStore();

    public void setAssignmentsBackendSynchronized();

    public VersionedData<Assignment> assignmentInfoWithVersion(String var1, Runnable var2);

    public Integer assignmentVersion(String var1, Runnable var2) throws Exception;

    public List<String> blobstoreInfo(String var1);

    public List<NimbusSummary> nimbuses();

    public void addNimbusHost(String var1, NimbusSummary var2);

    public List<String> activeStorms();

    public StormBase stormBase(String var1, Runnable var2);

    public String stormId(String var1);

    public void syncRemoteIds(Map<String, String> var1);

    public ClusterWorkerHeartbeat getWorkerHeartbeat(String var1, String var2, Long var3);

    public List<ProfileRequest> getWorkerProfileRequests(String var1, NodeInfo var2);

    public List<ProfileRequest> getTopologyProfileRequests(String var1);

    public void setWorkerProfileRequest(String var1, ProfileRequest var2);

    public void deleteTopologyProfileRequests(String var1, ProfileRequest var2);

    public Map<ExecutorInfo, ExecutorBeat> executorBeats(String var1, Map<List<Long>, NodeInfo> var2);

    public List<String> supervisors(Runnable var1);

    public SupervisorInfo supervisorInfo(String var1);

    public void setupHeatbeats(String var1, Map<String, Object> var2);

    public void teardownHeartbeats(String var1);

    public void teardownTopologyErrors(String var1);

    public List<String> heartbeatStorms();

    public List<String> errorTopologies();

    @Deprecated
    public List<String> backpressureTopologies();

    public NimbusInfo getLeader(Runnable var1);

    public void setTopologyLogConfig(String var1, LogConfig var2, Map<String, Object> var3);

    public LogConfig topologyLogConfig(String var1, Runnable var2);

    public void workerHeartbeat(String var1, String var2, Long var3, ClusterWorkerHeartbeat var4);

    public void removeWorkerHeartbeat(String var1, String var2, Long var3);

    public void supervisorHeartbeat(String var1, SupervisorInfo var2);

    @Deprecated
    public boolean topologyBackpressure(String var1, long var2, Runnable var4);

    @Deprecated
    public void setupBackpressure(String var1, Map<String, Object> var2);

    @Deprecated
    public void removeBackpressure(String var1);

    @Deprecated
    public void removeWorkerBackpressure(String var1, String var2, Long var3);

    public void activateStorm(String var1, StormBase var2, Map<String, Object> var3);

    public void updateStorm(String var1, StormBase var2);

    public void removeStormBase(String var1);

    public void setAssignment(String var1, Assignment var2, Map<String, Object> var3);

    public void setupBlob(String var1, NimbusInfo var2, Integer var3);

    public List<String> activeKeys();

    public List<String> blobstore(Runnable var1);

    public void removeStorm(String var1);

    public void removeBlobstoreKey(String var1);

    public void removeKeyVersion(String var1);

    public void reportError(String var1, String var2, String var3, Long var4, Throwable var5);

    public void setupErrors(String var1, Map<String, Object> var2);

    public List<ErrorInfo> errors(String var1, String var2);

    public ErrorInfo lastError(String var1, String var2);

    public void setCredentials(String var1, Credentials var2, Map<String, Object> var3);

    public Credentials credentials(String var1, Runnable var2);

    public void disconnect();

    public PrivateWorkerKey getPrivateWorkerKey(WorkerTokenServiceType var1, String var2, long var3);

    public void addPrivateWorkerKey(WorkerTokenServiceType var1, String var2, long var3, PrivateWorkerKey var5);

    public long getNextPrivateWorkerKeyVersion(WorkerTokenServiceType var1, String var2);

    public void removeExpiredPrivateWorkerKeys(String var1);

    public void removeAllPrivateWorkerKeys(String var1);

    public Set<String> idsOfTopologiesWithPrivateWorkerKeys();

    default public Map<String, SupervisorInfo> allSupervisorInfo() {
        return this.allSupervisorInfo(null);
    }

    default public Map<String, SupervisorInfo> allSupervisorInfo(Runnable callback) {
        HashMap<String, SupervisorInfo> ret = new HashMap<String, SupervisorInfo>();
        for (String id : this.supervisors(callback)) {
            SupervisorInfo supervisorInfo = this.supervisorInfo(id);
            if (supervisorInfo == null) continue;
            ret.put(id, supervisorInfo);
        }
        return ret;
    }

    default public Optional<String> getTopoId(String topologyName) {
        return Optional.ofNullable(this.stormId(topologyName));
    }

    default public Map<String, StormBase> topologyBases() {
        HashMap<String, StormBase> stormBases = new HashMap<String, StormBase>();
        for (String topologyId : this.activeStorms()) {
            StormBase base = this.stormBase(topologyId, null);
            if (base == null) continue;
            stormBases.put(topologyId, base);
        }
        return stormBases;
    }
}

