/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.ui.resources;

import com.codahale.metrics.Meter;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.storm.daemon.ui.UIHelpers;
import org.apache.storm.daemon.ui.resources.AuthNimbusOp;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.thrift.TException;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.NimbusClient;
import org.apache.storm.utils.Utils;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class StormApiResource {
    public static final Logger LOG = LoggerFactory.getLogger(StormApiResource.class);
    public static final String callbackParameterName = "callback";
    @Context
    private HttpServletRequest servletRequest;
    public static Map<String, Object> config = ConfigUtils.readStormConfig();
    private final Meter clusterConfigurationRequestMeter;
    private final Meter clusterSummaryRequestMeter;
    private final Meter nimbusSummaryRequestMeter;
    private final Meter supervisorRequestMeter;
    private final Meter supervisorSummaryRequestMeter;
    private final Meter allTopologiesSummaryRequestMeter;
    private final Meter topologyPageRequestMeter;
    private final Meter topologyMetricRequestMeter;
    private final Meter buildVisualizationRequestMeter;
    private final Meter mkVisualizationDataRequestMeter;
    private final Meter componentPageRequestMeter;
    private final Meter logConfigRequestMeter;
    private final Meter activateTopologyRequestMeter;
    private final Meter deactivateTopologyRequestMeter;
    private final Meter debugTopologyRequestMeter;
    private final Meter componentOpResponseRequestMeter;
    private final Meter topologyOpResponseMeter;
    private final Meter topologyLagRequestMeter;
    private final Meter getOwnerResourceSummariesMeter;

    @Inject
    public StormApiResource(StormMetricsRegistry metricsRegistry) {
        this.clusterConfigurationRequestMeter = metricsRegistry.registerMeter("ui:num-cluster-configuration-http-requests");
        this.clusterSummaryRequestMeter = metricsRegistry.registerMeter("ui:num-cluster-summary-http-requests");
        this.nimbusSummaryRequestMeter = metricsRegistry.registerMeter("ui:num-nimbus-summary-http-requests");
        this.supervisorRequestMeter = metricsRegistry.registerMeter("ui:num-supervisor-http-requests");
        this.supervisorSummaryRequestMeter = metricsRegistry.registerMeter("ui:num-supervisor-summary-http-requests");
        this.allTopologiesSummaryRequestMeter = metricsRegistry.registerMeter("ui:num-all-topologies-summary-http-requests");
        this.topologyPageRequestMeter = metricsRegistry.registerMeter("ui:num-topology-page-http-requests");
        this.topologyMetricRequestMeter = metricsRegistry.registerMeter("ui:num-topology-metric-http-requests");
        this.buildVisualizationRequestMeter = metricsRegistry.registerMeter("ui:num-build-visualization-http-requests");
        this.mkVisualizationDataRequestMeter = metricsRegistry.registerMeter("ui:num-mk-visualization-data-http-requests");
        this.componentPageRequestMeter = metricsRegistry.registerMeter("ui:num-component-page-http-requests");
        this.logConfigRequestMeter = metricsRegistry.registerMeter("ui:num-log-config-http-requests");
        this.activateTopologyRequestMeter = metricsRegistry.registerMeter("ui:num-activate-topology-http-requests");
        this.deactivateTopologyRequestMeter = metricsRegistry.registerMeter("ui:num-deactivate-topology-http-requests");
        this.debugTopologyRequestMeter = metricsRegistry.registerMeter("ui:num-debug-topology-http-requests");
        this.componentOpResponseRequestMeter = metricsRegistry.registerMeter("ui:num-component-op-response-http-requests");
        this.topologyOpResponseMeter = metricsRegistry.registerMeter("ui:num-topology-op-response-http-requests");
        this.topologyLagRequestMeter = metricsRegistry.registerMeter("ui:num-topology-lag-http-requests");
        this.getOwnerResourceSummariesMeter = metricsRegistry.registerMeter("ui:num-get-owner-resource-summaries-http-request");
    }

    @GET
    @Path(value="/cluster/configuration")
    @Produces(value={"application/json"})
    public Response getClusterConfiguration(@QueryParam(value="callback") String callback) throws TException {
        this.clusterConfigurationRequestMeter.mark();
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            Response response = UIHelpers.makeStandardResponse(nimbusClient.getClient().getNimbusConf(), callback, false, Response.Status.OK);
            return response;
        }
    }

    @GET
    @Path(value="/cluster/summary")
    @AuthNimbusOp(value="getClusterInfo")
    @Produces(value={"application/json"})
    public Response getClusterSummary(@QueryParam(value="callback") String callback) throws TException {
        this.clusterSummaryRequestMeter.mark();
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            String user = this.servletRequest.getRemoteUser();
            Response response = UIHelpers.makeStandardResponse(UIHelpers.getClusterSummary(nimbusClient.getClient().getClusterInfo(), user, config), callback);
            return response;
        }
    }

    @GET
    @Path(value="/nimbus/summary")
    @AuthNimbusOp(value="getClusterInfo")
    @Produces(value={"application/json"})
    public Response getNimbusSummary(@QueryParam(value="callback") String callback) throws TException {
        this.nimbusSummaryRequestMeter.mark();
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            Response response = UIHelpers.makeStandardResponse(UIHelpers.getNimbusSummary(nimbusClient.getClient().getClusterInfo(), config), callback);
            return response;
        }
    }

    @GET
    @Path(value="/owner-resources")
    @AuthNimbusOp(value="getOwnerResourceSummaries")
    @Produces(value={"application/json"})
    public Response getOwnerResources(@QueryParam(value="callback") String callback) throws TException {
        this.getOwnerResourceSummariesMeter.mark();
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            Response response = UIHelpers.makeStandardResponse(UIHelpers.getOwnerResourceSummaries(nimbusClient.getClient().getOwnerResourceSummaries(null), config), callback);
            return response;
        }
    }

    @GET
    @Path(value="/owner-resources/{id}")
    @AuthNimbusOp(value="getOwnerResourceSummaries")
    @Produces(value={"application/json"})
    public Response getOwnerResource(@PathParam(value="id") String id, @QueryParam(value="callback") String callback) throws TException {
        this.getOwnerResourceSummariesMeter.mark();
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            Response response = UIHelpers.makeStandardResponse(UIHelpers.getOwnerResourceSummary(nimbusClient.getClient().getOwnerResourceSummaries(id), nimbusClient.getClient(), id, config), callback);
            return response;
        }
    }

    @GET
    @Path(value="/history/summary")
    @Produces(value={"application/json"})
    public Response getHistorySummary(@QueryParam(value="callback") String callback) throws TException {
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            String user = this.servletRequest.getRemoteUser();
            Response response = UIHelpers.makeStandardResponse(UIHelpers.getTopologyHistoryInfo(nimbusClient.getClient().getTopologyHistory(user)), callback);
            return response;
        }
    }

    @GET
    @Path(value="/supervisor/summary")
    @AuthNimbusOp(value="getClusterInfo")
    @Produces(value={"application/json"})
    public Response getSupervisorSummary(@Context SecurityContext securityContext, @QueryParam(value="callback") String callback) throws TException {
        this.supervisorSummaryRequestMeter.mark();
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            Response response = UIHelpers.makeStandardResponse(UIHelpers.getSupervisorSummary(nimbusClient.getClient().getClusterInfo().get_supervisors(), securityContext, config), callback);
            return response;
        }
    }

    @GET
    @Path(value="/supervisor")
    @AuthNimbusOp(value="getSupervisorPageInfo")
    @Produces(value={"application/json"})
    public Response getSupervisor(@QueryParam(value="id") String id, @QueryParam(value="host") String host, @QueryParam(value="sys") boolean sys, @QueryParam(value="callback") String callback) throws TException {
        this.supervisorRequestMeter.mark();
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            Response response = UIHelpers.makeStandardResponse(UIHelpers.getSupervisorPageInfo(nimbusClient.getClient().getSupervisorPageInfo(id, host, sys), config), callback);
            return response;
        }
    }

    @GET
    @Path(value="/topology/summary")
    @AuthNimbusOp(value="getClusterInfo")
    @Produces(value={"application/json"})
    public Response getTopologySummary(@Context SecurityContext securityContext, @QueryParam(value="callback") String callback) throws TException {
        this.allTopologiesSummaryRequestMeter.mark();
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            Response response = UIHelpers.makeStandardResponse(UIHelpers.getAllTopologiesSummary(nimbusClient.getClient().getTopologySummaries(), config), callback);
            return response;
        }
    }

    @GET
    @Path(value="/topology/{id}")
    @AuthNimbusOp(value="getTopology", needsTopoId=true)
    @Produces(value={"application/json"})
    public Response getTopology(@PathParam(value="id") String id, @DefaultValue(value=":all-time") @QueryParam(value="window") String window, @QueryParam(value="sys") boolean sys, @QueryParam(value="callback") String callback) throws TException {
        this.topologyPageRequestMeter.mark();
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            Response response = UIHelpers.makeStandardResponse(UIHelpers.getTopologySummary(nimbusClient.getClient().getTopologyPageInfo(id, window, sys), window, config, this.servletRequest.getRemoteUser()), callback);
            return response;
        }
    }

    @GET
    @Path(value="/topology-workers/{id}")
    @AuthNimbusOp(value="getTopology", needsTopoId=true)
    @Produces(value={"application/json"})
    public Response getTopologyWorkers(@PathParam(value="id") String id, @QueryParam(value="callback") String callback) throws TException {
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            id = Utils.urlDecodeUtf8((String)id);
            Response response = UIHelpers.makeStandardResponse(UIHelpers.getTopologyWorkers(nimbusClient.getClient().getTopologyInfo(id), config), callback);
            return response;
        }
    }

    @GET
    @Path(value="/topology/{id}/metrics")
    @AuthNimbusOp(value="getTopology", needsTopoId=true)
    @Produces(value={"application/json"})
    public Response getTopologyMetrics(@PathParam(value="id") String id, @DefaultValue(value=":all-time") @QueryParam(value="window") String window, @QueryParam(value="sys") boolean sys, @QueryParam(value="callback") String callback) throws TException {
        this.topologyMetricRequestMeter.mark();
        String user = this.servletRequest.getRemoteUser();
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            Response response = UIHelpers.makeStandardResponse(UIHelpers.getTopologySummary(nimbusClient.getClient().getTopologyPageInfo(id, window, sys), window, config, user), callback);
            return response;
        }
    }

    @GET
    @Path(value="/topology/{id}/lag")
    @AuthNimbusOp(value="getTopology", needsTopoId=true)
    @Produces(value={"application/json"})
    public Response getTopologyLag(@PathParam(value="id") String id, @QueryParam(value="callback") String callback) throws TException {
        this.topologyLagRequestMeter.mark();
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            Response response = UIHelpers.makeStandardResponse(UIHelpers.getTopologyLag(nimbusClient.getClient().getTopology(id), config), callback);
            return response;
        }
    }

    @GET
    @Path(value="/topology/{id}/visualization-init")
    @AuthNimbusOp(value="getTopology", needsTopoId=true)
    @Produces(value={"application/json"})
    public Response getTopologyVisializationInit(@PathParam(value="id") String id, @QueryParam(value="sys") boolean sys, @QueryParam(value="callback") String callback, @DefaultValue(value=":all-time") @QueryParam(value="window") String window) throws TException {
        this.mkVisualizationDataRequestMeter.mark();
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            Response response = UIHelpers.makeStandardResponse(UIHelpers.getBuildVisualization(nimbusClient.getClient(), config, window, id, sys), callback);
            return response;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/topology/{id}/visualization")
    @AuthNimbusOp(value="getTopology", needsTopoId=true)
    @Produces(value={"application/json"})
    public Response getTopologyVisualization(@PathParam(value="id") String id, @QueryParam(value="sys") boolean sys, @QueryParam(value="callback") String callback, @DefaultValue(value=":all-time") @QueryParam(value="window") String window) throws TException {
        this.buildVisualizationRequestMeter.mark();
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            Response response = UIHelpers.makeStandardResponse(UIHelpers.getVisualizationData(nimbusClient.getClient(), window, id, sys), callback);
            return response;
        }
        catch (RuntimeException e) {
            LOG.error("Failure getting topology visualization", (Throwable)e);
            throw e;
        }
    }

    @GET
    @Path(value="/topology/{id}/component/{component}")
    @AuthNimbusOp(value="getTopology", needsTopoId=true)
    @Produces(value={"application/json"})
    public Response getTopologyComponent(@PathParam(value="id") String id, @PathParam(value="component") String component, @QueryParam(value="sys") boolean sys, @QueryParam(value="callback") String callback, @DefaultValue(value=":all-time") @QueryParam(value="window") String window) throws TException {
        this.componentPageRequestMeter.mark();
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            String user = this.servletRequest.getRemoteUser();
            Response response = UIHelpers.makeStandardResponse(UIHelpers.getComponentPage(nimbusClient.getClient(), id, component, window, sys, user, config), callback);
            return response;
        }
    }

    @GET
    @Path(value="/topology/{id}/logconfig")
    @AuthNimbusOp(value="getTopology", needsTopoId=true)
    @Produces(value={"application/json"})
    public Response getTopologyLogconfig(@PathParam(value="id") String id, @QueryParam(value="callback") String callback) throws TException {
        this.logConfigRequestMeter.mark();
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            Response response = UIHelpers.makeStandardResponse(UIHelpers.getTopolgoyLogConfig(nimbusClient.getClient().getLogConfig(id)), callback);
            return response;
        }
    }

    @POST
    @Path(value="/topology/{id}/logconfig")
    @AuthNimbusOp(value="setLogConfig", needsTopoId=true)
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response putTopologyLogconfig(@PathParam(value="id") String id, String body, @QueryParam(value="callback") String callback) throws TException {
        this.topologyOpResponseMeter.mark();
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            Response response = UIHelpers.makeStandardResponse(UIHelpers.putTopologyLogLevel(nimbusClient.getClient(), (Map)((Map)JSONValue.parse((String)body)).get("namedLoggerLevels"), id), callback);
            return response;
        }
    }

    @POST
    @Path(value="/topology/{id}/activate")
    @AuthNimbusOp(value="activate", needsTopoId=true)
    @Produces(value={"application/json"})
    public Response putTopologyActivate(@PathParam(value="id") String id, @QueryParam(value="callback") String callback) throws TException {
        this.activateTopologyRequestMeter.mark();
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            Response response = UIHelpers.makeStandardResponse(UIHelpers.putTopologyActivate(nimbusClient.getClient(), id), callback);
            return response;
        }
    }

    @POST
    @Path(value="/topology/{id}/deactivate")
    @AuthNimbusOp(value="deactivate", needsTopoId=true)
    @Produces(value={"application/json"})
    public Response putTopologyDeactivate(@PathParam(value="id") String id, @QueryParam(value="callback") String callback) throws TException {
        this.deactivateTopologyRequestMeter.mark();
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            Response response = UIHelpers.makeStandardResponse(UIHelpers.putTopologyDeactivate(nimbusClient.getClient(), id), callback);
            return response;
        }
    }

    @POST
    @Path(value="/topology/{id}/debug/{action}/{spct}")
    @AuthNimbusOp(value="debug", needsTopoId=true)
    @Produces(value={"application/json"})
    public Response putTopologyDebugActionSpct(@PathParam(value="id") String id, @PathParam(value="action") String action, @PathParam(value="spct") String spct, @QueryParam(value="callback") String callback) throws TException {
        this.debugTopologyRequestMeter.mark();
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            Response response = UIHelpers.makeStandardResponse(UIHelpers.putTopologyDebugActionSpct(nimbusClient.getClient(), id, action, spct, ""), callback);
            return response;
        }
    }

    @POST
    @Path(value="/topology/{id}/component/{component}/debug/{action}/{spct}")
    @AuthNimbusOp(value="debug", needsTopoId=true)
    @Produces(value={"application/json"})
    public Response putTopologyComponentDebugActionSpct(@PathParam(value="id") String id, @PathParam(value="component") String component, @PathParam(value="action") String action, @PathParam(value="spct") String spct, @QueryParam(value="callback") String callback) throws TException {
        this.componentOpResponseRequestMeter.mark();
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            Response response = UIHelpers.makeStandardResponse(UIHelpers.putTopologyDebugActionSpct(nimbusClient.getClient(), id, component, action, spct), callback);
            return response;
        }
    }

    @POST
    @Path(value="/topology/{id}/rebalance/{wait-time}")
    @AuthNimbusOp(value="rebalance", needsTopoId=true)
    @Produces(value={"application/json"})
    public Response putTopologyRebalance(@PathParam(value="id") String id, @PathParam(value="wait-time") String waitTime, @QueryParam(value="callback") String callback) throws TException {
        this.topologyOpResponseMeter.mark();
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            Response response = UIHelpers.makeStandardResponse(UIHelpers.putTopologyRebalance(nimbusClient.getClient(), id, waitTime), callback);
            return response;
        }
    }

    @POST
    @Path(value="/topology/{id}/kill/{wait-time}")
    @AuthNimbusOp(value="killTopology", needsTopoId=true)
    @Produces(value={"application/json"})
    public Response putTopologyKill(@PathParam(value="id") String id, @PathParam(value="wait-time") String waitTime, @QueryParam(value="callback") String callback) throws TException {
        this.topologyOpResponseMeter.mark();
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            Response response = UIHelpers.makeStandardResponse(UIHelpers.putTopologyKill(nimbusClient.getClient(), id, waitTime), callback);
            return response;
        }
    }

    @GET
    @Path(value="/topology/{id}/profiling/start/{host-port}/{timeout}")
    @AuthNimbusOp(value="setWorkerProfiler", needsTopoId=true)
    @Produces(value={"application/json"})
    public Response getTopologyProfilingStart(@PathParam(value="id") String id, @PathParam(value="host-port") String hostPort, @PathParam(value="timeout") String timeout, @QueryParam(value="callback") String callback) throws TException {
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            Response response = UIHelpers.makeStandardResponse(UIHelpers.getTopologyProfilingStart(nimbusClient.getClient(), id, hostPort, timeout, config), callback);
            return response;
        }
    }

    @GET
    @Path(value="/topology/{id}/profiling/stop/{host-port}")
    @AuthNimbusOp(value="setWorkerProfiler", needsTopoId=true)
    @Produces(value={"application/json"})
    public Response getTopologyProfilingStop(@PathParam(value="id") String id, @PathParam(value="host-port") String hostPort, @QueryParam(value="callback") String callback) throws TException {
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            Response response = UIHelpers.makeStandardResponse(UIHelpers.getTopologyProfilingStop(nimbusClient.getClient(), id, hostPort, config), callback);
            return response;
        }
    }

    @GET
    @Path(value="/topology/{id}/profiling/dumpprofile/{host-port}")
    @AuthNimbusOp(value="setWorkerProfiler", needsTopoId=true)
    @Produces(value={"application/json"})
    public Response getTopologyProfilingDumpProfile(@PathParam(value="id") String id, @PathParam(value="host-port") String hostPort, @QueryParam(value="callback") String callback) throws TException {
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            Response response = UIHelpers.makeStandardResponse(UIHelpers.getTopologyProfilingDump(nimbusClient.getClient(), id, hostPort, config), callback);
            return response;
        }
    }

    @GET
    @Path(value="/topology/{id}/profiling/dumpjstack/{host-port}")
    @AuthNimbusOp(value="setWorkerProfiler", needsTopoId=true)
    @Produces(value={"application/json"})
    public Response getTopologyProfilingDumpJstack(@PathParam(value="id") String id, @PathParam(value="host-port") String hostPort, @QueryParam(value="callback") String callback) throws TException {
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            Response response = UIHelpers.makeStandardResponse(UIHelpers.getTopologyProfilingDumpJstack(nimbusClient.getClient(), id, hostPort, config), callback);
            return response;
        }
    }

    @GET
    @Path(value="/topology/{id}/profiling/restartworker/{host-port}")
    @AuthNimbusOp(value="setWorkerProfiler", needsTopoId=true)
    @Produces(value={"application/json"})
    public Response getTopologyProfilingRestartWorker(@PathParam(value="id") String id, @PathParam(value="host-port") String hostPort, @QueryParam(value="callback") String callback) throws TException {
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            Response response = UIHelpers.makeStandardResponse(UIHelpers.getTopologyProfilingRestartWorker(nimbusClient.getClient(), id, hostPort, config), callback);
            return response;
        }
    }

    @GET
    @Path(value="/topology/{id}/profiling/dumpheap/{host-port}")
    @AuthNimbusOp(value="setWorkerProfiler", needsTopoId=true)
    @Produces(value={"application/json"})
    public Response getTopologyProfilingDumpheap(@PathParam(value="id") String id, @PathParam(value="host-port") String hostPort, @QueryParam(value="callback") String callback) throws TException {
        try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(config);){
            Response response = UIHelpers.makeStandardResponse(UIHelpers.getTopologyProfilingDumpHeap(nimbusClient.getClient(), id, hostPort, config), callback);
            return response;
        }
    }
}

